/* # skkinput (Simple Kana-Kanji Input)
 * skksoc.c --- communicate with skkserv.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* skkserv ȤäʬޤȤ᤿*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>

#include "config.h"
#include "commondef.h"
#include "buffers.h"

/*
 * ץȥ
 */
/* skksvect.c */
extern void free_SkkinpSearchVector( SkkinpSearchVector **top ) ;
/* skksoc.c */
int skkinput_CloseCommunication( void ) ;

/* skkserv Ȥ̿ѤǤ륳ޥɤΰ*/
enum {
  SKKSERV_BYE = 0, SKKSERV_SEARCH, SKKSERV_VERSION, SKKSERV_HOSTNAME,
} ;

extern char *skkserv_host ;
extern char *skkserv_service ;
extern int skkserv_pf;

/* skkserv ȤäݤΥХåե*/
static struct MessageBuffer mesbuf ;
#if !USE_INET6
/* SKK server ξ*/
struct sockaddr_in server ;
/* SKK server  Host ξ*/
static struct hostent *host ;
#endif
/* skkserv äΤѤ socket */
static int skkserv_soc ;
/* skkserv ȤΤä˻Ȥեݥ󥿡*/
static FILE *read_skkserv_fp = NULL, *write_skkserv_fp = NULL ;
static int skkserv_connection_ok = False ;

/*
 * ץȥ
 */
/* skksvect.c */
SkkinpSearchVector *add_SkkinpSearchVector
( SkkinpSearchVector *topp,   struct myChar *str,
  SkkinpSearchVector **rnode, int *rpos ) ;
/* local */
static void clear_ServerSend( void ) ;
static SkkinpSearchVector *messagebuffer_to_searchVector
( SkkinpSearchVector *top, struct MessageBuffer *mesbuf ) ;
static void myCharStringToNormalString
( struct MessageBuffer *buf, struct myChar *string ) ;

#if !USE_INET6
/*
 * åȤؿ
 *------------
 * server ̾ͿȡФƤ socket 褦
 * Ȼߤ롣
 */
static int makeSocket( char *server_name, int port_num )
{
  struct protoent *proto;
  /* Protocol ꡣ*/
  if( ( proto = getprotobyname( "tcp" ) ) == NULL ){
    return 1 ;
  }
  /* åȤ */
  if( ( skkserv_soc = socket( AF_INET, SOCK_STREAM, proto->p_proto ) ) < 0 ){
    fprintf( stderr, "Cannot make socket.\n" ) ;
    return 1 ;
  }
  /* ФξФ*/
#ifdef HAVE_BZERO
  bzero( ( char *)&server, sizeof( server ) ) ;
#else
  memset( ( char *)&server, 0, sizeof( server ) ) ;
#endif
  server.sin_family = AF_INET ;
  if( ( host = gethostbyname( server_name ) ) == NULL ){
    shutdown( skkserv_soc, 2 ) ;
    close( skkserv_soc ) ;
    fprintf( stderr, "%s: Unknown host.\n", server_name ) ;
    return 1 ;
  }
#ifdef HAVE_BCOPY
  bcopy( host->h_addr, &server.sin_addr, host->h_length ) ;
#else
  memcpy( &server.sin_addr, host->h_addr, host->h_length ) ;
#endif
  server.sin_port = htons( port_num ) ;

  read_skkserv_fp  = fdopen( skkserv_soc, "r" ) ;
  write_skkserv_fp = fdopen( skkserv_soc, "w" ) ;

  /* fdopen ˼Ԥ */
  if( read_skkserv_fp == NULL || write_skkserv_fp == NULL ){
    if( read_skkserv_fp != NULL )
      fclose( read_skkserv_fp ) ;
    if( write_skkserv_fp != NULL )
      fclose( write_skkserv_fp ) ;
    read_skkserv_fp = write_skkserv_fp = NULL ;
    return 1 ; 
  }
  return 0 ;
}
#endif

/*
 * skkserv  message ؿ
 */
static int send_to_server( int funcno, struct myChar *string )
{
  /* 楳ɤ˴ְ㤤¸ߤʤ */
  switch( funcno ){
    /* 楳ɤΥޥɡ*/
  case SKKSERV_BYE :
  case SKKSERV_VERSION :
  case SKKSERV_HOSTNAME :
    /* С˹Ԥäߤǽꡣ*/
    fprintf( write_skkserv_fp, "%d\n", funcno ) ;
    fflush( write_skkserv_fp ) ;
    break ;

    /* äơʸɬפʥޥɡ*/
  case SKKSERV_SEARCH :
    /* С˹Ԥäߤǽ = ָפꡣ*/
    init_messagebuffer( &mesbuf ) ;
    /* ɤ̾ʸѴ롣*/
    myCharStringToNormalString( &mesbuf, string ) ;
#ifdef DEBUG
    printf( "To skkserv: \"%s\"\n", mesbuf.buffer ) ;
#endif
    fprintf( write_skkserv_fp, "1%s \n", mesbuf.buffer ) ;
    fflush( write_skkserv_fp ) ;
    close_messagebuffer( &mesbuf ) ;
    break ;

  default :
#ifdef DEBUG
    fprintf( stderr, "WARNING : Unknown function code.\n" ) ;
#endif
    return 1 ;
  }
  return 0 ;
}

/*
 * skkserv ʸؿ
 * ----
 * ɤΰ̤Ĺʸ󤬵äΤȽʤΤǡꥹȤǼ
 * Ȥˤʤ롣
 */
static SkkinpSearchVector *skkinput_ReadRequestsResult
( SkkinpSearchVector *top )
{
  /* С֤Хåե*/
  int i, ret, top_flag ;
  unsigned char pbuf ;

#ifdef DEBUG
  printf( "Wait for an answer....\n" ) ;
#endif

  /* åХåե롣*/
  init_messagebuffer( &mesbuf ) ;

  i = 0 ;
  top_flag = False ;

  for( ; ; ){
    /* server ʸ롣*/
    ret = read( skkserv_soc, &pbuf, 1 ) ;
    /* 顼ȯν*/
    if( ret <= 0 ){
      /* ԡ*/
      perror( "read" ) ;
      close_messagebuffer( &mesbuf ) ;
      /* ͥǤƶŪ˽ȴ롣*/
      skkinput_CloseCommunication() ;
      return top ;
    }
    /* skkserv ϤޤƬ˶֤ȤȤ򤷤Ƥ
       ǡΤƤ롣ζϤΥХ顣*/
    if( !top_flag && pbuf != '/' ){
      continue ;
    } else {
#ifdef DEBUG
      printf( "%c", pbuf ) ;
#endif
      top_flag = True ;
      add_messagebuffer( &mesbuf, pbuf ) ;
    }
    /* üʸɤ߹Τʤ顢λ롣skkserv νüʸ *
     * EOL(0x0a) Ǥ롣*/
    if( pbuf == 0x0a )
      break ;
  }
#ifdef DEBUG
  printf( "\n" ) ;
#endif
  top = messagebuffer_to_searchVector( top, &mesbuf ) ;
  /* åХåեĤ롣*/
  close_messagebuffer( &mesbuf ) ;
  return top ;
}

#if 0
/*
 * 饤ȤΥС뤿˥Ф̿ؿ
 */
char *skkinput_GetClientVersion( void )
{
  int i ;

  /* С˥饤ȤΥС֤褦ؼ롣*/
  send_to_server( SKKSERV_VERSION, NULL ) ;

  /* server ֤Сֹ롣*/
  i = 0 ;
  if( read( skkserv_soc, message_buffer, TEXTMAXLEN ) <= 0 ){
    perror( "read" ) ;
    return NULL ;
  }
  message_buffer[ TEXTMAXLEN ] = '\0' ;
  return message_buffer ;
}

/*
 * 饤ȤΥС뤿˥Ф̿ؿ
 */
char *skkinput_GetClientHost( void )
{
  /* С˥饤ȤΥС֤褦ؼ롣*/
  send_to_server( SKKSERV_HOSTNAME, NULL ) ;

  /* server ֤ hostname 롣*/
  if( read( skkserv_soc, message_buffer, TEXTMAXLEN ) <= 0 ){
    perror( "read" ) ;
    return NULL ;
  }
  message_buffer[ TEXTMAXLEN ] = '\0' ;
  return message_buffer ;
}
#endif

/*
 * Фμ򥯥ꥢؿ
 */
static void clear_ServerSend( void )
{
  unsigned char pbuf ;

  for( ; ; ){
    if( read( skkserv_soc, &pbuf, 1 ) <= 0 ){
      /* ԡ*/
      perror( "read" ) ;
      skkinput_CloseCommunication() ;
      return ;
    }
    if( pbuf == 0x0a )
      break ;
  }
  return ;
}

/*
 * socket Ѱդskkerv ³ؿ
 *----
 */
int skkinput_StartCommunication( char *server_name, char *service_name, int pf )
{
#if USE_INET6
  struct addrinfo hints, *res, *res0;
  memset(&hints, 0, sizeof(hints));
  hints.ai_family = pf;
  hints.ai_socktype = SOCK_STREAM;

  if (getaddrinfo(server_name, service_name, &hints, &res0)) {
    fprintf(stderr, "Warning: cannot make a socket to %s:%s\n", 
	    server_name, service_name);
    skkserv_connection_ok = False;
    return 1;
  }

  skkserv_connection_ok = False;
  for (res = res0; res != NULL; res = res->ai_next) {
    skkserv_soc = socket(res->ai_family, res->ai_socktype, 0);
    if (skkserv_soc < 0) continue;

    if (connect(skkserv_soc, 
		(struct sockaddr *)res->ai_addr, res->ai_addrlen) < 0) {
      perror("connect");
      fprintf(stderr, "Warning: cannot connect SKK server.\n");
      shutdown(skkserv_soc, 2);
      close(skkserv_soc);
      skkserv_connection_ok = False;
      skkserv_soc = -1;
      continue;
    } else {
      skkserv_connection_ok = True;
      break;
    }
  }

  /* free addrinfo */
  freeaddrinfo (res0);

  if (skkserv_soc < 0 || skkserv_connection_ok == False) {
    fprintf(stderr, "Warning: cannot connect to SKK server, give up.\n");
    skkserv_connection_ok = False;
    return 1;
  }

  read_skkserv_fp = fdopen(skkserv_soc, "r");
  write_skkserv_fp = fdopen(skkserv_soc, "w");
  if (read_skkserv_fp == NULL || write_skkserv_fp == NULL) {
    if (read_skkserv_fp != NULL) fclose(read_skkserv_fp);
    if (write_skkserv_fp != NULL) fclose(write_skkserv_fp);
    read_skkserv_fp = write_skkserv_fp = NULL;
    shutdown(skkserv_soc, 2);
    close(skkserv_soc);
    skkserv_connection_ok = False;
    fprintf(stderr, "Warning: cannot make socket fd of SKK server connection.\n");
    return 1;
  }
#else
  /* IPv4 only */
  struct servent *se = getservbyname(service_name, SKKSERV_SERVICE_PROTO);
  short port_num = atoi(DEFAULT_SKKPORT);
  if (se)
      port_num = ntohs(se->s_port);
  /* skkerv ̿뤿ΥåȤפޤ*/
  if( makeSocket( server_name, port_num ) ){
    fprintf( stderr, "Warning : cannot make a socket." ) ;
    skkserv_connection_ok = False ;
    return 1 ;
  }
  /* ³׵ᡣ*/
  if( connect( skkserv_soc, 
	       ( struct sockaddr *)&server, sizeof( server ) ) < 0 ){
    perror( "connect" ) ;
    fprintf( stderr, "Warning : cannot connect SKK server." ) ;
    shutdown( skkserv_soc, 2 ) ;
    close( skkserv_soc ) ;
    skkserv_connection_ok = False ;
    return 1 ;
  }
  skkserv_connection_ok = True ;
#endif
  return 0 ;
}

/*
 * SKK server Ȥ³λؿ
 *----
 * λˤɬٸƤФ줿ɤȻפؿǤ롣
 */
int skkinput_CloseCommunication( void )
{
  /* ³ƤʤСǤǤʤ*/
  if( !skkserv_connection_ok )
    return 0 ;
  /* fp Ĥ롣*/
  if( write_skkserv_fp != NULL ){
    /* SKK server ˡ֤褦ʤפ롣*/
    send_to_server( SKKSERV_BYE, NULL ) ;
    fclose( write_skkserv_fp ) ;
    write_skkserv_fp = NULL ;
  }
  if( read_skkserv_fp != NULL ){
    fclose( read_skkserv_fp ) ;
    read_skkserv_fp = NULL ;
  }
  /* ⤦ socket ѤʤȤ롣*/
  shutdown( skkserv_soc, 2 ) ;
  /* Socket Ĥ롣*/
  close( skkserv_soc ) ;
  skkserv_connection_ok = False ;
  return 0 ;
}

/*
 * skkserv ˸ REQUEST ؿ
 *----
 * ϤϸǤ롣
 */
SkkinpSearchVector *skkinput_Request
( struct myChar *str, SkkinpSearchVector *top )
{
  unsigned char pbuf ;

#ifndef MAIKAI_SKKSERV_TO_CONNECT_SURU
  if( !skkserv_connection_ok ){
    if( skkinput_StartCommunication( skkserv_host, skkserv_service, skkserv_pf ) )
      return top ;
  }
#else
  /* skkserv ƤʤСå褦̵Τǽλ
     롣*/
  if( skkinput_StartCommunication( skkserv_host, skkserv_portnum ) )
    return top ;
#endif

  /* С˸Ԥ褦ؼ롣*/
  send_to_server( SKKSERV_SEARCH, str ) ;

  /* skkserv  connect ɤ֤Τǡ롣*/
  if( read( skkserv_soc, &pbuf, 1 ) <= 0 ){
    /* ԡ*/
    perror( "read" ) ;
    skkinput_CloseCommunication() ;
    return top ;
  }
  /* Сå롣*/
  switch( pbuf ){
    /* С顼֤ν*/
  case '0' :
#ifdef DEBUG
    fprintf( stderr, "SKK server error." ) ;
#endif
    break ;

    /* Сȸդäν*/
  case '1' :
    top = skkinput_ReadRequestsResult( top ) ;
    break ;

    /* СꥯȤǸդʤäν*/
  case '4' :
    /* Ѥʸ󤬤Τޤ֤ä롣*/
    /* ɤ߹Ǥ*/
    clear_ServerSend() ;
    break ;

    /* Сʣ client ʤȤʤơäƤ硣*/
  case '9' :
    fprintf( stderr, "SKK server has too many clients." ) ;
    break ;

  default :
    clear_ServerSend() ;
    break ;
  }
#ifdef MAIKAI_SKKSERV_TO_CONNECT_SURU
  /* ͥڤ褦ˤ롣*/
  skkinput_CloseCommunication() ;
#endif
  return top ;
}

/*
 * skkserv ƤʸɤѴơѴ
 * ̤ȤƵ褦ؼؿ
 */
static SkkinpSearchVector *messagebuffer_to_searchVector
( SkkinpSearchVector *top, struct MessageBuffer *mesbuf )
{
  struct myChar *string ;
#ifdef DEBUG
  printf( "From skkserv:\"%s\"\n", mesbuf->buffer ) ;
#endif
  /* skkserv 褿ʸɤѴ롣*/
  extendedUnixCode_stringToMycharset( mesbuf->buffer, &string ) ;
  /* search vector ȤϿ롣*/
  top = add_SkkinpSearchVector( top, string, NULL, NULL ) ;
  /* ʸ롣*/
  free( string ) ;
  return top ;
}

/*
 * ʸɤʤʸܸExtended Unix Code Ѵؿ
 *---
 * λ ISO8859_? Ȥ KBC Ȥ GBD ȤΤƤ뤳Ȥˤʤ롣
 * (羸)
 */
static void myCharStringToNormalString
( struct MessageBuffer *buf, struct myChar *string )
{
  for( ; !IS_END_OF_STRING( *string ) ; string ++ ){
    switch( string->charset ){
    case CHARSET_ISO8859_1 :
    case CHARSET_ISO8859_2 :
    case CHARSET_ISO8859_3 :
    case CHARSET_ISO8859_4 :
    case CHARSET_ISO8859_5 :
    case CHARSET_ISO8859_6 :
    case CHARSET_ISO8859_7 :
    case CHARSET_ISO8859_8 :
    case CHARSET_ISO8859_9 :
      /* ISO8859 ʸκȾ̤ʤ롣*/
      if( !( string->chara & 0x80 ) )
	add_messagebuffer( buf, string->chara ) ;
      break ;
    case CHARSET_JISX0201_1976 :
      if( string->chara & 0x80 ){
	add_messagebuffer( buf, 0x8E ) ;
	add_messagebuffer( buf, string->chara ) ;
      } else {
	add_messagebuffer( buf, string->chara & 0x7F ) ;
      }
      break ;
      /* JIS ⿷JIS ̵뤷 JISX0208_1983 Ȥ롣*/
    case CHARSET_JISX0208_1978 :
    case CHARSET_JISX0208_1983 :
      add_messagebuffer( buf, ( string->chara >> 8     ) | 0x80 ) ;
      add_messagebuffer( buf, ( string->chara & 0x00FF ) | 0x80 ) ;
      break ;
    case CHARSET_JISX0212_1990 :
      add_messagebuffer( buf, 0x8F ) ;
      add_messagebuffer( buf, ( string->chara >> 8     ) | 0x80 ) ;
      add_messagebuffer( buf, ( string->chara & 0x00FF ) | 0x80 ) ;
      break ;
    default :
      break ;
    }
  }
  return ;
}
