/****************************************************************************
** Liste des transferts FTP pour Scythia
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#include "transfers.h"

transfers::transfers(MyFtpTransferControl *ftpcontrol, QWidget * parent):QWidget(parent)
{
	ftpControl = ftpcontrol;

	setupUi(this);

	// On ajoute les colonnes nécessaires
	transferListWidget->setHeaderLabels(QStringList() << tr("Nom du fichier") <<
	                                    tr("Type de transfert") <<
	                                    trUtf8("Vitesse") << tr("Temps restant") <<
	                                    tr("Pourcentage"));

	transferListWidget->header()->setResizeMode(QHeaderView::ResizeToContents);
	transferListWidget->header()->setMovable(true);
	transferListWidget->setSortingEnabled(FALSE);

	connect(stopAllTransfersBtn, SIGNAL(clicked()), this, SLOT(slotRemoveAllTransfers()));
	connect(stopOneTransferBtn, SIGNAL(clicked()), this, SLOT(slotRemoveTransfers()));
	connect(transferUpBtn, SIGNAL(clicked()), this, SLOT(slotTransferUp()));
	connect(transferDownBtn, SIGNAL(clicked()), this, SLOT(slotTransferDown()));
	connect(transferListWidget, SIGNAL(rightButtonClickedOnItem(QTreeWidgetItem *, const QPoint &)),
	        SLOT(slotPopupTransfer(QTreeWidgetItem *, const QPoint &)));

	connect(ftpControl, SIGNAL(transferRapidityAndRemainTime(int, int, int, float)),
	        SLOT(slotTransferRapidityAndRemainTime(int, int, int, float)));

	connect(ftpControl, SIGNAL(transferListModified(const QList<MyTransfer>&)),
	        SLOT(slotTransferListModified(const QList<MyTransfer>&)));
}

void transfers::slotTransferRapidityAndRemainTime(int vitesseInKoSec, int remainMin, int remainSec, float pourcentage)
{
	QList<QTreeWidgetItem *> list = transferListWidget->itemsList ();
	foreach(QTreeWidgetItem *i, list)
	{
		TransferListItem *il = (TransferListItem*)i;
		if (il->transfer.isInProgress())
		{
			if (vitesseInKoSec <= 0)
				i->setText(2, "-------");
			else
				i->setText(2, QString::number(vitesseInKoSec) + " Ko/s");
			if (remainMin < 0) remainMin *= -1;
			if (remainSec < 0) remainSec *= -1;
			i->setText(3, QString::number(remainMin) + "'" + QString::number(remainSec) + "''");
			i->setText(4, QString::number(pourcentage) + "%");

			break;
		}
	}
}

void transfers::slotTransferListModified (const QList<MyTransfer> &transfersList)
{
	// On trouve l'item sélectionné
	const MyTransfer *selected = 0;
	QList<QTreeWidgetItem *> list = transferListWidget->selectedItems();
	if (!list.isEmpty())
		selected = &((TransferListItem*)list.first())->transfer;

	// On efface la liste
	transferListWidget->clear();

	if (transfersList.isEmpty())
		return;

	// On l'affiche (PAS DE FOREACH !!!!!! Ca copie les MyTransfer)
	for (int i=0; i<transfersList.size(); i++)
	{
		TransferListItem *item = new TransferListItem(transfersList[i], transferListWidget);
		// On le résélectionne si nécessaire
		if (selected && item->transfer == *selected)
			item->setSelected(true);
	}
}

void transfers::slotPopupTransfer(QTreeWidgetItem * item, const QPoint & pos)
{
	if (!item)
		return;
	transferListWidget->setItemSelected(item, TRUE);
	QMenu fileMenu(this);
	fileMenu.move(pos);
	fileMenu.addAction(QIcon(":/pixmaps/transfer_up.png"),
	                   trUtf8("Avancer transfert"), this, SLOT(slotTransferUp()));
	fileMenu.addAction(QIcon(":/pixmaps/transfer_down.png"),
	                   trUtf8("Reculer transfert"), this, SLOT(slotTransferDown()));
	fileMenu.addSeparator();
	fileMenu.addAction(QIcon(":/pixmaps/stopTransfert.png"),
	                   trUtf8("Arrêter"), this, SLOT(slotRemoveTransfers()));
	fileMenu.addAction(QIcon(":/pixmaps/stopAllTransfert.png"),
	                   trUtf8("Arrêter Tout"), this, SLOT(slotRemoveAllTransfers()));
	fileMenu.exec();
}

void transfers::slotTransferUp()
{
	TransferListItem *i = (TransferListItem*)(transferListWidget->firstSelectedItem());
	if (i)
		ftpControl->upTransfer(i->transfer);
}

void transfers::slotTransferDown()
{
	TransferListItem *i = (TransferListItem*)(transferListWidget->firstSelectedItem());
	if (i)
		ftpControl->downTransfer(i->transfer);
}

void transfers::slotRemoveTransfers()
{
	/****** Pour gérer la multisélection
	QList<QTreeWidgetItem*> list = transferListWidget->selectedItems();
	foreach(QTreeWidgetItem *i, list)
	ftpControl->removeTransfer(((TransferListItem*)i)->transfer);*/

	TransferListItem *i = (TransferListItem*) transferListWidget->firstSelectedItem();
	if (i)
	{
		int index = transferListWidget->indexOfTopLevelItem(i);
		ftpControl->removeTransfer(i->transfer);
		QTreeWidgetItem *nextSelected = transferListWidget->topLevelItem(index);
		if (nextSelected)
			nextSelected->setSelected(true);
	}
}

void transfers::slotRemoveAllTransfers()
{
	ftpControl->removeAllTransfers();
}
