/***************************************************************************
 *   Copyleft (C) 2004 by Cocophotos                                       *
 *   cocophotos@hotmail.com                                                *
 *   Sous licence GPL v2 ou plus                                           *
 ***************************************************************************/

#include "scythia.h"
#include "aide.h"
#include "ftpconnect.h"
#include "ftpsignet.h"
#include "choose_prog.h"
#include "BasicDialog/basicdialog.h"

extern QString CheminConf;
extern QString CheminTrad;
extern QString Language;
extern QTranslator *translator;

/**************************Classe Principale*********************************/
scythia::scythia(QWidget * parent):QMainWindow(parent)
{
	setupUi(this);
	systemTray = false;

	// Create the menu that will be used for the context menu
	menu = new QMenu(this);
	menu->addAction(QPixmap(":pixmaps/hiddenfiles.png"),
	                tr("&Afficher Scythia"), this, SLOT(showOrHide()));
	menu->addSeparator();
	menu->addAction(QPixmap(":pixmaps/exit.png"), tr("&Quitter"), qApp,
	                SLOT(quit()));

	// Create the tray icon
	trayIcon = new QSystemTrayIcon(this);
	trayIcon->setIcon(QIcon(":pixmaps/network.png"));
	trayIcon->setToolTip("Scythia");
	trayIcon->setContextMenu(menu);

	connect(trayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, SLOT(trayIconActivated(QSystemTrayIcon::ActivationReason)));
	trayIcon->show();

	connect(quitAction, SIGNAL(triggered(bool)), qApp, SLOT(quit()));
	connect(closeConnectAction, SIGNAL(triggered(bool)), this, SLOT(slotDisconnect()));
	connect(helpAction, SIGNAL(triggered(bool)), this, SLOT(slotHelp()));
	connect(rapidConnectAction, SIGNAL(triggered(bool)), this, SLOT(slotConnect()));
	connect(affichToolbarConnect, SIGNAL(triggered(bool)), this,
	        SLOT(slotAffichToolbarConnect()));
	connect(hideToolbarConnect, SIGNAL(triggered(bool)), this,
	        SLOT(slotHideToolbarConnect()));
	connect(newFolder, SIGNAL(triggered(bool)), this, SLOT(slotNewFolder()));
	connect(removeFile, SIGNAL(triggered(bool)), this, SLOT(slotRemoveFile()));
	connect(renameFile, SIGNAL(triggered(bool)), this, SLOT(slotRenameFile()));
	connect(reloadLocalList, SIGNAL(triggered(bool)), this, SLOT(slotReloadLocalList()));
	connect(reloadFtpList, SIGNAL(triggered(bool)), this, SLOT(slotReloadFtpList()));
	connect(localPathEdit, SIGNAL(returnPressed()), this,
	        SLOT(slotLocalPathChanged()));
	connect(affichToolbarFile, SIGNAL(triggered(bool)), this,
	        SLOT(slotAffichToolbarFile()));
	connect(affichToolbarTransfert, SIGNAL(triggered(bool)), this,
	        SLOT(slotAffichToolbarTransfert()));
	connect(hideToolbarFile, SIGNAL(triggered(bool)), this, SLOT(slotHideToolbarFile()));
	connect(hideToolbarTransfert, SIGNAL(triggered(bool)), this,
	        SLOT(slotHideToolbarTransfert()));
	connect(ftpPathEdit, SIGNAL(returnPressed()), this, SLOT(slotFtpPathChanged()));
	connect(programmes, SIGNAL(triggered(bool)), this, SLOT(slotExecProg()));
	connect(uploadButton, SIGNAL(clicked()), this, SLOT(slot_upload()));
	connect(downloadButton, SIGNAL(clicked()), this, SLOT(slot_download()));
	connect(hiddenFiles, SIGNAL(triggered(bool)), this, SLOT(slotHiddenFiles()));
	connect(addFtpAction, SIGNAL(triggered(bool)), this, SLOT(slotAddSignet()));
	connect(commandFtp, SIGNAL(triggered(bool)), this, SLOT(slotCommand()));
	connect(selectLang, SIGNAL(triggered(bool)), this, SLOT(slotSelectLang()));

	// On arrange un peu le splitter vertical en augmentant la taille de la partie
	// supérieure
	verticalSplitter->setStretchFactor(0, 2);

	// On crée le MyFtp
	ftp = new MyFtp(ftpList, localList, ftpPathEdit, localPathEdit);

	// On crée l'ui transfert avec le ftp en param
	QVBoxLayout *layout = new QVBoxLayout(transfersGroup);
	transfersWidget = new transfers(ftp);
	layout->addWidget(transfersWidget);
	connect(stopAllTransfertAction, SIGNAL(triggered(bool)), transfersWidget,
	        SLOT(slotRemoveAllTransfers()));
	connect(stopTransferAction, SIGNAL(triggered(bool)), transfersWidget, SLOT(slotRemoveTransfers()));

	affichToolbarConnect->setVisible(false);
	affichToolbarFile->setVisible(false);
	affichToolbarTransfert->setVisible(false);

	// On crée les labels et les affiche
	QLabel *begin = new QLabel(this);
	begin->setText(tr("<font color =\"#61b9e2\">Statut :</font>"));
	statusBar()->addPermanentWidget(begin);

	stateLabel = new QLabel(this);
	stateLabel->setText(trUtf8("<font color =\"#ff0000\">Déconnecté</font>"));
	statusBar()->addPermanentWidget(stateLabel);

	connectLabel = new QLabel(this);
	connectLabel->setPixmap(QPixmap(":/pixmaps/connect_no.png"));
	statusBar()->addPermanentWidget(connectLabel);

	waitLabel = new QLabel(this);
	waitLabel->setPixmap(QPixmap(":/pixmaps/network.png"));
	statusBar()->addPermanentWidget(waitLabel);

	// On lit les fichiers de config
	QFile conf(CheminConf + "scythia-progs");
	if (conf.open(QIODevice::ReadOnly))
	{
		// Lit tout le fichier et le met dans la liste
		listProgs = QString(conf.readAll());
		conf.close();
	}

	connect(ftpList, SIGNAL(buttonClicked(QTreeWidgetItem *)),
	        SLOT(slotFtpSelection(QTreeWidgetItem *)));
	connect(localList, SIGNAL(buttonClicked(QTreeWidgetItem *)),
	        SLOT(slotLocalSelection(QTreeWidgetItem *)));
	connect(transfersWidget->transferListWidget, SIGNAL(buttonClicked(QTreeWidgetItem *)),
	        SLOT(slotTransferSelection(QTreeWidgetItem *)));
	connect(transfersWidget->transferListWidget, SIGNAL(buttonClicked(QTreeWidgetItem *)),
	        SLOT(slotTransferSelection(QTreeWidgetItem *)));
	connect(ftpList, SIGNAL(doubleClickedOnItem(QTreeWidgetItem *)),
	        SLOT(slotChangeFtpPath(QTreeWidgetItem *)));
	connect(localList, SIGNAL(doubleClickedOnItem(QTreeWidgetItem *)),
	        SLOT(slotChangeLocalPath(QTreeWidgetItem *)));
	connect(ftpList, SIGNAL(rightButtonClicked(QTreeWidgetItem *, QPoint)),
	        SLOT(slotPopupFtp(QTreeWidgetItem *, QPoint)));
	connect(localList,
	        SIGNAL(rightButtonClicked(QTreeWidgetItem *, QPoint)),
	        SLOT(slotPopupLocal(QTreeWidgetItem *, QPoint)));
	connect(ftpList, SIGNAL(startDownloadOrUpload(const QString &)),
	        SLOT(slotUpload(const QString &)));
	connect(localList, SIGNAL(startDownloadOrUpload(const QString &)),
	        SLOT(slotDownload(const QString &)));

	connect(ftp, SIGNAL(downloadFinished(const QString&, int, bool)), SLOT(slotDownloadFinished(const QString&, int, bool)));
	connect(ftp, SIGNAL(uploadFinished(const QString&, int, bool)), SLOT(slotUploadFinished(const QString&, int, bool)));
	connect(ftp, SIGNAL(stateChanged(int)), SLOT(slotStateChanged(int)));
	connect(ftp, SIGNAL(detailledError(const QString &)),
	        SLOT(slotDetailledError(const QString &)));
	connect(ftp, SIGNAL(currentActionChanged(MyFtp::FtpCurrentAction)),
	        SLOT(slotCurrentActionChanged(MyFtp::FtpCurrentAction)));


	(void) new QShortcut(Qt::CTRL + Qt::Key_A, this, SLOT(slotSelectAll()));
	(void) new QShortcut(Qt::Key_F5, this, SLOT(slotReloadList()));
}

scythia::~scythia()
{
	progs.close();
	delete ftp;
}

/*--------------------------------------------------------------------------
Gestion des connexions/déconnexions
--------------------------------------------------------------------------*/
void scythia::slotConnect()
{
	ftpConnect c;
	if (c.exec() == QDialog::Rejected)
		return;
	if (ftp->state() != QFtp::Unconnected && ftp->state() != QFtp::Closing)
		// Important évite un bug !
		slotDisconnect();

	QString mode = c.transferMode->currentText();
	if (mode != tr("Passif") && mode != tr("Actif"))
		mode = tr("Passif");

	// Pour ajouter directement les infos aux signets
	if (c.addSignet->isChecked())
	{
		QString ident = c.identifiant->text();
		if (ident == "")
			ident = c.host->currentText();
		if (c.anonymous->isChecked())
			ident += " [anonyme]";
		list.Ajouter(ident, c.username->text(),
		             c.host->currentText(),
		             c.password->text(), c.port->value(),
		             mode, c.proxyName->text(), c.proxyPort->value());
	}

	ftpList->clear();

	if (mode == tr("Passif"))
		ftp->setTransferMode(QFtp::Passive);
	else
		ftp->setTransferMode(QFtp::Active);
	if (c.proxyName->text() != "")
		ftp->setProxy(c.proxyName->text(), c.proxyPort->value());

	ftp->connectFtp(c.host->currentText(), c.port->value(),
	                c.username->text(), c.password->text());
}

void scythia::slotDisconnect()
{
	if (ftp->state() == QFtp::Unconnected)	// Important évite un bug
		return;
	ftp->disconnectFtp();
}

void scythia::slotStateChanged(int state)
{
	switch ((QFtp::State) state)
	{
	case QFtp::Unconnected:
		stateLabel->setText(trUtf8("<font color =\"#ff0000\">Déconnecté</font>"));
		connectLabel->setPixmap(QPixmap(":/pixmaps/connect_no.png"));

		ftpList->clear();
		transfersWidget->slotRemoveTransfers();
		ftp->disconnectFtp();
		break;
	case QFtp::HostLookup:
		stateLabel->setText(trUtf8("<font color =\"blue\">Recherche_Hôte</font>"));
		break;
	case QFtp::Connecting:
		stateLabel->setText(tr("<font color =\"blue\">Connexion</font>"));
		break;
	case QFtp::Connected:
		stateLabel->setText(trUtf8("<font color =\"blue\">Connecté</font>"));
		break;
	case QFtp::LoggedIn:
		stateLabel->setText(tr("<font color =\"green\">Reconnu</font>"));
		connectLabel->setPixmap(QPixmap(":/pixmaps/connect_established.png"));
		break;
	case QFtp::Closing:
		stateLabel->setText(trUtf8("Fermé"));
		break;
	}
}

void scythia::slotDetailledError(const QString & error)
{
	QMessageBox::critical(this, tr("Erreur FTP"), error);
}


/*--------------------------------------------------------------------------
Gestion des différents changements de dossiers
--------------------------------------------------------------------------*/
void scythia::slotReloadFtpList()
{
	if (ftp->state() == QFtp::Unconnected || ftp->state() == QFtp::Closing)
		QMessageBox::critical(this, tr("Erreur FTP"),
		                      trUtf8("Vous n'êtes pas connecté"));
	else
		ftp->getList();
}

void scythia::slotReloadLocalList()
{
	ftp->dd->refreshList();
}

void scythia::slotReloadList()
{
	if (listSelected == LocalList)
		slotReloadLocalList();
	else if (listSelected == FtpList)
		slotReloadFtpList();
}

void scythia::slotLocalPathChanged()
{
	ftp->dd->changePath(localPathEdit->text());
}

void scythia::slotFtpPathChanged()
{
	ftp->changePath(ftpPathEdit->text());
}

void scythia::slotChangeLocalPath(QTreeWidgetItem * lvi)
{
	if (!lvi)
		return;
	MyTreeWidgetItem *item = (MyTreeWidgetItem *) lvi;
	if (item->isDir())
		ftp->dd->changePath();
	else
	{
		QString prog;
		if (item->getFileState() == MyTreeWidgetItem::Image)
			prog = listProgs.section('\n', 0, 0);
		else if (item->getFileState() == MyTreeWidgetItem::Video)
			prog = listProgs.section('\n', 1, 1);
		else if (item->getFileState() == MyTreeWidgetItem::Audio)
			prog = listProgs.section('\n', 2, 2);
		else if (item->getFileState() == MyTreeWidgetItem::Archive)
			prog = listProgs.section('\n', 3, 3);
		else if (item->getFileState() == MyTreeWidgetItem::Texte)
			prog = listProgs.section('\n', 4, 4);
		else if (item->getFileState() == MyTreeWidgetItem::Document)
			prog = listProgs.section('\n', 5, 5);

		progs.start(prog,
		            QStringList() << ftp->dd->absolutePath() + "/" + lvi->text(0));
	}
}

void scythia::slotChangeLocalPath(const QString & LocalPath)
{
	ftp->dd->changePath(LocalPath);
}

void scythia::slotChangeLocalPath()
{
	QMessageBox::about(NULL, "","");
//	slotChangeLocalPath(localList->firstSelectedItem());
}

void scythia::slotChangeFtpPath(QTreeWidgetItem *)
{
	ftp->changePath();
}

void scythia::slotChangeFtpPath()
{
	slotChangeFtpPath(ftpList->firstSelectedItem());
}

void scythia::slotHiddenFiles()
{
	if (ftp->dd->showHiddenFiles())
		ftp->dd->showHiddenFiles(false);
	else
		ftp->dd->showHiddenFiles(true);
}

/*--------------------------------------------------------------------------
Actions directs sur les fichiers
--------------------------------------------------------------------------*/
void scythia::slotOpenFile()
{
	if (listSelected == Nothing || !localList->firstSelectedItem())
		return;

	BasicLineDialog oF(":/pixmaps/program.png", tr("Ouvrir avec..."),
	                   trUtf8("Donnez le nom du programme à éxécuter :"), "",
	                   this, true);

	if (oF.exec() == QDialog::Rejected)
		return;

	progs.start(oF.lineEdit()->text(),
	            QStringList() << ftp->dd->absolutePath() + "/" +
	            localList->firstSelectedItem()->text(0));
}

void scythia::slotRemoveFile()
{
	// On demande confirmation avant la suppression
	if (( (listSelected == LocalList && localList->firstSelectedItem())
	        || (listSelected == FtpList && ftpList->firstSelectedItem()))
	        && QMessageBox::information(NULL, tr("Confirmation"),
	                                    trUtf8
	                                    ("Voulez-vous réellement effacer le(s) "
	                                     "fichier(s)/dossier(s) sélectionné(s) ?"),
	                                    "&Oui", "&Non", QString::null, 0, 1) == 1)
		return;
	if (listSelected == LocalList)
		ftp->dd->delSelection();
	else if (listSelected == FtpList)
		ftp->delSelection();
	else if (listSelected == TransfersList)
		transfersWidget->slotRemoveTransfers();
}

void scythia::slotNewFolder()
{
	BasicLineDialog nFol(":/pixmaps/createFolder.png", trUtf8("Création Dossier"),
	                     trUtf8("Nom du dossier à créer :"), "", this);

	// Fenêtre pour le nom du dossier
	if (listSelected == FtpList)	// Si un item est sélectionné dans la
		// liste ftp alors ==> Changement en
		// conséquence
	{
		if (nFol.exec() == QDialog::Rejected)
			return;
		ftp->mkdir(nFol.lineEdit()->text());
		ftp->getList();
	}
	else if (listSelected == LocalList)	// Sinon c'est dans la local list
		// ==> Idem : changement en
		// conséquence
	{
		if (nFol.exec() == QDialog::Rejected)
			return;
		ftp->dd->mkdir(nFol.lineEdit()->text());
		ftp->dd->refreshList();
	}
}

void scythia::slotRenameFile()
{
	if (listSelected == Nothing
	        || (!localList->firstSelectedItem() && !ftpList->firstSelectedItem()))
		return;
	// On crée le dialog
	BasicLineDialog rF(":/pixmaps/renameFile.png", tr("Renommage"),
	                   trUtf8("Entrez le nouveau nom du fichier/dossier :"),
	                   trUtf8
	                   ("<span style=\" font-weight:600; color:#ff0000;\">ATTENTION :</span> seul le 1er item est renommé."),
	                   this);
	// On insère l'ancien nom du fichier
	if (listSelected == LocalList)
		rF.lineEdit()->setText(localList->firstSelectedItem()->text(0));
	else if (listSelected == FtpList)
		rF.lineEdit()->setText(ftpList->firstSelectedItem()->text(0));
	// On affiche le dialog et attend qu'il soit fermé
	if (rF.exec() == QDialog::Rejected)
		return;
	// On récupère le nouveau nom
	QString newName = rF.lineEdit()->text();
	// On renomme le fichier
	if (listSelected == LocalList)
		ftp->dd->renameSelection(newName, false);
	else if (listSelected == FtpList)
		ftp->renameSelection(newName, false);
}

void scythia::slotDownload(const QString & destDir)
{
	if (destDir != "")
		ftp->dd->cd(destDir);
	ftp->downloadSelection(ftp->dd->path());
}

void scythia::slotUpload(const QString & destDir)
{
	ftp->uploadSelection(destDir);
}

void scythia::slotDownloadFinished(const QString &destPath, int, bool error)
{
	if (!error && destPath == ftp->dd->path())
		ftp->dd->refreshList();
}

void scythia::slotUploadFinished(const QString &destPath, int, bool error)
{
	if (!error && destPath == ftp->getPath())
		ftp->getList();
}

void scythia::slotExecProg()
{
	chooseProg prog;
	prog.exec();
}


/*--------------------------------------------------------------------------
Autres actions...
--------------------------------------------------------------------------*/
void scythia::slotCommand()
{
	BasicComboDialog cmd(":/pixmaps/command.png", tr("Commande Ftp"),
	                     trUtf8
	                     ("Afin d'envoyer manuellement une commande au serveur Ftp, entrez la ici :"),
	                     trUtf8
	                     ("<span style=\" font-weight:600; color:#ff0000;\">ATTENTION :</span> les commandes manuelles ne sont pas gérés par le logiciel.<br>Elles peuvent entraîner divers bugs.<br>Utilisez les uniquement en cas de besoins spécifiques."),
	                     this);
	cmd.comboBox()->
	addItems(QStringList() << "ABOR" << "ACCT" << "ALLO" << "APPE" << "CDUP" <<
	         "CWD" << "DELE" << "HELP" << "LIST" << "MKD" << "MODE" << "NLST" <<
	         "NOOP" << "PASS" << "PASV" << "PORT" << "PWD" << "QUIT" << "REIN" <<
	         "REST" << "RETR" << "RMD" << "RNFR" << "RNTO" << "SMNT" << "SITE" <<
	         "STAT" << "STOR" << "STOU" << "STRU" << "SYST" << "TYPE" << "USER");
	cmd.comboBox()->setEditable(true);

	if (cmd.exec() == QDialog::Rejected)
		return;
	else if (ftp->state() == QFtp::LoggedIn)
		ftp->rawCommand(cmd.comboBox()->currentText());
}

void scythia::slotAddSignet()
{
	ftpSignet sign;
	sign.exec();
}

void scythia::slotSelectLang()
{
	QStringList langList;
	langList << trUtf8("français");
	// On ouvre le dossier des trads
	QDir TransDir(CheminTrad);
	// On énumère tous les fichiers
	QStringList Files = TransDir.entryList();
	for (QStringList::Iterator it = Files.begin(); it != Files.end(); ++it)
	{
		QString file = *it;
		// Si le fichier est bien un fichier de trad de scythia
		if (file.endsWith(".qm"))
		{
			// On l'ajoute dans la list
			file.truncate(file.size() - 3);
			langList << file;
		}
	}

	BasicListDialog lang(":/pixmaps/scythia.png", "Scythia", "Choose the language :",
	                     langList, "Then, restart scythia.", this);
	QListWidget *listWidget = lang.listWidget();
	QList<QListWidgetItem *> list = listWidget->findItems(Language, Qt::MatchExactly);
	if (!list.isEmpty())
	{
		listWidget->clearSelection();
		listWidget->setItemSelected(list.first(), true);
	}
	if (lang.exec() == QDialog::Rejected)
		return;

	Language = lang.text();
	if (Language != trUtf8("français"))
	{
		// On met la traduction choisie
		translator->load(Language + ".qm", CheminTrad);
		qApp->installTranslator(translator);
	}

	QFile trad(CheminConf + "scythia-lang");
	if (trad.open(QIODevice::WriteOnly))
	{
		// On l'écrit dans le fichier et on ferme
		trad.write(Language.toLocal8Bit(), Language.size());
		trad.close();
	}
}

/*--------------------------------------------------------------------------
Gestion de l'affichage
--------------------------------------------------------------------------*/
void scythia::slotSelectAll()
{
	if (listSelected == LocalList)
		localList->slotSelectFilesAndDirs();
	else if (listSelected == FtpList)
		ftpList->slotSelectFilesAndDirs();
}

void scythia::slotAffichToolbarFile()
{
	affichToolbarFile->setVisible(FALSE);
	hideToolbarFile->setVisible(TRUE);
	ToolbarFile->show();
}

void scythia::slotAffichToolbarConnect()
{
	affichToolbarConnect->setVisible(FALSE);
	hideToolbarConnect->setVisible(TRUE);
	ToolbarConnect->show();
}

void scythia::slotAffichToolbarTransfert()
{
	affichToolbarTransfert->setVisible(FALSE);
	hideToolbarTransfert->setVisible(TRUE);
	ToolbarTransfert->show();
}

void scythia::slotHideToolbarConnect()
{
	affichToolbarConnect->setVisible(TRUE);
	hideToolbarConnect->setVisible(FALSE);
	ToolbarConnect->hide();
}

void scythia::slotHideToolbarFile()
{
	affichToolbarFile->setVisible(TRUE);
	hideToolbarFile->setVisible(FALSE);
	ToolbarFile->hide();
}

void scythia::slotHideToolbarTransfert()
{
	affichToolbarTransfert->setVisible(TRUE);
	hideToolbarTransfert->setVisible(FALSE);
	ToolbarTransfert->hide();
}

void scythia::slotLocalSelection(QTreeWidgetItem *)
{
	ftpList->clearSelection();
	transfersWidget->transferListWidget->clearSelection();
	listSelected = LocalList;
}

void scythia::slotFtpSelection(QTreeWidgetItem *)
{
	localList->clearSelection();
	transfersWidget->transferListWidget->clearSelection();
	listSelected = FtpList;
}

void scythia::slotTransferSelection(QTreeWidgetItem *)
{
	ftpList->clearSelection();
	localList->clearSelection();
	listSelected = TransfersList;
}

void scythia::slotPopupLocal(QTreeWidgetItem * item, const QPoint pos)
{
	QMenu fileMenuLocal(this);
	fileMenuLocal.move(pos);
	bool itemSelected = false;
	if (item && MyTreeWidgetItem::isSimple(item->text(0)))
		itemSelected = true;
	if (itemSelected && MyTreeWidgetItem::isSimple(item->text(0))
	        && !((MyTreeWidgetItem *) item)->isDir())
		fileMenuLocal.addAction(QIcon(":/pixmaps/program.png"), tr("Ouvrir avec..."),
		                        this, SLOT(slotOpenFile()));
	if (itemSelected)
		fileMenuLocal.addAction(QIcon(":/pixmaps/renameFile.png"),
		                        tr("Renommer"), this, SLOT(slotRenameFile()));
	if (itemSelected)
		fileMenuLocal.
		addAction(QIcon(":/pixmaps/deleteFile.png"), tr("Supprimer"),
		          this, SLOT(slotRemoveFile()));
	fileMenuLocal.addAction(QIcon(":/pixmaps/createFolder.png"),
	                        trUtf8("Créer un nouveau dossier"), this,
	                        SLOT(slotNewFolder()));
	if (itemSelected)
		fileMenuLocal.
		addAction(QIcon(":/pixmaps/uploadImg.png"),
		          tr("Envoyer vers le ftp"), this, SLOT(slotUpload()));
	fileMenuLocal.addAction(QIcon(":/pixmaps/reloadDD.png"),
	                        tr("Rafraichir la liste"), this,
	                        SLOT(slotReloadLocalList()));
	fileMenuLocal.addSeparator();
	if (ftp->dd->showHiddenFiles())
		fileMenuLocal.
		addAction(QIcon(":/pixmaps/hiddenfiles.png"),
		          trUtf8("Cacher les fichiers cachés"), this,
		          SLOT(slotHiddenFiles()));
	else
		fileMenuLocal.addAction(QIcon(":/pixmaps/hiddenfiles.png"),
		                        trUtf8("Afficher les fichiers cachés"),
		                        this, SLOT(slotHiddenFiles()));
	fileMenuLocal.addSeparator();
	fileMenuLocal.addAction(QIcon(":/images/file.png"),
	                        trUtf8("Sélectionner les fichiers"),
	                        localList, SLOT(slotSelectFiles()));
	fileMenuLocal.addAction(QIcon(":/images/folder.png"),
	                        trUtf8("Sélectionner les dossiers"),
	                        localList, SLOT(slotSelectDirs()));
	fileMenuLocal.addAction(QIcon(":/images/dd.png"),
	                        trUtf8
	                        ("Sélectionner fichiers et dossiers"),
	                        localList, SLOT(slotSelectFilesAndDirs()));
	fileMenuLocal.exec();
}

void scythia::slotPopupFtp(QTreeWidgetItem * item, const QPoint pos)
{
	QMenu fileMenu(this);
	fileMenu.move(pos);
	bool itemSelected = false;
	if (item && MyTreeWidgetItem::isSimple(item->text(0)))
		itemSelected = true;
	if (itemSelected)
		fileMenu.addAction(QIcon(":/pixmaps/renameFile.png"),
		                   tr("Renommer"), this, SLOT(slotRenameFile()));
	if (itemSelected)
		fileMenu.addAction(QIcon(":/pixmaps/deleteFile.png"),
		                   tr("Supprimer"), this, SLOT(slotRemoveFile()));
	fileMenu.addAction(QIcon(":/pixmaps/createFolder.png"),
	                   trUtf8("Créer un nouveau dossier"), this,
	                   SLOT(slotNewFolder()));
	if (itemSelected)
		fileMenu.addAction(QIcon(":/pixmaps/downloadImg.png"),
		                   trUtf8("Télécharger"), this, SLOT(slotDownload()));
	fileMenu.addAction(QIcon(":/pixmaps/reloadFtp.png"),
	                   tr("Rafraichir la liste"), this, SLOT(slotReloadFtpList()));
	fileMenu.addSeparator();
	fileMenu.addAction(QIcon(":/images/file.png"),
	                   trUtf8("Sélectionner les fichiers"), ftpList,
	                   SLOT(slotSelectFiles()));
	fileMenu.addAction(QIcon(":/images/folder.png"),
	                   trUtf8("Sélectionner les dossiers"), ftpList,
	                   SLOT(slotSelectDirs()));
	fileMenu.addAction(QIcon(":/images/dd.png"),
	                   trUtf8("Sélectionner fichiers et dossiers"),
	                   ftpList, SLOT(slotSelectFilesAndDirs()));
	fileMenu.exec();
}

void scythia::slotHelp()
{
	aide h;
	h.exec();
}

void scythia::slotCurrentActionChanged(MyFtp::FtpCurrentAction action)
{
	if (action != MyFtp::None)
	{
		if (action != MyFtp::Download && action != MyFtp::Upload)
		{
			ftpList->setEnabled(FALSE);
			localList->setEnabled(FALSE);
			ftpPathEdit->setEnabled(FALSE);
			localPathEdit->setEnabled(FALSE);
		}

		waitLabel->setPixmap(QPixmap(":/pixmaps/wait.png"));
		statusBar()->
		showMessage(tr("Une action est en cours, veuillez patienter..."));
	}
	else
	{
		ftpList->setEnabled(TRUE);
		localList->setEnabled(TRUE);
		ftpPathEdit->setEnabled(TRUE);
		localPathEdit->setEnabled(TRUE);
		waitLabel->setPixmap(QPixmap(":/pixmaps/network.png"));
		statusBar()->clearMessage();
	}
}

void scythia::showOrHide()
{
	if (isHidden())
		show();
	else
		hide();
}

void scythia::closeEvent(QCloseEvent *)
{
	if (!systemTray)
	{
		BasicCheckBoxDialog cb(":/pixmaps/scythia.png", tr("Attention !"), trUtf8
		                       ("L'application est seulement réduite dans la barre des taches !"),
		                       trUtf8("Ne plus le préciser"), this);
		if (cb.exec() == QDialog::Accepted)
			systemTray = (cb.checkBox()->checkState() == Qt::Checked);
	}
}

void scythia::trayIconActivated(QSystemTrayIcon::ActivationReason reason)
{
	switch (reason)
	{
	case QSystemTrayIcon::Unknown:
	case QSystemTrayIcon::DoubleClick:
	case QSystemTrayIcon::Trigger:
	case QSystemTrayIcon::MiddleClick:
		showOrHide();
	default:
		break;
	}
}
