/***************************************************************************
 *   Copyleft (C) 2004 by Cocophotos                                       *
 *   cocophotos@hotmail.com                                                *
 *   Sous licence GPL v2 ou plus                                           *
 ***************************************************************************/

#ifndef FTPCONNECT_H
#define FTPCONNECT_H

#include <QtCore>
#include <QtGui>
#include <QtNetwork>
#include "ui_ftpconnect.h"

/*************************************************************************/
//! Gère le dialog des connexions rapides

/*! Permet d'afficher un dialog de Connexion Rapide capable de sauvegarder les
   paramètres inscrits dans les signets et de se connecter en mode anonyme */
/*************************************************************************/

class ftpConnect:public QDialog, public Ui::ftpConnect
{
	Q_OBJECT
public:
	/*! Le constructeur : crée le dialog et rempli les items */
	ftpConnect(QWidget * parent = 0);
	/*! Sauvegarde le numéro de l'item en cours d'utilisation */
	int itemConnect;

public slots:
	/*! Permet de gérer les urls du tampon système */
	virtual void slotFtpUrl();
	/*! Lance la connexion au ftp */
	virtual void slotConnectRapid();
	/*! Récupère les paramêtres de connexion lorque l'on clique sur un item */
	virtual void slotClickedIdentifiant();
	/*! Vérifie si tous les paramêtres obligatoires sont présent */
	virtual void slotSDataChanged(const QString &);
	/*! Active ou désactive la connexion en mode anonyme */
	virtual void slotAnonymousChanged(int state);
};

#endif
