/****************************************************************************
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#ifndef BASICDIALOG_H
#define BASICDIALOG_H

#include <QDialog>
#include <QLineEdit>
#include <QComboBox>
#include <QListWidget>
#include <QCheckBox>

/*************************************************************************/
//! Simplifie l'utilisation d'une QDialog

/*! BasicDialog permet d'utiliser simplement une boite de dialogue avec
    une interface prédéfinie. */
/*************************************************************************/

class BasicDialog:public QDialog
{
	Q_OBJECT

public:
	/*! Le constructeur */
	BasicDialog(QWidget * parent):QDialog(parent)
	{}

	/*! Permet de construire l'interface de la fonction selon un widget inconnu */
	void createInterface (const QString &icon, const QString &title,
	                      const QString &firstLine, QWidget *widget, const QString &secondLine = "", bool SelectFileButton = false,
	                      bool SelectDirButton = false, bool JusteOneButton = false);

private slots:
	/*! Slot qui permet de choisir un fichier */
	void selectFile();
	/*! Slot qui permet de choisir un dossier */
	void selectDir();

signals:
	void pathSelected(const QString &Path);

};


/*************************************************************************/
//! Simplifie l'utilisation d'une QDialog avec un QLineEdit

/*! BasicLineDialog permet d'utiliser simplement une boite de dialogue avec
    un QLineEdit afin de saisir une valeur. */
/*************************************************************************/

class BasicLineDialog:public BasicDialog
{
	Q_OBJECT

public:
	/*! Le constructeur */
	BasicLineDialog (const QString &icon, const QString &title,
	                 const QString &firstLine, const QString &secondLine = "",
	                 QWidget *parent = NULL, bool SelectFileButton = false, bool SelectDirButton = false);

	/*! Retourne le QLineEdit */
	inline QLineEdit* lineEdit()
	{
		return le;
	}

private:
	/*! Le LineEdit utilisé pour récupérer la valeur recherchée. */
	QLineEdit *le;

private slots:
	/*! Slot utilisé pour récupérer la valeur du fichier choisi dans l'edit */
	void changeEdit(const QString&);
};


/*************************************************************************/
//! Simplifie l'utilisation d'une QDialog avec un QComboBox

/*! BasicComboDialog permet d'utiliser simplement une boite de dialogue avec
    un QComboBox afin de saisir une valeur. */
/*************************************************************************/

class BasicComboDialog:public BasicDialog
{
	Q_OBJECT

public:
	/*! Le constructeur */
	BasicComboDialog (const QString &icon, const QString &title,
	                  const QString &firstLine, const QString &secondLine = "",
	                  QWidget *parent = NULL);

	/*! Retourne le QComboBox */
	inline QComboBox* comboBox()
	{
		return cb;
	}

private:
	/*! Le ComboBox utilisé pour récupérer la valeur recherchée. */
	QComboBox *cb;
};


/*************************************************************************/
//! Simplifie l'utilisation d'une QDialog avec un QListWidget

/*! BasicListDialog permet d'utiliser simplement une boite de dialogue avec
    un QListWidget afin de saisir une valeur. */
/*************************************************************************/

class BasicListDialog:public BasicDialog
{
	Q_OBJECT

public:
	/*! Le constructeur */
	BasicListDialog (const QString &icon, const QString &title,
	                 const QString &firstLine, const QStringList &choices, const QString &secondLine = "",
	                 QWidget *parent = NULL);

	/*! Retourne le QListWidget */
	inline QListWidget* listWidget()
	{
		return lw;
	}

	/*! Retourn le texte sélectionné */
	inline QString text()
	{
		return lw->currentItem ()->text();
	}

private:
	/*! Le ComboBox utilisé pour récupérer la valeur recherchée. */
	QListWidget *lw;
};

/*************************************************************************/
//! Simplifie l'utilisation d'une QDialog avec un QCheckBox

/*! BasicCheckBoxDialog permet d'utiliser simplement une boite de dialogue avec
    un QCheckBox afin de saisir un choix. */
/*************************************************************************/

class BasicCheckBoxDialog:public BasicDialog
{
	Q_OBJECT

public:
	/*! Le constructeur */
	BasicCheckBoxDialog (const QString &icon, const QString &title,
	                     const QString &firstLine, const QString &checkBoxLine,
	                     QWidget *parent = NULL);

	/*! Retourne le QCheckBox */
	inline QCheckBox* checkBox()
	{
		return cb;
	}

private:
	/*! Le CheckBox utilisé pour récupérer la valeur recherchée. */
	QCheckBox *cb;
};

#endif
