
/* autogenerated from ./schro.orc */

#ifndef DISABLE_ORC
#include <orc/orc.h>
#else
#include <stdint.h>
#endif


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_AS_FLOAT(x) (((union { int i; float f; } *)(&x))->f)
/* end Orc C target preamble */



/* orc_add2_rshift_add_s16_22_op */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s16_22_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: addw */
    var0 = var4 + var34;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s16_22_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: addw */
    var0 = var4 + var34;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add2_rshift_add_s16_22_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s16_22_op");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_22_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  orc_executor_run (ex);
}
#endif


/* orc_add2_rshift_add_s16_22 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s16_22 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: addw */
    var0 = var0 + var34;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s16_22 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: addw */
    var0 = var0 + var34;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add2_rshift_add_s16_22 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s16_22");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_22);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_add2_rshift_sub_s16_22_op */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s16_22_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: subw */
    var0 = var4 - var34;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s16_22_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: subw */
    var0 = var4 - var34;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add2_rshift_sub_s16_22_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s16_22_op");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_22_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  orc_executor_run (ex);
}
#endif


/* orc_add2_rshift_sub_s16_22 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s16_22 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: subw */
    var0 = var0 - var34;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s16_22 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: subw */
    var0 = var0 - var34;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add2_rshift_sub_s16_22 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s16_22");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_22);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_add2_rshift_add_s16_11_op */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s16_11_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: avgsw */
    var32 = (var5 + var6 + 1)>>1;
    /* 1: addw */
    var0 = var4 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s16_11_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: avgsw */
    var32 = (var5 + var6 + 1)>>1;
    /* 1: addw */
    var0 = var4 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add2_rshift_add_s16_11_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s16_11_op");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_11_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  orc_executor_run (ex);
}
#endif


/* orc_add2_rshift_add_s16_11 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_add_s16_11 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var32 = (var4 + var5 + 1)>>1;
    /* 1: addw */
    var0 = var0 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add2_rshift_add_s16_11 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var32 = (var4 + var5 + 1)>>1;
    /* 1: addw */
    var0 = var0 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add2_rshift_add_s16_11 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_add_s16_11");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_11);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_add2_rshift_sub_s16_11_op */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s16_11_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: avgsw */
    var32 = (var5 + var6 + 1)>>1;
    /* 1: subw */
    var0 = var4 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s16_11_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: avgsw */
    var32 = (var5 + var6 + 1)>>1;
    /* 1: subw */
    var0 = var4 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add2_rshift_sub_s16_11_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s16_11_op");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_11_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  orc_executor_run (ex);
}
#endif


/* orc_add2_rshift_sub_s16_11 */
#ifdef DISABLE_ORC
void
orc_add2_rshift_sub_s16_11 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var32 = (var4 + var5 + 1)>>1;
    /* 1: subw */
    var0 = var0 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add2_rshift_sub_s16_11 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var32 = (var4 + var5 + 1)>>1;
    /* 1: subw */
    var0 = var0 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add2_rshift_sub_s16_11 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add2_rshift_sub_s16_11");
      orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_11);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_add_const_rshift_s16_11 */
#ifdef DISABLE_ORC
void
orc_add_const_rshift_s16_11 (int16_t * d1, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: shrsw */
    var0 = var32 >> var17;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add_const_rshift_s16_11 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: shrsw */
    var0 = var32 >> var17;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add_const_rshift_s16_11 (int16_t * d1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add_const_rshift_s16_11");
      orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s16_11);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 1, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_add_const_rshift_s16 */
#ifdef DISABLE_ORC
void
orc_add_const_rshift_s16 (int16_t * d1, int p1, int p2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  int16_t var32;

  ptr0 = d1;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: addw */
    var32 = var0 + var24;
    /* 1: shrsw */
    var0 = var32 >> var25;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add_const_rshift_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: addw */
    var32 = var0 + var24;
    /* 1: shrsw */
    var0 = var32 >> var25;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add_const_rshift_s16 (int16_t * d1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add_const_rshift_s16");
      orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1);
      orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_add_s16 */
#ifdef DISABLE_ORC
void
orc_add_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var0 = var4 + var5;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var0 = var4 + var5;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add_s16");
      orc_program_set_backup_function (p, _backup_orc_add_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");

      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_add_s16_2d */
#ifdef DISABLE_ORC
void
orc_add_s16_2d (int16_t * d1, int d1_stride, const int16_t * s1, int s1_stride, int n, int m){
  int i;
  int j;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      var4 = *ptr4;
      ptr4++;
      /* 0: addw */
      var0 = var0 + var4;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_add_s16_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      var4 = *ptr4;
      ptr4++;
      /* 0: addw */
      var0 = var0 + var4;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_add_s16_2d (int16_t * d1, int d1_stride, const int16_t * s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_add_s16_2d");
      orc_program_set_backup_function (p, _backup_orc_add_s16_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  orc_executor_run (ex);
}
#endif


/* orc_addc_rshift_s16 */
#ifdef DISABLE_ORC
void
orc_addc_rshift_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int p1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var24 = p1;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: shrsw */
    var0 = var32 >> var24;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_addc_rshift_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var24 = ex->params[24];
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: shrsw */
    var0 = var32 >> var24;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_addc_rshift_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_addc_rshift_s16");
      orc_program_set_backup_function (p, _backup_orc_addc_rshift_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
      orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_P1] = p1;

  orc_executor_run (ex);
}
#endif


/* orc_lshift1_s16 */
#ifdef DISABLE_ORC
void
orc_lshift1_s16 (int16_t * d1, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 1;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shlw */
    var0 = var4 << var16;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_lshift1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 1;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shlw */
    var0 = var4 << var16;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_lshift1_s16 (int16_t * d1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_lshift1_s16");
      orc_program_set_backup_function (p, _backup_orc_lshift1_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 1, "c1");

      orc_program_append (p, "shlw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_lshift2_s16 */
#ifdef DISABLE_ORC
void
orc_lshift2_s16 (int16_t * d1, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shlw */
    var0 = var4 << var16;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_lshift2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shlw */
    var0 = var4 << var16;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_lshift2_s16 (int16_t * d1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_lshift2_s16");
      orc_program_set_backup_function (p, _backup_orc_lshift2_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");

      orc_program_append (p, "shlw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_lshift_s16_ip */
#ifdef DISABLE_ORC
void
orc_lshift_s16_ip (int16_t * d1, int p1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = p1;

  ptr0 = d1;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: shlw */
    var0 = var0 << var24;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_lshift_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: shlw */
    var0 = var0 << var24;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_lshift_s16_ip (int16_t * d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_lshift_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_lshift_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append (p, "shlw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_P1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  orc_executor_run (ex);
}
#endif


/* orc_mas2_add_s16_op */
#ifdef DISABLE_ORC
void
orc_mas2_add_s16_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int p1, int p2, int p3, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var24 = p1;
  const int32_t var25 = p2;
  const int32_t var26 = p3;
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: addw */
    var0 = var4 + var36;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_mas2_add_s16_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  const int32_t var26 = ex->params[26];
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: addw */
    var0 = var4 + var36;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_mas2_add_s16_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_add_s16_op");
      orc_program_set_backup_function (p, _backup_orc_mas2_add_s16_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
      orc_program_append (p, "mulswl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
      orc_program_append (p, "shrsl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
      orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  orc_executor_run (ex);
}
#endif


/* orc_mas2_add_s16_ip */
#ifdef DISABLE_ORC
void
orc_mas2_add_s16_ip (int16_t * d1, const int16_t * s1, const int16_t * s2, int p1, int p2, int p3, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var24 = p1;
  const int32_t var25 = p2;
  const int32_t var26 = p3;
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: addw */
    var0 = var0 + var36;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_mas2_add_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  const int32_t var26 = ex->params[26];
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: addw */
    var0 = var0 + var36;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_mas2_add_s16_ip (int16_t * d1, const int16_t * s1, const int16_t * s2, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_add_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_mas2_add_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
      orc_program_append (p, "mulswl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
      orc_program_append (p, "shrsl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
      orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  orc_executor_run (ex);
}
#endif


/* orc_mas2_sub_s16_op */
#ifdef DISABLE_ORC
void
orc_mas2_sub_s16_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int p1, int p2, int p3, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var24 = p1;
  const int32_t var25 = p2;
  const int32_t var26 = p3;
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: subw */
    var0 = var4 - var36;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_mas2_sub_s16_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  const int32_t var26 = ex->params[26];
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: subw */
    var0 = var4 - var36;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_mas2_sub_s16_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_sub_s16_op");
      orc_program_set_backup_function (p, _backup_orc_mas2_sub_s16_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
      orc_program_append (p, "mulswl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
      orc_program_append (p, "shrsl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
      orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  orc_executor_run (ex);
}
#endif


/* orc_mas2_sub_s16_ip */
#ifdef DISABLE_ORC
void
orc_mas2_sub_s16_ip (int16_t * d1, const int16_t * s1, const int16_t * s2, int p1, int p2, int p3, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var24 = p1;
  const int32_t var25 = p2;
  const int32_t var26 = p3;
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: subw */
    var0 = var0 - var36;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_mas2_sub_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  const int32_t var26 = ex->params[26];
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: subw */
    var0 = var0 - var36;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_mas2_sub_s16_ip (int16_t * d1, const int16_t * s1, const int16_t * s2, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas2_sub_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_mas2_sub_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_parameter (p, 4, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
      orc_program_append (p, "mulswl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
      orc_program_append (p, "shrsl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
      orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  orc_executor_run (ex);
}
#endif


/* orc_mas4_across_add_s16_1991_op */
#ifdef DISABLE_ORC
void
orc_mas4_across_add_s16_1991_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, const int16_t * s4, const int16_t * s5, int p1, int p2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  int16_t var8;
  const int16_t * ptr8;
  const int16_t var16 = 9;
  const int32_t var24 = p1;
  const int32_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;
  ptr7 = s4;
  ptr8 = s5;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    var8 = *ptr8;
    ptr8++;
    /* 0: addw */
    var32 = var6 + var7;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var5 + var8;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: addw */
    var0 = var4 + var39;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_mas4_across_add_s16_1991_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  int16_t var8;
  const int16_t * ptr8;
  const int16_t var16 = 9;
  const int32_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];
  ptr8 = ex->arrays[8];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    var8 = *ptr8;
    ptr8++;
    /* 0: addw */
    var32 = var6 + var7;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var5 + var8;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: addw */
    var0 = var4 + var39;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_mas4_across_add_s16_1991_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, const int16_t * s4, const int16_t * s5, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_across_add_s16_1991_op");
      orc_program_set_backup_function (p, _backup_orc_mas4_across_add_s16_1991_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_constant (p, 2, 9, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4);
      orc_program_append (p, "mulswl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S5);
      orc_program_append (p, "convswl", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "subl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
      orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1);
      orc_program_append (p, "shrsl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2);
      orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->arrays[ORC_VAR_S5] = (void *)s5;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_mas4_across_add_s16_1991_ip */
#ifdef DISABLE_ORC
void
orc_mas4_across_add_s16_1991_ip (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, const int16_t * s4, int p1, int p2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  const int16_t var16 = 9;
  const int32_t var24 = p1;
  const int32_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;
  ptr7 = s4;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var4 + var7;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: addw */
    var0 = var0 + var39;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_mas4_across_add_s16_1991_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  const int16_t var16 = 9;
  const int32_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var4 + var7;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: addw */
    var0 = var0 + var39;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_mas4_across_add_s16_1991_ip (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, const int16_t * s4, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_across_add_s16_1991_ip");
      orc_program_set_backup_function (p, _backup_orc_mas4_across_add_s16_1991_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_constant (p, 2, 9, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
      orc_program_append (p, "mulswl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_S4);
      orc_program_append (p, "convswl", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "subl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
      orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1);
      orc_program_append (p, "shrsl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2);
      orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_mas4_across_sub_s16_1991_op */
#ifdef DISABLE_ORC
void
orc_mas4_across_sub_s16_1991_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, const int16_t * s4, const int16_t * s5, int p1, int p2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  int16_t var8;
  const int16_t * ptr8;
  const int16_t var16 = 9;
  const int32_t var24 = p1;
  const int32_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;
  ptr7 = s4;
  ptr8 = s5;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    var8 = *ptr8;
    ptr8++;
    /* 0: addw */
    var32 = var6 + var7;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var5 + var8;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: subw */
    var0 = var4 - var39;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_mas4_across_sub_s16_1991_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  int16_t var8;
  const int16_t * ptr8;
  const int16_t var16 = 9;
  const int32_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];
  ptr8 = ex->arrays[8];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    var8 = *ptr8;
    ptr8++;
    /* 0: addw */
    var32 = var6 + var7;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var5 + var8;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: subw */
    var0 = var4 - var39;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_mas4_across_sub_s16_1991_op (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, const int16_t * s4, const int16_t * s5, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_across_sub_s16_1991_op");
      orc_program_set_backup_function (p, _backup_orc_mas4_across_sub_s16_1991_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_constant (p, 2, 9, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4);
      orc_program_append (p, "mulswl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S5);
      orc_program_append (p, "convswl", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "subl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
      orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1);
      orc_program_append (p, "shrsl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2);
      orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->arrays[ORC_VAR_S5] = (void *)s5;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_mas4_across_sub_s16_1991_ip */
#ifdef DISABLE_ORC
void
orc_mas4_across_sub_s16_1991_ip (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, const int16_t * s4, int p1, int p2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  const int16_t var16 = 9;
  const int32_t var24 = p1;
  const int32_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;
  ptr7 = s4;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var4 + var7;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: subw */
    var0 = var0 - var39;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_mas4_across_sub_s16_1991_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  const int16_t var16 = 9;
  const int32_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var4 + var7;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: subw */
    var0 = var0 - var39;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_mas4_across_sub_s16_1991_ip (int16_t * d1, const int16_t * s1, const int16_t * s2, const int16_t * s3, const int16_t * s4, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_mas4_across_sub_s16_1991_ip");
      orc_program_set_backup_function (p, _backup_orc_mas4_across_sub_s16_1991_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_constant (p, 2, 9, "c1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
      orc_program_append (p, "mulswl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_S4);
      orc_program_append (p, "convswl", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "subl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
      orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1);
      orc_program_append (p, "shrsl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2);
      orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_subtract_s16 */
#ifdef DISABLE_ORC
void
orc_subtract_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subw */
    var0 = var4 - var5;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_subtract_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subw */
    var0 = var4 - var5;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_subtract_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_subtract_s16");
      orc_program_set_backup_function (p, _backup_orc_subtract_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");

      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_add_s16_u8 */
#ifdef DISABLE_ORC
void
orc_add_s16_u8 (int16_t * d1, const int16_t * s1, const uint8_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var5;
    /* 1: addw */
    var0 = var32 + var4;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_add_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var5;
    /* 1: addw */
    var0 = var32 + var4;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_add_s16_u8 (int16_t * d1, const int16_t * s1, const uint8_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_add_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_add_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_add_s16_u8_2d */
#ifdef DISABLE_ORC
void
orc_add_s16_u8_2d (int16_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, int n, int m){
  int i;
  int j;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int16_t var32;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      var4 = *ptr4;
      ptr4++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: addw */
      var0 = var0 + var32;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_add_s16_u8_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int16_t var32;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      var4 = *ptr4;
      ptr4++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: addw */
      var0 = var0 + var32;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_add_s16_u8_2d (int16_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_add_s16_u8_2d");
      orc_program_set_backup_function (p, _backup_orc_add_s16_u8_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  orc_executor_run (ex);
}
#endif


/* orc_convert_s16_u8 */
#ifdef DISABLE_ORC
void
orc_convert_s16_u8 (uint16_t * d1, const uint8_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var0 = (uint8_t)var4;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_convert_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var0 = (uint8_t)var4;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_convert_s16_u8 (uint16_t * d1, const uint8_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_convert_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_convert_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");

      orc_program_append (p, "convubw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_convert_u8_s16 */
#ifdef DISABLE_ORC
void
orc_convert_u8_s16 (uint8_t * d1, const int16_t * s1, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convsuswb */
    var0 = ORC_CLAMP_UB(var4);
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_convert_u8_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convsuswb */
    var0 = ORC_CLAMP_UB(var4);
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_convert_u8_s16 (uint8_t * d1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_convert_u8_s16");
      orc_program_set_backup_function (p, _backup_orc_convert_u8_s16);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_offsetconvert_u8_s16 */
#ifdef DISABLE_ORC
void
orc_offsetconvert_u8_s16 (uint8_t * d1, const int16_t * s1, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 128;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: convsuswb */
    var0 = ORC_CLAMP_UB(var32);
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_offsetconvert_u8_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 128;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: convsuswb */
    var0 = ORC_CLAMP_UB(var32);
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_offsetconvert_u8_s16 (uint8_t * d1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_offsetconvert_u8_s16");
      orc_program_set_backup_function (p, _backup_orc_offsetconvert_u8_s16);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 128, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_offsetconvert_s16_u8 */
#ifdef DISABLE_ORC
void
orc_offsetconvert_s16_u8 (int16_t * d1, const uint8_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  const int16_t var16 = 128;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: subw */
    var0 = var32 - var16;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_offsetconvert_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  const int16_t var16 = 128;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: subw */
    var0 = var32 - var16;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_offsetconvert_s16_u8 (int16_t * d1, const uint8_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_offsetconvert_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_offsetconvert_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 2, 128, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_subtract_s16_u8 */
#ifdef DISABLE_ORC
void
orc_subtract_s16_u8 (int16_t * d1, const int16_t * s1, const uint8_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var5;
    /* 1: subw */
    var0 = var4 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_subtract_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var5;
    /* 1: subw */
    var0 = var4 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_subtract_s16_u8 (int16_t * d1, const int16_t * s1, const uint8_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_subtract_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_subtract_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_multiply_and_add_s16_u8 */
#ifdef DISABLE_ORC
void
orc_multiply_and_add_s16_u8 (int16_t * d1, const int16_t * s1, const uint8_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int16_t var32;
  int16_t var33;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var5;
    /* 1: mullw */
    var33 = (var32 * var4) & 0xffff;
    /* 2: addw */
    var0 = var0 + var33;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_multiply_and_add_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int16_t var32;
  int16_t var33;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var5;
    /* 1: mullw */
    var33 = (var32 * var4) & 0xffff;
    /* 2: addw */
    var0 = var0 + var33;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_multiply_and_add_s16_u8 (int16_t * d1, const int16_t * s1, const uint8_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_multiply_and_add_s16_u8");
      orc_program_set_backup_function (p, _backup_orc_multiply_and_add_s16_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_splat_s16_ns */
#ifdef DISABLE_ORC
void
orc_splat_s16_ns (int16_t * d1, int p1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = p1;

  ptr0 = d1;

  for (i = 0; i < n; i++) {
    /* 0: copyw */
    var0 = var24;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_splat_s16_ns (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    /* 0: copyw */
    var0 = var24;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_splat_s16_ns (int16_t * d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_splat_s16_ns");
      orc_program_set_backup_function (p, _backup_orc_splat_s16_ns);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  orc_executor_run (ex);
}
#endif


/* orc_splat_s16_2d_4xn */
#ifdef DISABLE_ORC
void
orc_splat_s16_2d_4xn (int16_t * d1, int d1_stride, int p1, int m){
  int i;
  int j;
  int n = 4;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = p1;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

    for (i = 0; i < n; i++) {
      /* 0: copyw */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_splat_s16_2d_4xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 4;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      /* 0: copyw */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_splat_s16_2d_4xn (int16_t * d1, int d1_stride, int p1, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 4);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_splat_s16_2d_4xn");
      orc_program_set_backup_function (p, _backup_orc_splat_s16_2d_4xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 4;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  orc_executor_run (ex);
}
#endif


/* orc_splat_s16_2d_8xn */
#ifdef DISABLE_ORC
void
orc_splat_s16_2d_8xn (int16_t * d1, int d1_stride, int p1, int m){
  int i;
  int j;
  int n = 8;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = p1;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

    for (i = 0; i < n; i++) {
      /* 0: copyw */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_splat_s16_2d_8xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      /* 0: copyw */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_splat_s16_2d_8xn (int16_t * d1, int d1_stride, int p1, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_splat_s16_2d_8xn");
      orc_program_set_backup_function (p, _backup_orc_splat_s16_2d_8xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  orc_executor_run (ex);
}
#endif


/* orc_splat_s16_2d */
#ifdef DISABLE_ORC
void
orc_splat_s16_2d (int16_t * d1, int d1_stride, int p1, int n, int m){
  int i;
  int j;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = p1;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

    for (i = 0; i < n; i++) {
      /* 0: copyw */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_splat_s16_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      /* 0: copyw */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_splat_s16_2d (int16_t * d1, int d1_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_splat_s16_2d");
      orc_program_set_backup_function (p, _backup_orc_splat_s16_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  orc_executor_run (ex);
}
#endif


/* orc_splat_u8_ns */
#ifdef DISABLE_ORC
void
orc_splat_u8_ns (uint8_t * d1, int p1, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  const int8_t var24 = p1;

  ptr0 = d1;

  for (i = 0; i < n; i++) {
    /* 0: copyb */
    var0 = var24;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_splat_u8_ns (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  const int8_t var24 = ex->params[24];

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    /* 0: copyb */
    var0 = var24;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_splat_u8_ns (uint8_t * d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_splat_u8_ns");
      orc_program_set_backup_function (p, _backup_orc_splat_u8_ns);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_parameter (p, 1, "p1");

      orc_program_append (p, "copyb", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  orc_executor_run (ex);
}
#endif


/* orc_splat_u8_2d */
#ifdef DISABLE_ORC
void
orc_splat_u8_2d (uint8_t * d1, int d1_stride, int p1, int n, int m){
  int i;
  int j;
  int8_t var0;
  int8_t * ptr0;
  const int8_t var24 = p1;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

    for (i = 0; i < n; i++) {
      /* 0: copyb */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_splat_u8_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  const int8_t var24 = ex->params[24];

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      /* 0: copyb */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_splat_u8_2d (uint8_t * d1, int d1_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_splat_u8_2d");
      orc_program_set_backup_function (p, _backup_orc_splat_u8_2d);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_parameter (p, 1, "p1");

      orc_program_append (p, "copyb", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  orc_executor_run (ex);
}
#endif


/* orc_average_u8 */
#ifdef DISABLE_ORC
void
orc_average_u8 (uint8_t * d1, const uint8_t * s1, const uint8_t * s2, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgub */
    var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_average_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgub */
    var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_average_u8 (uint8_t * d1, const uint8_t * s1, const uint8_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_average_u8");
      orc_program_set_backup_function (p, _backup_orc_average_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_rrshift6_add_s16_2d */
#ifdef DISABLE_ORC
void
orc_rrshift6_add_s16_2d (uint8_t * d1, int d1_stride, const int16_t * s1, int s1_stride, const int16_t * s2, int s2_stride, int n, int m){
  int i;
  int j;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 32;
  const int16_t var17 = 6;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: addw */
      var32 = var5 + var16;
      /* 1: shrsw */
      var33 = var32 >> var17;
      /* 2: addw */
      var34 = var4 + var33;
      /* 3: convsuswb */
      var0 = ORC_CLAMP_UB(var34);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_rrshift6_add_s16_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 32;
  const int16_t var17 = 6;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: addw */
      var32 = var5 + var16;
      /* 1: shrsw */
      var33 = var32 >> var17;
      /* 2: addw */
      var34 = var4 + var33;
      /* 3: convsuswb */
      var0 = ORC_CLAMP_UB(var34);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_rrshift6_add_s16_2d (uint8_t * d1, int d1_stride, const int16_t * s1, int s1_stride, const int16_t * s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_rrshift6_add_s16_2d");
      orc_program_set_backup_function (p, _backup_orc_rrshift6_add_s16_2d);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 32, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
}
#endif


/* orc_rrshift6_sub_s16_2d */
#ifdef DISABLE_ORC
void
orc_rrshift6_sub_s16_2d (int16_t * d1, int d1_stride, int16_t * d2, int d2_stride, int n, int m){
  int i;
  int j;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 8160;
  const int16_t var17 = 6;
  int16_t var32;
  int16_t var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      var1 = *ptr1;
      /* 0: subw */
      var32 = var1 - var16;
      /* 1: shrsw */
      var33 = var32 >> var17;
      /* 2: copyw */
      var1 = var33;
      /* 3: subw */
      var0 = var0 - var33;
      *ptr0 = var0;
      ptr0++;
      *ptr1 = var1;
      ptr1++;
    }
  }

}

#else
static void
_backup_orc_rrshift6_sub_s16_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 8160;
  const int16_t var17 = 6;
  int16_t var32;
  int16_t var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      var1 = *ptr1;
      /* 0: subw */
      var32 = var1 - var16;
      /* 1: shrsw */
      var33 = var32 >> var17;
      /* 2: copyw */
      var1 = var33;
      /* 3: subw */
      var0 = var0 - var33;
      *ptr0 = var0;
      ptr0++;
      *ptr1 = var1;
      ptr1++;
    }
  }

}

void
orc_rrshift6_sub_s16_2d (int16_t * d1, int d1_stride, int16_t * d2, int d2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_rrshift6_sub_s16_2d");
      orc_program_set_backup_function (p, _backup_orc_rrshift6_sub_s16_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 8160, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;

  orc_executor_run (ex);
}
#endif


/* orc_rrshift6_s16_ip_2d */
#ifdef DISABLE_ORC
void
orc_rrshift6_s16_ip_2d (int16_t * d1, int d1_stride, int n, int m){
  int i;
  int j;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 8160;
  const int16_t var17 = 6;
  int16_t var32;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      /* 0: subw */
      var32 = var0 - var16;
      /* 1: shrsw */
      var0 = var32 >> var17;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_rrshift6_s16_ip_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 8160;
  const int16_t var17 = 6;
  int16_t var32;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      /* 0: subw */
      var32 = var0 - var16;
      /* 1: shrsw */
      var0 = var32 >> var17;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_rrshift6_s16_ip_2d (int16_t * d1, int d1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_rrshift6_s16_ip_2d");
      orc_program_set_backup_function (p, _backup_orc_rrshift6_s16_ip_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 8160, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;

  orc_executor_run (ex);
}
#endif


/* orc_rrshift6_s16_ip */
#ifdef DISABLE_ORC
void
orc_rrshift6_s16_ip (int16_t * d1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 8160;
  const int16_t var17 = 6;
  int16_t var32;

  ptr0 = d1;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: subw */
    var32 = var0 - var16;
    /* 1: shrsw */
    var0 = var32 >> var17;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_rrshift6_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 8160;
  const int16_t var17 = 6;
  int16_t var32;

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: subw */
    var32 = var0 - var16;
    /* 1: shrsw */
    var0 = var32 >> var17;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_rrshift6_s16_ip (int16_t * d1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_rrshift6_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_rrshift6_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 8160, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;

  orc_executor_run (ex);
}
#endif


/* orc_unpack_yuyv_y */
#ifdef DISABLE_ORC
void
orc_unpack_yuyv_y (uint8_t * d1, const uint16_t * s1, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0wb */
    var0 = (uint16_t)var4 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_unpack_yuyv_y (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0wb */
    var0 = (uint16_t)var4 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_unpack_yuyv_y (uint8_t * d1, const uint16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_yuyv_y");
      orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_y);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_unpack_yuyv_u */
#ifdef DISABLE_ORC
void
orc_unpack_yuyv_u (uint8_t * d1, const uint32_t * s1, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (uint32_t)var4 & 0xffff;
    /* 1: select1wb */
    var0 = ((uint16_t)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_unpack_yuyv_u (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (uint32_t)var4 & 0xffff;
    /* 1: select1wb */
    var0 = ((uint16_t)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_unpack_yuyv_u (uint8_t * d1, const uint32_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_yuyv_u");
      orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_u);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_unpack_yuyv_v */
#ifdef DISABLE_ORC
void
orc_unpack_yuyv_v (uint8_t * d1, const uint32_t * s1, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((uint32_t)var4 >> 16)&0xffff;
    /* 1: select1wb */
    var0 = ((uint16_t)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_unpack_yuyv_v (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((uint32_t)var4 >> 16)&0xffff;
    /* 1: select1wb */
    var0 = ((uint16_t)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_unpack_yuyv_v (uint8_t * d1, const uint32_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_yuyv_v");
      orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_v);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "select1lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_packyuyv */
#ifdef DISABLE_ORC
void
orc_packyuyv (uint32_t * d1, const uint8_t * s1, const uint8_t * s2, const uint8_t * s3, int n){
  int i;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var32;
  int8_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: copyw */
    var36 = var4;
    /* 1: select0wb */
    var32 = (uint16_t)var36 & 0xff;
    /* 2: select1wb */
    var33 = ((uint16_t)var36 >> 8)&0xff;
    /* 3: mergebw */
    var34 = ((uint8_t)var32) | ((uint8_t)var5 << 8);
    /* 4: mergebw */
    var35 = ((uint8_t)var33) | ((uint8_t)var6 << 8);
    /* 5: mergewl */
    var0 = ((uint16_t)var34) | ((uint16_t)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_packyuyv (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var32;
  int8_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: copyw */
    var36 = var4;
    /* 1: select0wb */
    var32 = (uint16_t)var36 & 0xff;
    /* 2: select1wb */
    var33 = ((uint16_t)var36 >> 8)&0xff;
    /* 3: mergebw */
    var34 = ((uint8_t)var32) | ((uint8_t)var5 << 8);
    /* 4: mergebw */
    var35 = ((uint8_t)var33) | ((uint8_t)var6 << 8);
    /* 5: mergewl */
    var0 = ((uint16_t)var34) | ((uint16_t)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_packyuyv (uint32_t * d1, const uint8_t * s1, const uint8_t * s2, const uint8_t * s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_packyuyv");
      orc_program_set_backup_function (p, _backup_orc_packyuyv);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append (p, "copyw", ORC_VAR_T5, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "select0wb", ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append (p, "select1wb", ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append (p, "mergebw", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S2);
      orc_program_append (p, "mergebw", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_S3);
      orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  orc_executor_run (ex);
}
#endif


/* orc_unpack_uyvy_y */
#ifdef DISABLE_ORC
void
orc_unpack_uyvy_y (uint8_t * d1, const uint16_t * s1, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1wb */
    var0 = ((uint16_t)var4 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_unpack_uyvy_y (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1wb */
    var0 = ((uint16_t)var4 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_unpack_uyvy_y (uint8_t * d1, const uint16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_uyvy_y");
      orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_y);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_unpack_uyvy_u */
#ifdef DISABLE_ORC
void
orc_unpack_uyvy_u (uint8_t * d1, const uint32_t * s1, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (uint32_t)var4 & 0xffff;
    /* 1: select0wb */
    var0 = (uint16_t)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_unpack_uyvy_u (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (uint32_t)var4 & 0xffff;
    /* 1: select0wb */
    var0 = (uint16_t)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_unpack_uyvy_u (uint8_t * d1, const uint32_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_uyvy_u");
      orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_u);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_unpack_uyvy_v */
#ifdef DISABLE_ORC
void
orc_unpack_uyvy_v (uint8_t * d1, const uint32_t * s1, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((uint32_t)var4 >> 16)&0xffff;
    /* 1: select0wb */
    var0 = (uint16_t)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_unpack_uyvy_v (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((uint32_t)var4 >> 16)&0xffff;
    /* 1: select0wb */
    var0 = (uint16_t)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_unpack_uyvy_v (uint8_t * d1, const uint32_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_unpack_uyvy_v");
      orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_v);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "select1lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_interleave2_s16 */
#ifdef DISABLE_ORC
void
orc_interleave2_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mergewl */
    var0 = ((uint16_t)var4) | ((uint16_t)var5 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_interleave2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mergewl */
    var0 = ((uint16_t)var4) | ((uint16_t)var5 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_interleave2_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_interleave2_s16");
      orc_program_set_backup_function (p, _backup_orc_interleave2_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");

      orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_interleave2_rrshift1_s16 */
#ifdef DISABLE_ORC
void
orc_interleave2_rrshift1_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  const int16_t var18 = 1;
  const int16_t var19 = 1;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: shrsw */
    var34 = var32 >> var17;
    /* 2: addw */
    var33 = var5 + var18;
    /* 3: shrsw */
    var35 = var33 >> var19;
    /* 4: mergewl */
    var0 = ((uint16_t)var34) | ((uint16_t)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_interleave2_rrshift1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  const int16_t var18 = 1;
  const int16_t var19 = 1;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: shrsw */
    var34 = var32 >> var17;
    /* 2: addw */
    var33 = var5 + var18;
    /* 3: shrsw */
    var35 = var33 >> var19;
    /* 4: mergewl */
    var0 = ((uint16_t)var34) | ((uint16_t)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_interleave2_rrshift1_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_interleave2_rrshift1_s16");
      orc_program_set_backup_function (p, _backup_orc_interleave2_rrshift1_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 1, "c2");
      orc_program_add_constant (p, 2, 1, "c3");
      orc_program_add_constant (p, 2, 1, "c4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_C3);
      orc_program_append (p, "shrsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4);
      orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_deinterleave2_s16 */
#ifdef DISABLE_ORC
void
orc_deinterleave2_s16 (int16_t * d1, int16_t * d2, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  int32_t var32;

  ptr0 = d1;
  ptr1 = d2;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var32 = var4;
    /* 1: select0lw */
    var0 = (uint32_t)var32 & 0xffff;
    /* 2: select1lw */
    var1 = ((uint32_t)var32 >> 16)&0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_deinterleave2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  int32_t var32;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var32 = var4;
    /* 1: select0lw */
    var0 = (uint32_t)var32 & 0xffff;
    /* 2: select1lw */
    var1 = ((uint32_t)var32 >> 16)&0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_deinterleave2_s16 (int16_t * d1, int16_t * d2, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_deinterleave2_s16");
      orc_program_set_backup_function (p, _backup_orc_deinterleave2_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append (p, "copyl", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "select0lw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "select1lw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_deinterleave2_lshift1_s16 */
#ifdef DISABLE_ORC
void
orc_deinterleave2_lshift1_s16 (int16_t * d1, int16_t * d2, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  int32_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = d1;
  ptr1 = d2;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var32 = var4;
    /* 1: select0lw */
    var33 = (uint32_t)var32 & 0xffff;
    /* 2: shlw */
    var0 = var33 << var16;
    /* 3: select1lw */
    var34 = ((uint32_t)var32 >> 16)&0xffff;
    /* 4: shlw */
    var1 = var34 << var17;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_deinterleave2_lshift1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  int32_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var32 = var4;
    /* 1: select0lw */
    var33 = (uint32_t)var32 & 0xffff;
    /* 2: shlw */
    var0 = var33 << var16;
    /* 3: select1lw */
    var34 = ((uint32_t)var32 >> 16)&0xffff;
    /* 4: shlw */
    var1 = var34 << var17;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_deinterleave2_lshift1_s16 (int16_t * d1, int16_t * d2, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_deinterleave2_lshift1_s16");
      orc_program_set_backup_function (p, _backup_orc_deinterleave2_lshift1_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 1, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append (p, "copyl", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "select0lw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "shlw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "select1lw", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "shlw", ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_C2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_haar_deint_lshift1_split_s16 */
#ifdef DISABLE_ORC
void
orc_haar_deint_lshift1_split_s16 (int16_t * d1, int16_t * d2, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  const int16_t var18 = 0;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  ptr0 = d1;
  ptr1 = d2;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var34 = var4;
    /* 1: select0lw */
    var32 = (uint32_t)var34 & 0xffff;
    /* 2: select1lw */
    var33 = ((uint32_t)var34 >> 16)&0xffff;
    /* 3: shlw */
    var35 = var32 << var16;
    /* 4: shlw */
    var36 = var33 << var17;
    /* 5: subw */
    var37 = var36 - var35;
    /* 6: copyw */
    var1 = var37;
    /* 7: avgsw */
    var38 = (var37 + var18 + 1)>>1;
    /* 8: addw */
    var0 = var35 + var38;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_haar_deint_lshift1_split_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  const int16_t var18 = 0;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var34 = var4;
    /* 1: select0lw */
    var32 = (uint32_t)var34 & 0xffff;
    /* 2: select1lw */
    var33 = ((uint32_t)var34 >> 16)&0xffff;
    /* 3: shlw */
    var35 = var32 << var16;
    /* 4: shlw */
    var36 = var33 << var17;
    /* 5: subw */
    var37 = var36 - var35;
    /* 6: copyw */
    var1 = var37;
    /* 7: avgsw */
    var38 = (var37 + var18 + 1)>>1;
    /* 8: addw */
    var0 = var35 + var38;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_haar_deint_lshift1_split_s16 (int16_t * d1, int16_t * d2, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_deint_lshift1_split_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_deint_lshift1_split_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 1, "c2");
      orc_program_add_constant (p, 2, 0, "c3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append (p, "copyl", ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "select1lw", ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "shlw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2);
      orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_haar_deint_split_s16 */
#ifdef DISABLE_ORC
void
orc_haar_deint_split_s16 (int16_t * d1, int16_t * d2, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;

  ptr0 = d1;
  ptr1 = d2;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var34 = var4;
    /* 1: select0lw */
    var32 = (uint32_t)var34 & 0xffff;
    /* 2: select1lw */
    var33 = ((uint32_t)var34 >> 16)&0xffff;
    /* 3: subw */
    var35 = var33 - var32;
    /* 4: copyw */
    var1 = var35;
    /* 5: avgsw */
    var36 = (var35 + var16 + 1)>>1;
    /* 6: addw */
    var0 = var32 + var36;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_haar_deint_split_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var34 = var4;
    /* 1: select0lw */
    var32 = (uint32_t)var34 & 0xffff;
    /* 2: select1lw */
    var33 = ((uint32_t)var34 >> 16)&0xffff;
    /* 3: subw */
    var35 = var33 - var32;
    /* 4: copyw */
    var1 = var35;
    /* 5: avgsw */
    var36 = (var35 + var16 + 1)>>1;
    /* 6: addw */
    var0 = var32 + var36;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_haar_deint_split_s16 (int16_t * d1, int16_t * d2, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_deint_split_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_deint_split_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append (p, "copyl", ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "select1lw", ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_haar_split_s16_lo */
#ifdef DISABLE_ORC
void
orc_haar_split_s16_lo (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: subw */
    var33 = var5 - var32;
    /* 2: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 3: addw */
    var0 = var32 + var34;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_split_s16_lo (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: subw */
    var33 = var5 - var32;
    /* 2: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 3: addw */
    var0 = var32 + var34;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_split_s16_lo (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_split_s16_lo");
      orc_program_set_backup_function (p, _backup_orc_haar_split_s16_lo);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_T1);
      orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_split_s16_hi */
#ifdef DISABLE_ORC
void
orc_haar_split_s16_hi (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subw */
    var0 = var5 - var4;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_split_s16_hi (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subw */
    var0 = var5 - var4;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_split_s16_hi (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_split_s16_hi");
      orc_program_set_backup_function (p, _backup_orc_haar_split_s16_hi);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");

      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S2, ORC_VAR_S1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_split_s16_op */
#ifdef DISABLE_ORC
void
orc_haar_split_s16_op (int16_t * d1, int16_t * d2, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = d1;
  ptr1 = d2;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: subw */
    var33 = var5 - var32;
    /* 2: copyw */
    var1 = var33;
    /* 3: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 4: addw */
    var0 = var32 + var34;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_haar_split_s16_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: subw */
    var33 = var5 - var32;
    /* 2: copyw */
    var1 = var33;
    /* 3: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 4: addw */
    var0 = var32 + var34;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_haar_split_s16_op (int16_t * d1, int16_t * d2, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_split_s16_op");
      orc_program_set_backup_function (p, _backup_orc_haar_split_s16_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_T1);
      orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_split_s16 */
#ifdef DISABLE_ORC
void
orc_haar_split_s16 (int16_t * d1, int16_t * d2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = d1;
  ptr1 = d2;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var0;
    /* 1: copyw */
    var33 = var1;
    /* 2: subw */
    var34 = var33 - var32;
    /* 3: copyw */
    var1 = var34;
    /* 4: avgsw */
    var35 = (var34 + var16 + 1)>>1;
    /* 5: addw */
    var0 = var32 + var35;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_haar_split_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var0;
    /* 1: copyw */
    var33 = var1;
    /* 2: subw */
    var34 = var33 - var32;
    /* 3: copyw */
    var1 = var34;
    /* 4: avgsw */
    var35 = (var34 + var16 + 1)>>1;
    /* 5: addw */
    var0 = var32 + var35;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_haar_split_s16 (int16_t * d1, int16_t * d2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_split_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_split_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_D2, ORC_VAR_D1);
      orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_synth_s16_lo */
#ifdef DISABLE_ORC
void
orc_haar_synth_s16_lo (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var32 = (var5 + var16 + 1)>>1;
    /* 1: subw */
    var0 = var4 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_synth_s16_lo (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var32 = (var5 + var16 + 1)>>1;
    /* 1: subw */
    var0 = var4 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_synth_s16_lo (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s16_lo");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_lo);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_synth_s16_hi */
#ifdef DISABLE_ORC
void
orc_haar_synth_s16_hi (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var32 = var4 - var34;
    /* 3: addw */
    var0 = var33 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_synth_s16_hi (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var32 = var4 - var34;
    /* 3: addw */
    var0 = var33 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_synth_s16_hi (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s16_hi");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_hi);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "avgsw", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T3);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_synth_s16_op */
#ifdef DISABLE_ORC
void
orc_haar_synth_s16_op (int16_t * d1, int16_t * d2, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = d1;
  ptr1 = d2;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var32 = var4 - var34;
    /* 3: copyw */
    var0 = var32;
    /* 4: addw */
    var1 = var33 + var32;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_haar_synth_s16_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var32 = var4 - var34;
    /* 3: copyw */
    var0 = var32;
    /* 4: addw */
    var1 = var33 + var32;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_haar_synth_s16_op (int16_t * d1, int16_t * d2, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s16_op");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_op);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "avgsw", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T3);
      orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_synth_s16 */
#ifdef DISABLE_ORC
void
orc_haar_synth_s16 (int16_t * d1, int16_t * d2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = d1;
  ptr1 = d2;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var0;
    /* 1: copyw */
    var33 = var1;
    /* 2: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 3: subw */
    var35 = var32 - var34;
    /* 4: copyw */
    var0 = var35;
    /* 5: addw */
    var1 = var33 + var35;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_haar_synth_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var0;
    /* 1: copyw */
    var33 = var1;
    /* 2: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 3: subw */
    var35 = var32 - var34;
    /* 4: copyw */
    var0 = var35;
    /* 5: addw */
    var1 = var33 + var35;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_haar_synth_s16 (int16_t * d1, int16_t * d2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_D2, ORC_VAR_D1);
      orc_program_append (p, "avgsw", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3);
      orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_synth_rrshift1_int_s16 */
#ifdef DISABLE_ORC
void
orc_haar_synth_rrshift1_int_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  const int16_t var17 = 0;
  const int16_t var18 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var32 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var34 = var4 - var32;
    /* 3: addw */
    var35 = var33 + var34;
    /* 4: avgsw */
    var36 = (var34 + var17 + 1)>>1;
    /* 5: avgsw */
    var37 = (var35 + var18 + 1)>>1;
    /* 6: mergewl */
    var0 = ((uint16_t)var36) | ((uint16_t)var37 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_synth_rrshift1_int_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  const int16_t var17 = 0;
  const int16_t var18 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var32 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var34 = var4 - var32;
    /* 3: addw */
    var35 = var33 + var34;
    /* 4: avgsw */
    var36 = (var34 + var17 + 1)>>1;
    /* 5: avgsw */
    var37 = (var35 + var18 + 1)>>1;
    /* 6: mergewl */
    var0 = ((uint16_t)var36) | ((uint16_t)var37 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_synth_rrshift1_int_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_rrshift1_int_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_rrshift1_int_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_constant (p, 2, 0, "c2");
      orc_program_add_constant (p, 2, 0, "c3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3);
      orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_synth_int_s16 */
#ifdef DISABLE_ORC
void
orc_haar_synth_int_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n){
  int i;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var32 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var34 = var4 - var32;
    /* 3: addw */
    var35 = var33 + var34;
    /* 4: mergewl */
    var0 = ((uint16_t)var34) | ((uint16_t)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_synth_int_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var32 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var34 = var4 - var32;
    /* 3: addw */
    var35 = var33 + var34;
    /* 4: mergewl */
    var0 = ((uint16_t)var34) | ((uint16_t)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_synth_int_s16 (int16_t * d1, const int16_t * s1, const int16_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_synth_int_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_synth_int_s16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_haar_sub_s16 */
#ifdef DISABLE_ORC
void
orc_haar_sub_s16 (int16_t * d1, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: subw */
    var0 = var0 - var4;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_sub_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: subw */
    var0 = var0 - var4;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_sub_s16 (int16_t * d1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_sub_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_sub_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_haar_add_half_s16 */
#ifdef DISABLE_ORC
void
orc_haar_add_half_s16 (int16_t * d1, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 0;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: avgsw */
    var32 = (var4 + var16 + 1)>>1;
    /* 1: addw */
    var0 = var0 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_add_half_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 0;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: avgsw */
    var32 = (var4 + var16 + 1)>>1;
    /* 1: addw */
    var0 = var0 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_add_half_s16 (int16_t * d1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_add_half_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_add_half_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_haar_add_s16 */
#ifdef DISABLE_ORC
void
orc_haar_add_s16 (int16_t * d1, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var0 = var0 + var4;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_add_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var0 = var0 + var4;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_add_s16 (int16_t * d1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_add_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_add_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_haar_sub_half_s16 */
#ifdef DISABLE_ORC
void
orc_haar_sub_half_s16 (int16_t * d1, const int16_t * s1, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 0;
  int16_t var32;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: avgsw */
    var32 = (var4 + var16 + 1)>>1;
    /* 1: subw */
    var0 = var0 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_haar_sub_half_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 0;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: avgsw */
    var32 = (var4 + var16 + 1)>>1;
    /* 1: subw */
    var0 = var0 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_haar_sub_half_s16 (int16_t * d1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_haar_sub_half_s16");
      orc_program_set_backup_function (p, _backup_orc_haar_sub_half_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
}
#endif


/* orc_sum_u8 */
#ifdef DISABLE_ORC
void
orc_sum_u8 (int32_t * a1, const uint8_t * s1, int n){
  int i;
  int8_t var4;
  const int8_t * ptr4;
  int32_t var12 = 0;
  int16_t var32;
  int32_t var33;

  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: convuwl */
    var33 = (uint16_t)var32;
    /* 2: accl */
    var12 = var12 + var33;
  }
  *a1 = var12;

}

#else
static void
_backup_orc_sum_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var4;
  const int8_t * ptr4;
  int32_t var12 = 0;
  int16_t var32;
  int32_t var33;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: convuwl */
    var33 = (uint16_t)var32;
    /* 2: accl */
    var12 = var12 + var33;
  }
  ex->accumulators[0] = var12;

}

void
orc_sum_u8 (int32_t * a1, const uint8_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_sum_u8");
      orc_program_set_backup_function (p, _backup_orc_sum_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_ds (p, "convubw", ORC_VAR_T1, ORC_VAR_S1);
      orc_program_append_ds (p, "convuwl", ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append_ds (p, "accl", ORC_VAR_A1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sum_s16 */
#ifdef DISABLE_ORC
void
orc_sum_s16 (int32_t * a1, const int16_t * s1, int n){
  int i;
  int16_t var4;
  const int16_t * ptr4;
  int32_t var12 = 0;
  int32_t var32;

  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convswl */
    var32 = var4;
    /* 1: accl */
    var12 = var12 + var32;
  }
  *a1 = var12;

}

#else
static void
_backup_orc_sum_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var4;
  const int16_t * ptr4;
  int32_t var12 = 0;
  int32_t var32;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convswl */
    var32 = var4;
    /* 1: accl */
    var12 = var12 + var32;
  }
  ex->accumulators[0] = var12;

}

void
orc_sum_s16 (int32_t * a1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_sum_s16");
      orc_program_set_backup_function (p, _backup_orc_sum_s16);
      orc_program_add_source (p, 2, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_ds (p, "convswl", ORC_VAR_T1, ORC_VAR_S1);
      orc_program_append_ds (p, "accl", ORC_VAR_A1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sum_square_diff_u8 */
#ifdef DISABLE_ORC
void
orc_sum_square_diff_u8 (int32_t * a1, const uint8_t * s1, const uint8_t * s2, int n){
  int i;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;

  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: convubw */
    var33 = (uint8_t)var5;
    /* 2: subw */
    var35 = var32 - var33;
    /* 3: mullw */
    var36 = (var35 * var35) & 0xffff;
    /* 4: convuwl */
    var34 = (uint16_t)var36;
    /* 5: accl */
    var12 = var12 + var34;
  }
  *a1 = var12;

}

#else
static void
_backup_orc_sum_square_diff_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;

  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: convubw */
    var33 = (uint8_t)var5;
    /* 2: subw */
    var35 = var32 - var33;
    /* 3: mullw */
    var36 = (var35 * var35) & 0xffff;
    /* 4: convuwl */
    var34 = (uint16_t)var36;
    /* 5: accl */
    var12 = var12 + var34;
  }
  ex->accumulators[0] = var12;

}

void
orc_sum_square_diff_u8 (int32_t * a1, const uint8_t * s1, const uint8_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_sum_square_diff_u8");
      orc_program_set_backup_function (p, _backup_orc_sum_square_diff_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_ds (p, "convubw", ORC_VAR_T1, ORC_VAR_S1);
      orc_program_append_ds (p, "convubw", ORC_VAR_T2, ORC_VAR_S2);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T1);
      orc_program_append_ds (p, "convuwl", ORC_VAR_T3, ORC_VAR_T1);
      orc_program_append_ds (p, "accl", ORC_VAR_A1, ORC_VAR_T3);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_dequantise_s16_2d_4xn */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_2d_4xn (int16_t * d1, int d1_stride, const int16_t * s1, int s1_stride, int p1, int p2, int m){
  int i;
  int j;
  int n = 4;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      /* 0: copyw */
      var32 = var4;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_dequantise_s16_2d_4xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 4;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      /* 0: copyw */
      var32 = var4;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_dequantise_s16_2d_4xn (int16_t * d1, int d1_stride, const int16_t * s1, int s1_stride, int p1, int p2, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 4);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_dequantise_s16_2d_4xn");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_2d_4xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 4;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_dequantise_s16_2d_8xn */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_2d_8xn (int16_t * d1, int d1_stride, const int16_t * s1, int s1_stride, int p1, int p2, int m){
  int i;
  int j;
  int n = 8;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      /* 0: copyw */
      var32 = var4;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_dequantise_s16_2d_8xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      /* 0: copyw */
      var32 = var4;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_dequantise_s16_2d_8xn (int16_t * d1, int d1_stride, const int16_t * s1, int s1_stride, int p1, int p2, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_dequantise_s16_2d_8xn");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_2d_8xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_dequantise_s16_ip_2d_8xn */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_ip_2d_8xn (int16_t * d1, int d1_stride, int p1, int p2, int m){
  int i;
  int j;
  int n = 8;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      /* 0: copyw */
      var32 = var0;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_dequantise_s16_ip_2d_8xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      /* 0: copyw */
      var32 = var0;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_dequantise_s16_ip_2d_8xn (int16_t * d1, int d1_stride, int p1, int p2, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_dequantise_s16_ip_2d_8xn");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip_2d_8xn);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_dequantise_s16_ip_2d */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_ip_2d (int16_t * d1, int d1_stride, int p1, int p2, int n, int m){
  int i;
  int j;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      /* 0: copyw */
      var32 = var0;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_dequantise_s16_ip_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      /* 0: copyw */
      var32 = var0;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_dequantise_s16_ip_2d (int16_t * d1, int d1_stride, int p1, int p2, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_dequantise_s16_ip_2d");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip_2d);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_dequantise_s16_ip */
#ifdef DISABLE_ORC
void
orc_dequantise_s16_ip (int16_t * d1, int p1, int p2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = d1;

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: copyw */
    var32 = var0;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: mullw */
    var35 = (var34 * var24) & 0xffff;
    /* 4: addw */
    var36 = var35 + var25;
    /* 5: shrsw */
    var37 = var36 >> var16;
    /* 6: mullw */
    var0 = (var37 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_dequantise_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: copyw */
    var32 = var0;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: mullw */
    var35 = (var34 * var24) & 0xffff;
    /* 4: addw */
    var36 = var35 + var25;
    /* 5: shrsw */
    var37 = var36 >> var16;
    /* 6: mullw */
    var0 = (var37 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_dequantise_s16_ip (int16_t * d1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_dequantise_s16_ip");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_dequantise_s16 */
#ifdef DISABLE_ORC
void
orc_dequantise_s16 (int16_t * d1, const int16_t * s1, int p1, int p2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var32 = var4;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: mullw */
    var35 = (var34 * var24) & 0xffff;
    /* 4: addw */
    var36 = var35 + var25;
    /* 5: shrsw */
    var37 = var36 >> var16;
    /* 6: mullw */
    var0 = (var37 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_dequantise_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var32 = var4;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: mullw */
    var35 = (var34 * var24) & 0xffff;
    /* 4: addw */
    var36 = var35 + var25;
    /* 5: shrsw */
    var37 = var36 >> var16;
    /* 6: mullw */
    var0 = (var37 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_dequantise_s16 (int16_t * d1, const int16_t * s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_dequantise_s16");
      orc_program_set_backup_function (p, _backup_orc_dequantise_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_quantise1_s16 */
#ifdef DISABLE_ORC
void
orc_quantise1_s16 (int16_t * d1, const int16_t * s1, int p1, int p2, int p3, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var32 = var4;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: mulhuw */
    var37 = ((uint32_t)((uint16_t)var36) * (uint32_t)((uint16_t)var24)) >> 16;
    /* 6: shruw */
    var38 = ((uint16_t)var37) >> var26;
    /* 7: mullw */
    var0 = (var38 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_quantise1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var32 = var4;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: mulhuw */
    var37 = ((uint32_t)((uint16_t)var36) * (uint32_t)((uint16_t)var24)) >> 16;
    /* 6: shruw */
    var38 = ((uint16_t)var37) >> var26;
    /* 7: mullw */
    var0 = (var38 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_quantise1_s16 (int16_t * d1, const int16_t * s1, int p1, int p2, int p3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantise1_s16");
      orc_program_set_backup_function (p, _backup_orc_quantise1_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "mulhuw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "shruw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;

  orc_executor_run (ex);
}
#endif


/* orc_quantise2_s16 */
#ifdef DISABLE_ORC
void
orc_quantise2_s16 (int16_t * d1, const int16_t * s1, int p1, int p2, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = d1;
  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var32 = var4;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: shruw */
    var37 = ((uint16_t)var36) >> var24;
    /* 6: mullw */
    var0 = (var37 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_quantise2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var32 = var4;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: shruw */
    var37 = ((uint16_t)var36) >> var24;
    /* 6: mullw */
    var0 = (var37 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_quantise2_s16 (int16_t * d1, const int16_t * s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantise2_s16");
      orc_program_set_backup_function (p, _backup_orc_quantise2_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "shruw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  orc_executor_run (ex);
}
#endif


/* orc_quantdequant1_s16 */
#ifdef DISABLE_ORC
void
orc_quantdequant1_s16 (int16_t * d1, int16_t * d2, int p1, int p2, int p3, int p4, int p5, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  const int16_t var28 = p5;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  ptr0 = d1;
  ptr1 = d2;

  for (i = 0; i < n; i++) {
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var1;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: mulhuw */
    var37 = ((uint32_t)((uint16_t)var36) * (uint32_t)((uint16_t)var24)) >> 16;
    /* 6: shruw */
    var38 = ((uint16_t)var37) >> var26;
    /* 7: mullw */
    var39 = (var38 * var33) & 0xffff;
    /* 8: copyw */
    var0 = var39;
    /* 9: signw */
    var40 = ORC_CLAMP(var39,-1,1);
    /* 10: mullw */
    var41 = (var38 * var27) & 0xffff;
    /* 11: addw */
    var42 = var41 + var28;
    /* 12: shrsw */
    var43 = var42 >> var17;
    /* 13: mullw */
    var1 = (var43 * var40) & 0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_quantdequant1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  const int16_t var28 = ex->params[28];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var1;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: mulhuw */
    var37 = ((uint32_t)((uint16_t)var36) * (uint32_t)((uint16_t)var24)) >> 16;
    /* 6: shruw */
    var38 = ((uint16_t)var37) >> var26;
    /* 7: mullw */
    var39 = (var38 * var33) & 0xffff;
    /* 8: copyw */
    var0 = var39;
    /* 9: signw */
    var40 = ORC_CLAMP(var39,-1,1);
    /* 10: mullw */
    var41 = (var38 * var27) & 0xffff;
    /* 11: addw */
    var42 = var41 + var28;
    /* 12: shrsw */
    var43 = var42 >> var17;
    /* 13: mullw */
    var1 = (var43 * var40) & 0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_quantdequant1_s16 (int16_t * d1, int16_t * d2, int p1, int p2, int p3, int p4, int p5, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantdequant1_s16");
      orc_program_set_backup_function (p, _backup_orc_quantdequant1_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "mulhuw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "shruw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2);
      orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P5);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "mullw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  orc_executor_run (ex);
}
#endif


/* orc_quantdequant3_s16 */
#ifdef DISABLE_ORC
void
orc_quantdequant3_s16 (int16_t * d1, int16_t * d2, int p1, int p2, int p3, int p4, int p5, int p6, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  const int16_t var28 = p5;
  const int32_t var29 = p6;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int32_t var38;
  int32_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;
  int16_t var44;
  int16_t var45;

  ptr0 = d1;
  ptr1 = d2;

  for (i = 0; i < n; i++) {
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var1;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var35 = ORC_ABS(var32);
    /* 3: shlw */
    var36 = var35 << var16;
    /* 4: subw */
    var37 = var36 - var25;
    /* 5: muluwl */
    var34 = (uint16_t)var37 * (uint16_t)var24;
    /* 6: addl */
    var38 = var34 + var29;
    /* 7: shrul */
    var39 = ((uint32_t)var38) >> var26;
    /* 8: convlw */
    var40 = var39;
    /* 9: mullw */
    var41 = (var40 * var33) & 0xffff;
    /* 10: copyw */
    var0 = var41;
    /* 11: signw */
    var42 = ORC_CLAMP(var41,-1,1);
    /* 12: mullw */
    var43 = (var40 * var27) & 0xffff;
    /* 13: addw */
    var44 = var43 + var28;
    /* 14: shrsw */
    var45 = var44 >> var17;
    /* 15: mullw */
    var1 = (var45 * var42) & 0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_quantdequant3_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  const int16_t var28 = ex->params[28];
  const int32_t var29 = ex->params[29];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int32_t var38;
  int32_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;
  int16_t var44;
  int16_t var45;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var1;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var35 = ORC_ABS(var32);
    /* 3: shlw */
    var36 = var35 << var16;
    /* 4: subw */
    var37 = var36 - var25;
    /* 5: muluwl */
    var34 = (uint16_t)var37 * (uint16_t)var24;
    /* 6: addl */
    var38 = var34 + var29;
    /* 7: shrul */
    var39 = ((uint32_t)var38) >> var26;
    /* 8: convlw */
    var40 = var39;
    /* 9: mullw */
    var41 = (var40 * var33) & 0xffff;
    /* 10: copyw */
    var0 = var41;
    /* 11: signw */
    var42 = ORC_CLAMP(var41,-1,1);
    /* 12: mullw */
    var43 = (var40 * var27) & 0xffff;
    /* 13: addw */
    var44 = var43 + var28;
    /* 14: shrsw */
    var45 = var44 >> var17;
    /* 15: mullw */
    var1 = (var45 * var42) & 0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_quantdequant3_s16 (int16_t * d1, int16_t * d2, int p1, int p2, int p3, int p4, int p5, int p6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantdequant3_s16");
      orc_program_set_backup_function (p, _backup_orc_quantdequant3_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_parameter (p, 4, "p6");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "muluwl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P6);
      orc_program_append (p, "shrul", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P3);
      orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2);
      orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P5);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "mullw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;
  ex->params[ORC_VAR_P6] = p6;

  orc_executor_run (ex);
}
#endif


/* orc_quantdequant2_s16 */
#ifdef DISABLE_ORC
void
orc_quantdequant2_s16 (int16_t * d1, int16_t * d2, int p1, int p2, int p3, int p4, int n){
  int i;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;

  ptr0 = d1;
  ptr1 = d2;

  for (i = 0; i < n; i++) {
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var1;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: shruw */
    var37 = ((uint16_t)var36) >> var24;
    /* 6: mullw */
    var38 = (var37 * var33) & 0xffff;
    /* 7: copyw */
    var0 = var38;
    /* 8: signw */
    var39 = ORC_CLAMP(var38,-1,1);
    /* 9: mullw */
    var40 = (var37 * var26) & 0xffff;
    /* 10: addw */
    var41 = var40 + var27;
    /* 11: shrsw */
    var42 = var41 >> var17;
    /* 12: mullw */
    var1 = (var42 * var39) & 0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

#else
static void
_backup_orc_quantdequant2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var1;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: shruw */
    var37 = ((uint16_t)var36) >> var24;
    /* 6: mullw */
    var38 = (var37 * var33) & 0xffff;
    /* 7: copyw */
    var0 = var38;
    /* 8: signw */
    var39 = ORC_CLAMP(var38,-1,1);
    /* 9: mullw */
    var40 = (var37 * var26) & 0xffff;
    /* 10: addw */
    var41 = var40 + var27;
    /* 11: shrsw */
    var42 = var41 >> var17;
    /* 12: mullw */
    var1 = (var42 * var39) & 0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

void
orc_quantdequant2_s16 (int16_t * d1, int16_t * d2, int p1, int p2, int p3, int p4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_quantdequant2_s16");
      orc_program_set_backup_function (p, _backup_orc_quantdequant2_s16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "shruw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2);
      orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "mullw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_downsample_vert_u8 */
#ifdef DISABLE_ORC
void
orc_downsample_vert_u8 (uint8_t * d1, const uint8_t * s1, const uint8_t * s2, const uint8_t * s3, const uint8_t * s4, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 6;
  const int16_t var17 = 26;
  const int16_t var18 = 32;
  const int16_t var19 = 6;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;
  ptr6 = s3;
  ptr7 = s4;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: convubw */
    var33 = (uint8_t)var7;
    /* 2: addw */
    var35 = var32 + var33;
    /* 3: mullw */
    var36 = (var35 * var16) & 0xffff;
    /* 4: convubw */
    var37 = (uint8_t)var5;
    /* 5: convubw */
    var34 = (uint8_t)var6;
    /* 6: addw */
    var38 = var37 + var34;
    /* 7: mullw */
    var39 = (var38 * var17) & 0xffff;
    /* 8: addw */
    var40 = var39 + var36;
    /* 9: addw */
    var41 = var40 + var18;
    /* 10: shruw */
    var42 = ((uint16_t)var41) >> var19;
    /* 11: convwb */
    var0 = var42;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_downsample_vert_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 6;
  const int16_t var17 = 26;
  const int16_t var18 = 32;
  const int16_t var19 = 6;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: convubw */
    var33 = (uint8_t)var7;
    /* 2: addw */
    var35 = var32 + var33;
    /* 3: mullw */
    var36 = (var35 * var16) & 0xffff;
    /* 4: convubw */
    var37 = (uint8_t)var5;
    /* 5: convubw */
    var34 = (uint8_t)var6;
    /* 6: addw */
    var38 = var37 + var34;
    /* 7: mullw */
    var39 = (var38 * var17) & 0xffff;
    /* 8: addw */
    var40 = var39 + var36;
    /* 9: addw */
    var41 = var40 + var18;
    /* 10: shruw */
    var42 = ((uint16_t)var41) >> var19;
    /* 11: convwb */
    var0 = var42;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_downsample_vert_u8 (uint8_t * d1, const uint8_t * s1, const uint8_t * s2, const uint8_t * s3, const uint8_t * s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_downsample_vert_u8");
      orc_program_set_backup_function (p, _backup_orc_downsample_vert_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 6, "c1");
      orc_program_add_constant (p, 2, 26, "c2");
      orc_program_add_constant (p, 2, 32, "c3");
      orc_program_add_constant (p, 2, 6, "c4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3);
      orc_program_append (p, "shruw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4);
      orc_program_append (p, "convwb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;

  orc_executor_run (ex);
}
#endif


/* orc_downsample_horiz_u8 */
#ifdef DISABLE_ORC
void
orc_downsample_horiz_u8 (uint8_t * d1, const uint8_t * s1, const uint8_t * s2, int n){
  int i;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 6;
  const int16_t var17 = 26;
  const int16_t var18 = 32;
  const int16_t var19 = 6;
  int16_t var32;
  int16_t var33;
  int8_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int8_t var38;
  int16_t var39;
  int16_t var40;
  int8_t var41;
  int16_t var42;
  int8_t var43;
  int16_t var44;
  int16_t var45;
  int16_t var46;
  int16_t var47;
  int16_t var48;

  ptr0 = d1;
  ptr4 = s1;
  ptr5 = s2;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: copyw */
    var33 = var5;
    /* 2: select0wb */
    var34 = (uint16_t)var32 & 0xff;
    /* 3: convubw */
    var35 = (uint8_t)var34;
    /* 4: select1wb */
    var38 = ((uint16_t)var33 >> 8)&0xff;
    /* 5: convubw */
    var36 = (uint8_t)var38;
    /* 6: addw */
    var39 = var35 + var36;
    /* 7: mullw */
    var40 = (var39 * var16) & 0xffff;
    /* 8: select1wb */
    var41 = ((uint16_t)var32 >> 8)&0xff;
    /* 9: convubw */
    var42 = (uint8_t)var41;
    /* 10: select0wb */
    var43 = (uint16_t)var33 & 0xff;
    /* 11: convubw */
    var37 = (uint8_t)var43;
    /* 12: addw */
    var44 = var42 + var37;
    /* 13: mullw */
    var45 = (var44 * var17) & 0xffff;
    /* 14: addw */
    var46 = var40 + var45;
    /* 15: addw */
    var47 = var46 + var18;
    /* 16: shruw */
    var48 = ((uint16_t)var47) >> var19;
    /* 17: convwb */
    var0 = var48;
    *ptr0 = var0;
    ptr0++;
  }

}

#else
static void
_backup_orc_downsample_horiz_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 6;
  const int16_t var17 = 26;
  const int16_t var18 = 32;
  const int16_t var19 = 6;
  int16_t var32;
  int16_t var33;
  int8_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int8_t var38;
  int16_t var39;
  int16_t var40;
  int8_t var41;
  int16_t var42;
  int8_t var43;
  int16_t var44;
  int16_t var45;
  int16_t var46;
  int16_t var47;
  int16_t var48;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: copyw */
    var33 = var5;
    /* 2: select0wb */
    var34 = (uint16_t)var32 & 0xff;
    /* 3: convubw */
    var35 = (uint8_t)var34;
    /* 4: select1wb */
    var38 = ((uint16_t)var33 >> 8)&0xff;
    /* 5: convubw */
    var36 = (uint8_t)var38;
    /* 6: addw */
    var39 = var35 + var36;
    /* 7: mullw */
    var40 = (var39 * var16) & 0xffff;
    /* 8: select1wb */
    var41 = ((uint16_t)var32 >> 8)&0xff;
    /* 9: convubw */
    var42 = (uint8_t)var41;
    /* 10: select0wb */
    var43 = (uint16_t)var33 & 0xff;
    /* 11: convubw */
    var37 = (uint8_t)var43;
    /* 12: addw */
    var44 = var42 + var37;
    /* 13: mullw */
    var45 = (var44 * var17) & 0xffff;
    /* 14: addw */
    var46 = var40 + var45;
    /* 15: addw */
    var47 = var46 + var18;
    /* 16: shruw */
    var48 = ((uint16_t)var47) >> var19;
    /* 17: convwb */
    var0 = var48;
    *ptr0 = var0;
    ptr0++;
  }

}

void
orc_downsample_horiz_u8 (uint8_t * d1, const uint8_t * s1, const uint8_t * s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_downsample_horiz_u8");
      orc_program_set_backup_function (p, _backup_orc_downsample_horiz_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 6, "c1");
      orc_program_add_constant (p, 2, 26, "c2");
      orc_program_add_constant (p, 2, 32, "c3");
      orc_program_add_constant (p, 2, 6, "c4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");

      orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "select0wb", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "select1wb", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5);
      orc_program_append (p, "mullw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1);
      orc_program_append (p, "select1wb", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "select0wb", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append (p, "addw", ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T6);
      orc_program_append (p, "mullw", ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2);
      orc_program_append (p, "addw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5);
      orc_program_append (p, "addw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C3);
      orc_program_append (p, "shruw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4);
      orc_program_append (p, "convwb", ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  orc_executor_run (ex);
}
#endif


/* orc_stats_moment_s16 */
#ifdef DISABLE_ORC
void
orc_stats_moment_s16 (int32_t * a1, const int16_t * s1, int n){
  int i;
  int16_t var4;
  const int16_t * ptr4;
  int32_t var12 = 0;
  const int16_t var16 = 2;
  const int16_t var17 = 0;
  int16_t var32;
  int32_t var33;
  int16_t var34;
  int16_t var35;

  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var32 = ORC_ABS(var4);
    /* 1: subw */
    var34 = var32 - var16;
    /* 2: maxsw */
    var35 = ORC_MAX(var34, var17);
    /* 3: convuwl */
    var33 = (uint16_t)var35;
    /* 4: accl */
    var12 = var12 + var33;
  }
  *a1 = var12;

}

#else
static void
_backup_orc_stats_moment_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var4;
  const int16_t * ptr4;
  int32_t var12 = 0;
  const int16_t var16 = 2;
  const int16_t var17 = 0;
  int16_t var32;
  int32_t var33;
  int16_t var34;
  int16_t var35;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var32 = ORC_ABS(var4);
    /* 1: subw */
    var34 = var32 - var16;
    /* 2: maxsw */
    var35 = ORC_MAX(var34, var17);
    /* 3: convuwl */
    var33 = (uint16_t)var35;
    /* 4: accl */
    var12 = var12 + var33;
  }
  ex->accumulators[0] = var12;

}

void
orc_stats_moment_s16 (int32_t * a1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_stats_moment_s16");
      orc_program_set_backup_function (p, _backup_orc_stats_moment_s16);
      orc_program_add_source (p, 2, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 0, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_ds (p, "absw", ORC_VAR_T1, ORC_VAR_S1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "maxsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append_ds (p, "convuwl", ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append_ds (p, "accl", ORC_VAR_A1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_stats_above_s16 */
#ifdef DISABLE_ORC
void
orc_stats_above_s16 (int32_t * a1, const int16_t * s1, int n){
  int i;
  int16_t var4;
  const int16_t * ptr4;
  int32_t var12 = 0;
  const int16_t var16 = 1;
  const int16_t var17 = 0;
  const int16_t var18 = 1;
  int16_t var32;
  int32_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;

  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var32 = ORC_ABS(var4);
    /* 1: subw */
    var34 = var32 - var16;
    /* 2: maxsw */
    var35 = ORC_MAX(var34, var17);
    /* 3: minsw */
    var36 = ORC_MIN(var35, var18);
    /* 4: convuwl */
    var33 = (uint16_t)var36;
    /* 5: accl */
    var12 = var12 + var33;
  }
  *a1 = var12;

}

#else
static void
_backup_orc_stats_above_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var4;
  const int16_t * ptr4;
  int32_t var12 = 0;
  const int16_t var16 = 1;
  const int16_t var17 = 0;
  const int16_t var18 = 1;
  int16_t var32;
  int32_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var32 = ORC_ABS(var4);
    /* 1: subw */
    var34 = var32 - var16;
    /* 2: maxsw */
    var35 = ORC_MAX(var34, var17);
    /* 3: minsw */
    var36 = ORC_MIN(var35, var18);
    /* 4: convuwl */
    var33 = (uint16_t)var36;
    /* 5: accl */
    var12 = var12 + var33;
  }
  ex->accumulators[0] = var12;

}

void
orc_stats_above_s16 (int32_t * a1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_stats_above_s16");
      orc_program_set_backup_function (p, _backup_orc_stats_above_s16);
      orc_program_add_source (p, 2, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 0, "c2");
      orc_program_add_constant (p, 2, 1, "c3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_ds (p, "absw", ORC_VAR_T1, ORC_VAR_S1);
      orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
      orc_program_append (p, "maxsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
      orc_program_append (p, "minsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C3);
      orc_program_append_ds (p, "convuwl", ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append_ds (p, "accl", ORC_VAR_A1, ORC_VAR_T2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_accw */
#ifdef DISABLE_ORC
void
orc_accw (int * a1, const int16_t * s1, int n){
  int i;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var12 = 0;
  int16_t var32;

  ptr4 = s1;

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var32 = ORC_ABS(var4);
    /* 1: accw */
    var12 = var12 + var32;
  }
  *a1 = (var12 & 0xffff);

}

#else
static void
_backup_orc_accw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var12 = 0;
  int16_t var32;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var32 = ORC_ABS(var4);
    /* 1: accw */
    var12 = var12 + var32;
  }
  ex->accumulators[0] = (var12 & 0xffff);

}

void
orc_accw (int * a1, const int16_t * s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_name (p, "orc_accw");
      orc_program_set_backup_function (p, _backup_orc_accw);
      orc_program_add_source (p, 2, "s1");
      orc_program_add_accumulator (p, 2, "a1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_ds (p, "absw", ORC_VAR_T1, ORC_VAR_S1);
      orc_program_append_ds (p, "accw", ORC_VAR_A1, ORC_VAR_T1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_avg2_8xn_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_8xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m){
  int i;
  int j;
  int n = 8;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_avg2_8xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_avg2_8xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_8xn_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_8xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
}
#endif


/* orc_avg2_12xn_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_12xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m){
  int i;
  int j;
  int n = 12;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_avg2_12xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 12;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_avg2_12xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_12xn_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_12xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 12;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
}
#endif


/* orc_avg2_16xn_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_16xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m){
  int i;
  int j;
  int n = 16;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_avg2_16xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_avg2_16xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_16xn_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_16xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 16;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
}
#endif


/* orc_avg2_32xn_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_32xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m){
  int i;
  int j;
  int n = 32;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_avg2_32xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 32;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_avg2_32xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 32);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_32xn_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_32xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 32;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
}
#endif


/* orc_avg2_nxm_u8 */
#ifdef DISABLE_ORC
void
orc_avg2_nxm_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int n, int m){
  int i;
  int j;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_avg2_nxm_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_avg2_nxm_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_avg2_nxm_u8");
      orc_program_set_backup_function (p, _backup_orc_avg2_nxm_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
}
#endif


/* orc_combine4_8xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_8xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 8;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine4_8xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine4_8xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_8xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_8xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_combine4_12xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_12xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 12;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine4_12xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 12;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine4_12xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_12xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_12xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 12;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_combine4_16xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_16xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 16;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine4_16xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine4_16xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_16xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_16xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 16;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_combine4_24xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_24xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 24;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine4_24xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 24;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine4_24xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 24);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_24xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_24xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 24;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_combine4_32xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_32xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 32;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine4_32xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 32;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine4_32xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 32);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_32xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_32xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 32;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_combine4_nxm_u8 */
#ifdef DISABLE_ORC
void
orc_combine4_nxm_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int n, int m){
  int i;
  int j;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var17 = 4;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;
  int16_t var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);
    ptr7 = ORC_PTR_OFFSET(s4, s4_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: shrsw */
      var44 = var43 >> var17;
      /* 13: convsuswb */
      var0 = ORC_CLAMP_UB(var44);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine4_nxm_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var17 = 4;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;
  int16_t var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: shrsw */
      var44 = var43 >> var17;
      /* 13: convsuswb */
      var0 = ORC_CLAMP_UB(var44);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine4_nxm_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, const uint8_t * s3, int s3_stride, const uint8_t * s4, int s4_stride, int p1, int p2, int p3, int p4, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine4_nxm_u8");
      orc_program_set_backup_function (p, _backup_orc_combine4_nxm_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
      orc_program_add_constant (p, 2, 4, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
      orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
      orc_program_append (p, "shrsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_S4] = s4_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_combine2_8xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine2_8xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 8;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine2_8xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine2_8xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine2_8xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine2_8xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_combine2_12xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine2_12xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 12;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine2_12xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 12;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine2_12xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine2_12xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine2_12xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 12;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_combine2_16xn_u8 */
#ifdef DISABLE_ORC
void
orc_combine2_16xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int p1, int p2, int p3, int p4, int m){
  int i;
  int j;
  int n = 16;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine2_16xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine2_16xn_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int p1, int p2, int p3, int p4, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine2_16xn_u8");
      orc_program_set_backup_function (p, _backup_orc_combine2_16xn_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 16;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_combine2_nxm_u8 */
#ifdef DISABLE_ORC
void
orc_combine2_nxm_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int p1, int p2, int p3, int p4, int n, int m){
  int i;
  int j;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = p1;
  const int16_t var25 = p2;
  const int16_t var26 = p3;
  const int16_t var27 = p4;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

#else
static void
_backup_orc_combine2_nxm_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

void
orc_combine2_nxm_u8 (uint8_t * d1, int d1_stride, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int p1, int p2, int p3, int p4, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_combine2_nxm_u8");
      orc_program_set_backup_function (p, _backup_orc_combine2_nxm_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
      orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
      orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
      orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
      orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  orc_executor_run (ex);
}
#endif


/* orc_sad_nxm_u8 */
#ifdef DISABLE_ORC
void
orc_sad_nxm_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int n, int m){
  int i;
  int j;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  *a1 = var12;

}

#else
static void
_backup_orc_sad_nxm_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}

void
orc_sad_nxm_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_sad_nxm_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_nxm_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sad_8x8_u8 */
#ifdef DISABLE_ORC
void
orc_sad_8x8_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride){
  int i;
  int j;
  int n = 8;
  int m = 8;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  *a1 = var12;

}

#else
static void
_backup_orc_sad_8x8_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = 8;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}

void
orc_sad_8x8_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_constant_m (p, 8);
      orc_program_set_name (p, "orc_sad_8x8_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_8x8_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 8;
  ORC_EXECUTOR_M(ex) = 8;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sad_12x12_u8 */
#ifdef DISABLE_ORC
void
orc_sad_12x12_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride){
  int i;
  int j;
  int n = 12;
  int m = 12;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  *a1 = var12;

}

#else
static void
_backup_orc_sad_12x12_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 12;
  int m = 12;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}

void
orc_sad_12x12_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
      orc_program_set_constant_m (p, 12);
      orc_program_set_name (p, "orc_sad_12x12_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_12x12_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 12;
  ORC_EXECUTOR_M(ex) = 12;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sad_16xn_u8 */
#ifdef DISABLE_ORC
void
orc_sad_16xn_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m){
  int i;
  int j;
  int n = 16;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  *a1 = var12;

}

#else
static void
_backup_orc_sad_16xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}

void
orc_sad_16xn_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_sad_16xn_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_16xn_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 16;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* orc_sad_32xn_u8 */
#ifdef DISABLE_ORC
void
orc_sad_32xn_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m){
  int i;
  int j;
  int n = 32;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  *a1 = var12;

}

#else
static void
_backup_orc_sad_32xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 32;
  int m = ex->params[ORC_VAR_A1];
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}

void
orc_sad_32xn_u8 (uint32_t * a1, const uint8_t * s1, int s1_stride, const uint8_t * s2, int s2_stride, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcProgram *p = 0;

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcCompileResult result;

      p = orc_program_new ();
      orc_program_set_constant_n (p, 32);
      orc_program_set_2d (p);
      orc_program_set_name (p, "orc_sad_32xn_u8");
      orc_program_set_backup_function (p, _backup_orc_sad_32xn_u8);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

      result = orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = 32;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  orc_executor_run (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif

