/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.ParentNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AttrImpl
extends ParentNode
implements Attr {
    static final long serialVersionUID = 7277707688218972102L;
    protected String name;

    protected AttrImpl() {
    }

    protected AttrImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl);
        this.name = string;
        this.isSpecified(true);
    }

    public Node cloneNode(boolean bl) {
        AttrImpl attrImpl = (AttrImpl)super.cloneNode(bl);
        attrImpl.isSpecified(true);
        return attrImpl;
    }

    public Element getElement() {
        return (Element)((Object)(this.isOwned() ? this.ownerNode : null));
    }

    public String getName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public Element getOwnerElement() {
        return (Element)((Object)(this.isOwned() ? this.ownerNode : null));
    }

    public boolean getSpecified() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.isSpecified();
    }

    public String getValue() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.firstChild == null) {
            return "";
        }
        ChildNode childNode = this.firstChild.nextSibling;
        if (childNode == null) {
            return this.firstChild.getNodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer(this.firstChild.getNodeValue());
        while (childNode != null) {
            stringBuffer.append(childNode.getNodeValue());
            childNode = childNode.nextSibling;
        }
        return stringBuffer.toString();
    }

    public void normalize() {
        Node node = this.firstChild;
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 3) {
                if (node2 != null && node2.getNodeType() == 3) {
                    ((Text)node).appendData(node2.getNodeValue());
                    this.removeChild(node2);
                    node2 = node;
                } else if (node.getNodeValue().length() == 0) {
                    this.removeChild(node);
                }
            }
            node = node2;
        }
    }

    public void setNodeValue(String string) throws DOMException {
        this.setValue(string);
    }

    public void setSpecified(boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isSpecified(bl);
    }

    public void setValue(String string) {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        LCount lCount = null;
        String string2 = "";
        if (this.ownerDocument.mutationEvents) {
            lCount = LCount.lookup("DOMAttrModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0 && this.ownerNode != null) {
                string2 = this.getValue();
            }
        }
        if (this.ownerDocument.mutationEvents) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            while (this.firstChild != null) {
                this.internalRemoveChild(this.firstChild, 1);
            }
        } else {
            if (this.firstChild != null) {
                this.firstChild.previousSibling = null;
                this.firstChild.isFirstChild(false);
                this.firstChild = null;
            }
            this.needsSyncChildren(false);
        }
        this.isSpecified(true);
        if (string != null) {
            this.internalInsertBefore(this.ownerDocument.createTextNode(string), null, 1);
        }
        this.changed();
        if (this.ownerDocument.mutationEvents) {
            this.dispatchAggregateEvents(this, string2, (short)1);
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + "\"" + this.getValue() + "\"";
    }
}

