# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"
require "tempfile"

require "rast_test"

module Rast
  class PipeBucketTest < Test::Unit::TestCase
    def test_s_new
      pout, pin = *IO.pipe
      assert_instance_of(PipeBucket, PipeBucket.new(pout))

      assert_raise(TypeError) do
        PipeBucket.new(Object.new)
      end
    end

    def test_file_p
      pout, pin = *IO.pipe
      bucket = PipeBucket.new(pout)
      assert_equal(false, bucket.eos?)
      assert_equal(false, bucket.file?)
      assert_equal(true, bucket.pipe?)
      assert_equal(false, bucket.transient?)
    end

    def test_read
      pout, pin = *IO.pipe
      bucket = PipeBucket.new(pout)
      pin.write("ŷʤ")
      pin.close
      assert_equal("ŷʤ", bucket.read)

      pout, pin = *IO.pipe
      pin.write("ŷʤ")
      pin.close
      bucket = PipeBucket.new(pout)
      assert_equal("ŷʤ", bucket.read)
    end
  end
end
