# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "zip/zip"
require File.join(File.dirname(__FILE__), "read-buckets-to-file")

class ApplicationZip
  SUPPORTED_VERSION = 1
  MIME_TYPE = "application/x-zip"

  include ReadBucketsToFile

  private

  def process_file(filter, mime_type, path)
    Zip::ZipInputStream.open(path) do |zis|
      while entry = zis.get_next_entry
        s = zis.read
        next_brigade = Rast::Brigade.new
        next_brigade.insert_tail(Rast::TransientBucket.new(s))
        next_brigade.insert_tail(Rast::EOSBucket.new)
        filter.pass(next_brigade, nil, entry.name)
      end
    end
  end
end
