# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

module ReadBucketsToBuffer
  def initialize
    @buffer = ""
  end

  def invoke(filter, brigade, mime_type)
    brigade.each do |bucket|
      if bucket.eos?
        process_buffer(filter, mime_type)
        @buffer.replace("")
      end
      @buffer.concat(bucket.read)
    end
  end

  def process_buffer(filter, mime_type)
    raise NotImplementedError, "sub class must implement this method"
  end
end
