/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#ifndef RAST_TEXT_INDEX_H
#define RAST_TEXT_INDEX_H

#include <apr.h>
#include <apr_errno.h>
#include <apr_pools.h>
#include <apr_hash.h>
#include <apr_file_io.h>

#include <db.h>

#include "rast/rast.h"
#include "rast/error.h"
#include "rast/encoding.h"
#include "rast/result.h"

typedef struct rast_text_indexer_t rast_text_indexer_t;
typedef struct rast_text_index_t rast_text_index_t;

rast_error_t *rast_text_indexer_add(rast_text_indexer_t *indexer,
                                    const char *s, int len,
                                    rast_size_t *registered_chars);
rast_error_t *rast_text_indexer_commit(rast_text_indexer_t *indexer);

rast_error_t *rast_text_index_open(rast_text_index_t **index,
                                   const char *filename, int flags,
                                   rast_encoding_module_t *encoding_module,
                                   DB_ENV *db_env, int lorder,
                                   rast_size_t pos_block_size,
                                   apr_pool_t *pool);
rast_error_t *rast_text_index_close(rast_text_index_t *index);
rast_error_t *rast_text_index_register(rast_text_index_t *index,
                                       rast_doc_id_t doc_id,
                                       rast_text_indexer_t **indexer,
                                       apr_pool_t *pool);
rast_error_t *rast_text_index_sync(rast_text_index_t *index);
rast_error_t *rast_text_index_search(rast_text_index_t *index,
                                     const char *term,
                                     int need_term_frequency,
                                     rast_query_result_t **result,
                                     apr_pool_t *pool);
rast_error_t *rast_text_index_optimize(DB_ENV *bdb_env, DB_TXN *bdb_txn,
                                       int lorder,
                                       rast_text_index_t *old_index,
                                       const char *new_index_name,
                                       apr_hash_t *id_map_table);

#endif

/* vim: set filetype=c sw=4 expandtab : */
