/****************************************************************************
    QtNlist   Netlist & Partslist utility for Qt-BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/
#ifndef XBSCHDOC_H
#define XBSCHDOC_H


#include <list>
using namespace std;

#include "xbschobj.h"
#include "ce3io.h"

//typedef list<string> stringList;
//typedef list<string>::iterator stringListIterator;

typedef list<SXBSchObj*> XBSchObjList;
typedef list<SXBSchObj*>::iterator XBSchObjListIterator;


class SXBSchSheetInfo;
class SXBSchWire;



class SXBSchDoc
{
public:
	SXBSchDoc();
	virtual ~SXBSchDoc();


protected:
	bool m_bDirty;		//ɥȤФѹȯȤtrueˤʤ롣
	SSize m_sizeSheet;	//ȤΥ¸
	int m_nOpCount;				//ֹ
	int m_nOldestOpCount;		//äȤŤֹ
	SRect m_rcTempArea;			//	
	SRect m_rcRotateRect;		//žȿž濴֤뤿Υꥢ
	SPoint m_ptTempSnapPoint;	//֥Ȥ򥹥ʥåפϤåɤ˾褦ˤ
	bool m_bSelectForDrag;
	unsigned m_visibleLayer;
	int m_editLayer;



protected:
	//β bDel  true ΤȤϡԤ
	//public  resetSelect()  del() ƤФ롣
	//ɥȤѹäȤtrue֤
	bool resetSelect_1(bool bDel=false);

	void pickupJunction(const SRect& rc);//٤Ƥܹ m_listWorkJunc Ф롣
	void selectForDragJunction(int scanMax,const SRect& rc);	//ϰܹ򡣤٤Ƥܹm_listWorkJunc Ф롣
	int divideWire(SXBSchWire* swire,const SRect& rc,SXBSchWire** dwire);
	void selectForDragWire(int scanMax,const SRect& rc);		//ɥåΤΥ磻䡼
	void selectForDragExceptJuncWire(int scanMax,const SRect& rc);//ɥåΤܹ磻䡼ʳ
	
	

public:  //ȥ꡼I/OϢ
	bool writeMinimumLb3(SWriteCE3& wce3,XBSchObjList* pList,bool bOwnOnly);
	bool writeCe3(SWriteCE3& wce3,XBSchObjList* pList,bool bAllObj,const SPoint* pptOrigin);
	bool readCe3(SReadCE3& rce3,XBSchObjList* pList,const SPoint* pptOrigin,SXBSchSheetInfo* pSheetInfo);



public:
	XBSchObjList m_listMain;
	XBSchObjList m_listTemp;
protected:
	XBSchObjList m_listWorkJunc;	//ѤΥꥢ ɥåǻ
	XBSchObjList m_listWorkWire;	//ѤΥꥢ ɥåǻ


public:
	bool isDirty(){return m_bDirty;}	//Ǹ¸ΤȤѹäɤ֤
	bool isEmpty();	//̥֥ȤĤǤ⤢false֤
	void SetSheetSize(const SSize& size);
	SSize SheetSize(){return m_sizeSheet;}



public:
	//Ǥɲ ֹ֤
	int add(SXBSchObj* pObj);
	//֤ɲÿǤɲ ֹ֤
	int addSelect(SXBSchObj* pObj);
	//ꤷƤ
	int select(const SPoint& pt);
	//ϰϤꤷƤ
	int select(const SRect& rc);
	int selectForDrag(const SRect& rc);



	//m_rcTempArea  m_ptTempSnapPoint ֥ȤΥꥹȤꤹ롣
	void setupRcTempArea();
	void setupRotateRect();

	
	
	//β
	//ɥȤѹäȤtrue֤
	bool resetSelect();
	//֥ȤϰϤ
	SRect tempArea(){return m_rcTempArea;}
	//֥ȤΥʥåץݥȤ
	SPoint tempSnapPoint(){return m_ptTempSnapPoint;}
	//
	void init();
	//ե뤫ɤ߹
	int readFile(const char* fname);
	int readFile(FILE* fp);
	//եؤν񤭹
	int writeFile(const char* fname);
	int writeFile(FILE* fp);




	//***** Խ *****

	//ԡ
	//ԡԤ줿Ȥtrue֤
	virtual bool copy(){return false;}
	//Žդ
	//ɥȤѹäȤtrue֤
	virtual bool paste(const SPoint&){return false;}
	//Žդǽ
	virtual bool canPaste(){return false;}

	//
	//ɥȤѹäȤtrue֤
	bool del();

	//ڤ
	//ɥȤѹäȤtrue֤
	bool cut();


	//Undo
	//ɥȤѹäȤtrue֤
	bool undo();

	//ԡǽ
	bool canCopy();
	//ǽ
	bool canDel();
	//ڤǽ
	bool canCut();
	//Undoǽ
	bool canUndo();

	//Attributeѹǽ?
	bool canAttribute();

	//Rotate
	//ɥȤѹäȤtrue֤
	bool rotate();
	//Mirror
	//ɥȤѹäȤtrue֤
	bool mirror();

	//Rotateǽ
	bool canRotate();
	//Mirrorǽ
	bool canMirror();
	

	//쥤䡼ΰư
	bool moveToLayer(int nLayer);


	//ֹ֤
	int opCount(){return m_nOpCount;}
	//Ťǡκ
	void delOldData(int nOpCount);
	//ꤷɸǡξ夫ɤ
	int isOnTempData(const SPoint& pt);
	//ǡư
	void moveTempData(int offsetx,int offsety);
};

#endif  //#ifndef XBSCHDOC_H
