/****************************************************************************
    QtNlist   Netlist & Partslist utility for Qt-BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/
/****************************************************************************
** XBSchǥ٥륯饹
****************************************************************************/
#ifndef XBSCHCOMMENT_H
#define XBSCHCOMMENT_H

#include "xbsch.h"
#include "xbschobj.h"

class SXBSchComment:public SXBSchObj
{
public:
	//󥹥ȥ饯
	SXBSchComment();
	//ǥȥ饯
	virtual ~SXBSchComment(){};

	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

    //IDμ
	unsigned id(){return ID_COMMENT;}
protected:
	string	m_strText;
	bool	m_drawSizeIsValid;
	int		m_drawAreaVOffset;
	SSize	m_drawSize;
	string	m_fontName;
	int		m_fontSize;
	bool	m_fontBold;
	bool	m_fontItalic;
	bool	m_fontUnderline;
	bool	m_fontStrikeOut;


public:
	//ʣԤ
	SXBSchObj* duplicate();
	//ɸ  m_p2ؤ̵ˤƤ
	void setX2(int){}
	void setY2(int){}
	void setP2(const SPoint&){}
	//ȿžԤ
	void mirrorH(){}	//⤷ʤ
	//žԤ
	void rotate(){};
	//ꤷ٤֤
	int qSelectWeight(const SPoint& p);
	//ϰϤꤷԤ
	unsigned testSelection(const SRect& rc);
	//ϰϤ򤷤ƥɥåԤ
	unsigned testSelectionForDrag(const SRect& rc);
	//褬ɬפɤ֤
	bool qRedraw(const SRect& rc);
	//ͭϰϤ֤
	SRect area();
	SRect rotateRect();


public:
	//ͭʥ֥Ȥʤtrue֤
	bool qValid(){return (m_strText.length()>0);}
	void setText(const char* psz);
	const char* text(){return m_strText.c_str();}
	//ȥӥ塼Ȥѹǽʾtrue֤
	bool canAttribute(){return true;}
	bool drawSizeIsValid(){return m_drawSizeIsValid;}
	void setDrawSize(int vOffset,const SSize& size);	//襵ꡣꡢvOffset夫Υ
	void setFontName(const char* psz);	//ե̾		
	const char* fontName()const {return m_fontName.c_str();}	//ե̾μ
	void setFontSize(int fontSize);	//եȥ
	int	fontSize()const{return m_fontSize;}//եȥμ
	void setFontBold(bool istrue);	//ܡ
	bool fontBold()const{return m_fontBold;} //ܡ
	void setFontItalic(bool istrue);//å
	bool fontItalic()const{return m_fontItalic;}//å
	void setFontUnderline(bool istrue);//饤
	bool fontUnderline()const{return m_fontUnderline;}//饤
	void setFontStrikeOut(bool istrue);//ä
	bool fontStrikeOut()const{return m_fontStrikeOut;}//ä
	
};

#endif
