/****************************************************************************
    Qt-LCoV Library Editor for Qt-BSch3V
    Copyright (C) 2002-2006 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "application.h"

#include <QtGui>

#include <qimage.h>
#include <qpixmap.h>
#include <q3toolbar.h>
#include <qtoolbutton.h>
#include <q3listbox.h>
//#include <qbutton.h>
#include <q3popupmenu.h>
#include <qmenubar.h>
#include <q3textedit.h>
#include <qfile.h>
//#include <q3filedialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
//#include <qprinter.h>
#include <qapplication.h>
#include <q3accel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <q3paintdevicemetrics.h>
//#include <qwhatsthis.h>
#include <q3simplerichtext.h>
#include <qlayout.h>
#include <qclipboard.h>
#include <qfontdialog.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
//Added by qt3to4:
#include <QGridLayout>
#include <QCloseEvent>
#include <QKeyEvent>
#include <QAction>

#include "componentview.h"
#include "lcolistboxitem.h"
#include "ce3io.h"
#include "xbschfont.h"
#include "cfgdata.h"
//#include "prop_comp.h"
#include "propcomponentdlg.h"
#include "add_alias.h"

//#include "filesave.xpm"
//#include "fileopen.xpm"
//#include "fileprint.xpm"
#include "lcoicon.xpm"
#include "tool_select.xpm"
#include "tool_pin.xpm"
#include "tool_line.xpm"
#include "tool_ellipse.xpm"
#include "tool_polygon.xpm"
#include "tool_arc.xpm"
#include "tool_handle.xpm"
#include "tool_text.xpm"
#include "up_image.xpm"
#include "down_image.xpm"


//Static Сѿ
QWidgetList ApplicationWindow::m_appWindowList;

ApplicationWindow::ApplicationWindow()
    : Q3MainWindow( 0, "example application main window", Qt::WDestructiveClose | Qt::WGroupLeader )
{
//printer = new QPrinter( QPrinter::HighResolution );
//	QPixmap openIcon, saveIcon, printIcon;
	QPixmap toolSelectIcon, toolPinIcon, toolLineIcon,
			toolEllipseIcon, toolPolygonIcon, toolArcIcon, toolHandleIcon,toolTextIcon,
			upIcon, downIcon;

	setIcon(QPixmap((const char**)lcoicon ));
	Q3ToolBar * pToolBar = new Q3ToolBar( this, "main toolbar" );
//    pToolBar->setLabel( "File Operations" );

//    openIcon = QPixmap( fileopen );
//   QToolButton * fileOpen
//	= new QToolButton( openIcon, "Open File", QString::null,
//			   this, SLOT(choose()), fileTools, "open file" );
//
//    saveIcon = QPixmap( filesave );
//    QToolButton * fileSave
//	= new QToolButton( saveIcon, "Save File", QString::null,
//			   this, SLOT(save()), fileTools, "save file" );
//
//    printIcon = QPixmap( fileprint );
//    QToolButton * filePrint
//	= new QToolButton( printIcon, "Print File", QString::null,
//			   this, SLOT(print()), fileTools, "print file" );

	
	toolSelectIcon=QPixmap( tool_select );
	toolPinIcon=QPixmap( tool_pin );
	toolLineIcon=QPixmap( tool_line );
	toolEllipseIcon=QPixmap( tool_ellipse );
	toolPolygonIcon=QPixmap( tool_polygon );
	toolArcIcon=QPixmap( tool_arc );
	toolTextIcon=QPixmap( tool_text );
	toolHandleIcon=QPixmap( tool_handle );
	upIcon=QPixmap( up_image );
	downIcon=QPixmap( down_image );
	
	m_ptbToolSelect	=new QToolButton( toolSelectIcon, "Select", QString::null,
			  		 this, SLOT(toolSelect()), pToolBar, "Select" );
	m_ptbToolSelect->setToggleButton (true);
	pToolBar->addSeparator();
			
	m_ptbToolPin		=new QToolButton( toolPinIcon, "Pin", QString::null,
			  		 this, SLOT(toolPin()), pToolBar, "Pin" );
	m_ptbToolPin->setToggleButton (true);
	pToolBar->addSeparator();
			
	m_ptbToolLine	=new QToolButton( toolLineIcon, "Line", QString::null,
			  		 this, SLOT(toolLine()), pToolBar, "Line" );
	m_ptbToolLine->setToggleButton (true);
	
	m_ptbToolEllipse	=new QToolButton( toolEllipseIcon, "Ellipse", QString::null,
			  		 this, SLOT(toolEllipse()), pToolBar, "Ellipse" );
	m_ptbToolEllipse->setToggleButton (true);
			
	m_ptbToolPolygon=new QToolButton( toolPolygonIcon, "Polygon", QString::null,
			  		 this, SLOT(toolPolygon()), pToolBar, "Polygon" );
	m_ptbToolPolygon->setToggleButton (true);
			
	m_ptbToolArc	=new QToolButton( toolArcIcon, "Arc", QString::null,
			  		 this, SLOT(toolArc()), pToolBar, "Arc" );
	m_ptbToolArc->setToggleButton (true);

	m_ptbToolText	=new QToolButton( toolTextIcon, "Text", QString::null,
			  		 this, SLOT(toolText()), pToolBar, "Text" );
	m_ptbToolText->setToggleButton (true);
	
	pToolBar->addSeparator();
			
	m_ptbToolHandle	=new QToolButton( toolHandleIcon, "MoveHandle", QString::null,
			  		 this, SLOT(toolHandle()), pToolBar, "MoveHandle" );
	m_ptbToolHandle->setToggleButton (true);
	
//	setDockEnabled(Qt::Top,true);
//	setDockEnabled(Qt::Left,true);
//	setDockEnabled(Qt::Right,true);
//	setDockEnabled(Qt::Bottom,true);
	setDockWindowsMovable ( false);
	
//    (void)QWhatsThis::whatsThisButton( fileTools );
//
//    const char * fileOpenText = "<p><img source=\"fileopen\"> "
//	         "Click this button to open a <em>new file</em>.<br>"
//                 "You can also select the <b>Open</b> command "
//                 "from the <b>File</b> menu.</p>";
//
//    QWhatsThis::add( fileOpen, fileOpenText );

//    QMimeSourceFactory::defaultFactory()->setPixmap( "fileopen", openIcon );
//
//    const char * fileSaveText = "<p>Click this button to save the file you "
//                 "are editing. You will be prompted for a file name.\n"
//                 "You can also select the <b>Save</b> command "
//                 "from the <b>File</b> menu.</p>";
//
//    QWhatsThis::add( fileSave, fileSaveText );
//
//    const char * filePrintText = "Click this button to print the file you "
//                 "are editing.\n"
//		 "You can also select the Print command "
//		 "from the File menu.";
//
//    QWhatsThis::add( filePrint, filePrintText );

//	fontMenuBar = new QFont("MS UI Gothic");
//	menuBar()->setFont(*fontMenuBar);

	//FILE˥塼
	QMenu * file = new QMenu("&File", this );
    menuBar()->addMenu(file);
//	Q3PopupMenu * file = new Q3PopupMenu( this );
//	menuBar()->insertItem( "&File", file );
	file->addAction( "&New", this, SLOT(newDoc()), Qt::CTRL+Qt::Key_N );
	file->addAction("&Open...",this, SLOT(choose()), Qt::CTRL+Qt::Key_O );
	file->addAction("&Save",this, SLOT(save()), Qt::CTRL+Qt::Key_S );
	file->addAction( "Save &As...", this, SLOT(saveAs()) );
	file->addSeparator();
	file->addAction( "&Close", this, SLOT(close()), Qt::CTRL+Qt::Key_W );
	file->addAction( "&Quit", qApp, SLOT( closeAllWindows() ), Qt::CTRL+Qt::Key_Q );
	
	//EDIT˥塼
	QMenu * edit = new QMenu("&Edit", this );
    menuBar()->addMenu(edit);
//	Q3PopupMenu * edit = new Q3PopupMenu( this );
//	menuBar()->insertItem( "&Edit", edit );
	edit->addAction( "&Undo", this, SLOT(editUndo()), Qt::CTRL+Qt::Key_Z );
	edit->addAction( "Cu&t", this, SLOT(editCut()), Qt::CTRL+Qt::Key_X );
	edit->addAction( "&Copy", this, SLOT(editCopy()), Qt::CTRL+Qt::Key_C );
	edit->addAction( "&Paste", this, SLOT(editPaste()), Qt::CTRL+Qt::Key_V );
	edit->addAction( "&Delete", this, SLOT(editDelete()), Qt::Key_Delete );
	edit->addAction( "&Mirror", this, SLOT(editMirror()), Qt::CTRL+Qt::Key_M );
	edit->addAction( "&Rotate", this, SLOT(editRotate()), Qt::CTRL+Qt::Key_R );
	edit->addAction( "Property", this, SLOT(editProperty()));
	edit->addSeparator();
	edit->addAction( "Cut Component", this, SLOT(editCompCut()) );
	edit->addAction( "Copy Component", this, SLOT(editCompCopy()) );
	edit->addAction( "Paste Component", this, SLOT(editCompPaste()) );
	edit->addSeparator();
	edit->addAction( "New Component", this, SLOT(editCompNew()) );
	edit->addAction( "Component Property", this, SLOT(editCompProperty()) );
	edit->addSeparator();
	edit->addAction( "Add Alias", this, SLOT(editAddAlias()) );
	
	//VIEW˥塼
	QMenu * viewMenu = new QMenu("&View", this );
    menuBar()->addMenu(viewMenu);
//	Q3PopupMenu * viewMenu = new Q3PopupMenu( this );
//	menuBar()->insertItem( "&View", viewMenu );
	viewMenu->addAction( "Zoom &In", this, SLOT(viewZoomIn()), Qt::Key_PageUp);
	viewMenu->addAction( "Zoom &Out", this, SLOT(viewZoomOut()), Qt::Key_PageDown);
	
	//TOOL˥塼
	QMenu * toolMenu = new QMenu("&Tool", this );
    menuBar()->addMenu(toolMenu);
//	Q3PopupMenu * toolMenu = new Q3PopupMenu( this );
//	menuBar()->insertItem( "&Tool", toolMenu );
	m_menuActionToolSelect=toolMenu->addAction( "&Select", this, SLOT(toolSelect()));
	m_menuActionToolSelect->setCheckable(true);
	m_menuActionToolPin=toolMenu->addAction( "&Pin", this, SLOT(toolPin()));
	m_menuActionToolPin->setCheckable(true);
	m_menuActionToolLine=toolMenu->addAction( "&Line", this, SLOT(toolLine()));
	m_menuActionToolLine->setCheckable(true);
	m_menuActionToolEllipse=toolMenu->addAction( "&Ellipse", this, SLOT(toolEllipse()));
	m_menuActionToolEllipse->setCheckable(true);
	m_menuActionToolPolygon=toolMenu->addAction( "Poly&gon", this, SLOT(toolPolygon()));
	m_menuActionToolPolygon->setCheckable(true);
	m_menuActionToolArc=toolMenu->addAction( "&Arc", this, SLOT(toolArc()));
	m_menuActionToolArc->setCheckable(true);
	m_menuActionToolText=toolMenu->addAction( "&Text", this, SLOT(toolText()));
	m_menuActionToolText->setCheckable(true);
	toolMenu->addSeparator();
	m_menuActionToolHandle=toolMenu->addAction( "Move &Node", this, SLOT(toolHandle()));
	m_menuActionToolHandle->setCheckable(true);
	toolMenu->addSeparator();
	toolMenu->addAction( "Create Bit Pattern", this, SLOT(toolCreateBitPattern()));
	
	//SET˥塼
	QMenu * setMenu = new QMenu("&Set", this );
    menuBar()->addMenu(setMenu);
//	Q3PopupMenu * setMenu = new Q3PopupMenu( this );
//	menuBar()->insertItem( "&Set", setMenu );
	setMenu->addAction( "&Font...", this, SLOT(setFont()));
	

	//WINDOW˥塼
	m_menuWindow = new QMenu("&Window", this );
    menuBar()->addMenu(m_menuWindow);
//	m_menuWindow = new  Q3PopupMenu( this );
//	menuBar()->insertItem( "&Window", m_menuWindow);
	QObject::connect(m_menuWindow,SIGNAL(aboutToShow ()),
			this,SLOT(setupWindowMenu()));
	QObject::connect(m_menuWindow,SIGNAL(triggered ( QAction *)),
			this,SLOT(selectActiveDocument( QAction *)));		
//	QObject::connect(m_menuWindow,SIGNAL(activated (int)),
//			this,SLOT(selectActiveDocument(int)));
	
	
    menuBar()->addSeparator();

	QMenu *help = new QMenu("&Help", this );
    menuBar()->addMenu(help);
//    Q3PopupMenu * help = new Q3PopupMenu( this );
//    menuBar()->insertItem( "&Help", help );

    help->addAction( "&About", this, SLOT(about()), Qt::Key_F1 );
    help->addAction( "About &Qt", this, SLOT(aboutQt()) );
//    help->insertSeparator();
//    help->insertItem( "What's &This", this, SLOT(whatsThis()), SHIFT+Key_F1 );

	
	m_mainWidget=new QWidget(this,"mainWidget");
	setCentralWidget( m_mainWidget  );
	m_gridLayout= new QGridLayout( m_mainWidget ,2,3);
	
	
	
	m_gridLayout->setSpacing( 4 );
 	m_gridLayout->setMargin( 3 );

   	m_buttonUp = new QToolButton( m_mainWidget, "button_up" );
	m_buttonUp->setPixmap( upIcon );
	m_gridLayout->addWidget(m_buttonUp, 0, 0);
	m_buttonUp->setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Minimum);

	m_buttonDown = new QToolButton( m_mainWidget, "button_down" );
	m_buttonDown->setPixmap(downIcon );
	m_gridLayout->addWidget(m_buttonDown, 0, 1);
	m_buttonDown->setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Minimum);
  
	m_componentListBox = new Q3ListBox(  m_mainWidget, "ListBox1" );
	m_componentListBox->setMinimumSize(QSize(180, 300 ) );
	m_componentListBox->setVScrollBarMode(Q3ScrollView::AlwaysOn);
	m_gridLayout->addMultiCellWidget ( m_componentListBox, 1, 1, 0, 1);
	m_componentView = new SComponentView(m_mainWidget);
	m_gridLayout->addMultiCellWidget(m_componentView,0,1,2,2);
	
	
	// signals and slots connections
	connect(m_componentListBox , SIGNAL( selectionChanged () ),this,SLOT( listboxSelectionChanged()	));
	connect(m_buttonUp , SIGNAL( clicked () ),this,SLOT( onButtonUp() ));
	connect(m_buttonDown , SIGNAL( clicked () ),this,SLOT( onButtonDown() ));

	resize(600 , 400 );
	setCaption("Qt-LCoV");
	setToolButtonState();
	m_appWindowList.append(this);
}


ApplicationWindow::~ApplicationWindow()
{
	int windowCount=m_appWindowList.count();
	int n;
	for(n=0;n<windowCount;n++){
		QWidget * w = m_appWindowList.at(n);
		if(w==this){
			m_appWindowList.remove(w);
			break;
		}
    }
	
    //delete printer;
}

QString ApplicationWindow::fileName()
{
	return m_filename;
}

void ApplicationWindow::newDoc()
{
    ApplicationWindow *ed = new ApplicationWindow;
    ed->setCaption("Qt-LCoV");
    ed->show();
}

void ApplicationWindow::choose()
{
	QString fn = QFileDialog::getOpenFileName( this,QString::null,QString::null,"*.lb3");
 	//QString fn = Q3FileDialog::getOpenFileName( QString::null, "*.lb3",
	//				       this);
	if ( !fn.isEmpty() ){
		if(m_LCoVDoc.m_CompLib.count()>0){
			ApplicationWindow *ed = new ApplicationWindow;
			ed->setCaption("Qt-LCoV");
			ed->show();
			ed->load( fn );
		}else{
			load( fn );
		}
	}
//    else
//	statusBar()->message( "Loading aborted", 2000 );
}

void ApplicationWindow::keyPressEvent ( QKeyEvent * e )
{
	switch(e->key()){
	case Qt::Key_Escape :
		if(!m_componentView->onKeyEscape())
			toolSelect();
		break;
	case Qt::Key_S :
		toolSelect();
		break;
	case Qt::Key_P :
		toolPin();
		break;
	case Qt::Key_L :
		toolLine();
		break;
	case Qt::Key_E :
		toolEllipse();
		break;
	case Qt::Key_G :
		toolPolygon();
		break;
	case Qt::Key_A :
		toolArc();
		break;
	case Qt::Key_N :
		toolHandle();
		break;
	default:;
	}
}

//ưܥ󤬲줿ȤΥϥɥ
void  ApplicationWindow::onButtonUp()
{
	int nSelected = m_componentListBox->currentItem();
	if(nSelected < 1) return;
	SLCoListBoxItem* itemSelected = (SLCoListBoxItem*)m_componentListBox->item(nSelected);
	SLCoListBoxItem* listItem = new SLCoListBoxItem;
	listItem->m_pCompIndex = itemSelected->m_pCompIndex;
	m_componentListBox->insertItem(listItem,nSelected-1);
	m_componentListBox->setCurrentItem(nSelected-1);
	m_componentListBox->removeItem(nSelected+1);
	m_LCoVDoc.m_bDirty = true;
}

//ưܥ󤬲줿ȤΥϥɥ
void  ApplicationWindow::onButtonDown()
{
	int nSelected = m_componentListBox->currentItem();
	if(nSelected < 0) return;
	int nCount = m_componentListBox->count();
	if(nSelected > nCount -2) return;

	SLCoListBoxItem* itemSelected = (SLCoListBoxItem*)m_componentListBox->item(nSelected);
	SLCoListBoxItem* listItem = new SLCoListBoxItem;
	listItem->m_pCompIndex = itemSelected->m_pCompIndex;
	m_componentListBox->insertItem(listItem,nSelected+2);
	m_componentListBox->setCurrentItem(nSelected+2);
	m_componentListBox->removeItem(nSelected);
	m_LCoVDoc.m_bDirty = true;
}

//ץꥱΥץΥå
void ApplicationWindow::setAppCaption(const QString &fileName )
{
	QString title = "Qt-LCoV";
	if(!fileName.isEmpty()){
		title += " - ";
		title += fileName;
	}
	setCaption(title);
}

//ʥǥåꥹȥܥå˥å
void ApplicationWindow::setCompIndexToListBox()
{
	m_componentListBox->clear();
	SCompIndexListIterator iteIndex =m_LCoVDoc.m_CompLib.m_listCompIndex.begin();
	while(iteIndex != m_LCoVDoc.m_CompLib.m_listCompIndex.end()){
		SLCoListBoxItem* listItem = new SLCoListBoxItem;
		if(!listItem){
//qDebug(	"**** ERROR setCompIndexToListBox()*****");
			break;
		}
		listItem->m_pCompIndex = *iteIndex;
		m_componentListBox->insertItem(listItem);
		iteIndex++;
	}
}

//ꥹȥܥåѹ줿Ȥ˸ƤФ
void ApplicationWindow::listboxSelectionChanged()
{
//qDebug("listboxSelectionChanged()");
	int nSelected = m_componentListBox->currentItem();
	if(nSelected >= 0){
	
		if(m_componentView->m_pCompIndex!=NULL){
			m_componentView->releaseTemp();
			if(m_componentView->m_doc.m_dirtyFlag){
				m_componentView->saveCompInfo();
				m_componentView->m_doc.m_dirtyFlag=false;
				m_LCoVDoc.m_bDirty = true;
			}
		}
		
		//qDebug("lcoDialog::listboxSelectionChanged()  %d",nSelected);
		SLCoListBoxItem* itemSelected = (SLCoListBoxItem*)m_componentListBox->item(nSelected);
		int nCount = m_componentListBox->count();
		int n;
		for(n=0;n<nCount;n++){
			SLCoListBoxItem* listItem = (SLCoListBoxItem*)m_componentListBox->item(n);
			if(n == nSelected){
				listItem->m_bAlias = false;
			}else{
				listItem->m_bAlias = (listItem->m_pCompIndex->compInfo() == itemSelected->m_pCompIndex->compInfo());
			}
		}
		m_componentView->setCompIndex(itemSelected->m_pCompIndex);
	}else{
		m_componentView->setCompIndex(NULL);
	}	
	m_componentListBox->viewport()->update();
//	if(CompEdit->modified()) m_bDirty=true;
	toolSelect();
}


void ApplicationWindow::load( const QString &fileName )
{
	m_componentView->setCompIndex(NULL);
	m_componentListBox->clear();	//˥ꥹȥܥåˤƤʤȥơ󥨥顼ˤʤ롣
	m_LCoVDoc.m_CompLib.deleteContent();
	m_LCoVDoc.m_CompLib.readLibraryFile(fileName.local8Bit());
	m_LCoVDoc.m_bDirty = false;
	setAppCaption(fileName);
	m_filename=fileName;
	setCompIndexToListBox();
	
	int nCount = m_componentListBox->count();
	if(nCount>0){
		toolSelect();
		m_componentListBox->setCurrentItem(0);
		SLCoListBoxItem* itemSelected = (SLCoListBoxItem*)m_componentListBox->item(0);
		if(itemSelected){
			m_componentView->setCompIndex(itemSelected->m_pCompIndex);
		}
	}
		
}


void ApplicationWindow::save()
{
	if (m_filename.isEmpty() ) {
		saveAs();
		return;
	}
	doSave();
}


void ApplicationWindow::saveAs()
{
	QString fn = QFileDialog::getSaveFileName( this,QString::null,QString::null,"*.lb3");
//	QString fn = Q3FileDialog::getSaveFileName( QString::null, "*.lb3",
//					       this );

	if ( fn.isEmpty() ) return;
	QFileInfo finfo(fn);
	if(finfo.extension(false).isEmpty()){	//xxxx.פȡxxxxפξĥҤʤȽꤷƤޤ
		if(fn.right(1)!=".") fn+=".";		// Ǹʸ.פǤʤС.פɲá
		fn+="lb3";					// ĥҤɲá
	}
	if(QFile::exists (fn)){
		QString msg=fn;
		msg += " already exists.Overwrite?";
		switch( QMessageBox::information( this, "Save as",msg,
			      "Overwrite", "Cancel",QString::null,0, 1) ) {
			case 0:
				break;				
   			case 1:
			default:
				return;
   		}
	}
	
	m_filename = fn;
	setAppCaption(fn);
	doSave();
}

//ե¸μº
void ApplicationWindow::doSave()
{
	if(m_componentView->m_pCompIndex!=NULL){
		m_componentView->releaseTemp();
		if(m_componentView->m_doc.m_dirtyFlag){
			m_componentView->saveCompInfo();
			m_componentView->m_doc.m_dirtyFlag=false;
			m_LCoVDoc.m_bDirty = true;
		}
	}
	

	int nCount=m_componentListBox->count();
	int n,m;


	FILE* fp;
	if((fp = fopen(m_filename.local8Bit(),"w"))==NULL) return ;
	SWriteCE3 wce3;
	wce3.Attach(fp);
	wce3.WriteRecord("+BSCH3_LIB_V.1.0");
	wce3.WriteEOL();

	wce3.WriteRecordString("PROP",m_LCoVDoc.m_CompLib.m_prop_string);
	wce3.WriteEOL();

	for(n=0;n<nCount;n++){
		SLCoListBoxItem* listItem = (SLCoListBoxItem*)m_componentListBox->item(n);
		SCompIndex* pIndex = listItem->m_pCompIndex;
		if(!pIndex)continue;
		
		string name = pIndex->name();
		if(name.empty())continue;
		SCompInfo* pInfo = pIndex->compInfo();
		if(!pInfo)continue;
		bool bAlias = false;
		string aliasFor;
		for(m=0;m<n && m<nCount;m++){
			SLCoListBoxItem* listItem2 = (SLCoListBoxItem*)m_componentListBox->item(m);
			SCompIndex* pIndex2 = listItem2->m_pCompIndex;
			if(!pIndex2)continue;
			if(pIndex2->compInfo()==pInfo){
				aliasFor = pIndex2->name();	//񤭹ߺѤߤ̾
				if(aliasFor.empty())continue;
				bAlias = true;
				break;
			}
		}
		if(bAlias){
			SCompLib::WriteAlias(wce3,name.c_str(),aliasFor.c_str());
		}else{
			pInfo->writeCe3(wce3,name.c_str());
		}
	}
	wce3.WriteRecord("-BSCH3_LIB_V.1.0");
	wce3.WriteEOL();

	fclose(fp);
	m_LCoVDoc.m_bDirty = false;
	
//	m_wndView.m_doc.m_dirtyFlag = false;
	return ;
}


//EDIT-Undo  ϥɥ
void ApplicationWindow::editUndo()
{
		m_componentView->doUndo();
}

//EDIT-Cut  ϥɥ
void ApplicationWindow::editCut()
{
	m_componentView->doCopy();
	m_componentView->doDelete();
}

//EDIT-Copy  ϥɥ
void ApplicationWindow::editCopy()
{
	m_componentView->doCopy();
}

//EDIT-Paste  ϥɥ
void ApplicationWindow::editPaste()
{
	if(!m_componentView->canPaste()) return;
	toolSelect();
	m_componentView->doPaste();
	
}

//EDIT-Delete  ϥɥ
void ApplicationWindow::editDelete()
{
	m_componentView->doDelete();
}

//EDIT- Mirror ϥɥ
void ApplicationWindow::editMirror()
{
	m_componentView->doMirror();
}

//EDIT-Rotate  ϥɥ
void ApplicationWindow::editRotate()
{
	m_componentView->doRotate();
}

//EDIT-Property  ϥɥ
void ApplicationWindow::editProperty()
{
	m_componentView->editProperty();
}

void ApplicationWindow::editCompCut()
//EDIT-ComponentCut  ϥɥ
{
	doComponentCopy();
	doComponentDelete();
}

//EDIT-ComponentCopy  ϥɥ
void ApplicationWindow::editCompCopy()
{
	doComponentCopy();
}

//EDIT-ComponentPaste  ϥɥ
void ApplicationWindow::editCompPaste() 
{
	doComponentPaste();
}

//EDIT-ComponentNew  ϥɥ
void ApplicationWindow::editCompNew()
{
	prop_componentdlg* dlg=new prop_componentdlg(this);
//	prop_comp* dlg=new prop_comp(this,0,true);
//	// ʤΥǥե	
//	dlg->editName->setText("NAME");	
//	dlg->editRef->setText("U");
//	dlg->editWidth->setText("2");
//	dlg->editHeight->setText("2");
//	dlg->editBlock->setText("1");
//	dlg->checkUsePtn->setChecked(false);

	if(dlg->exec()){
		// ʾ󥯥饹
		SCompInfo* pComp = new SCompInfo;

		SSize sizeComp=SSize(dlg->width(),dlg->height());
		bool usePtn = dlg->usePattern();
		bool noBitPtn = !(dlg->useBitPattern());
		pComp->setSize(sizeComp,usePtn,noBitPtn);
		pComp->setUsePattern(usePtn,noBitPtn);
		pComp->setRef(dlg->ref().latin1());
		pComp->setBlock(dlg->block());
		string name = dlg->name().latin1();

//		SSize sizeComp=SSize(	dlg->editWidth->text().toInt(),
//							 	dlg->editHeight->text().toInt());
//		bool usePtn = dlg->checkUsePtn->isChecked();
//		pComp->setSize(sizeComp,usePtn);
//		pComp->setUsePattern(usePtn);
//		pComp->setRef(dlg->editRef->text().latin1());
//		pComp->setBlock(dlg->editBlock->text().toInt());
//		string name = dlg->editName->text().latin1();

		
		string uniqname = m_LCoVDoc.m_CompLib.uniqueName(name);
		
		// ʥǥå饹
		SCompIndex* pIndex = new SCompIndex;
		pIndex->setName(uniqname.c_str());
		pIndex->setCompInfo(pComp);
		
		// ɥȥ饹ˡʾȡǥåɲ
		m_LCoVDoc.m_CompLib.m_listCompIndex.push_back(pIndex);
		m_LCoVDoc.m_CompLib.m_listCompInfo.push_back(pComp);
		
		// ԽɥԽä			
		if(m_componentView->m_pCompIndex!=NULL){
			m_componentView->releaseTemp();	// ǡβ
			if(m_componentView->m_doc.m_dirtyFlag){ 	// Ѥä
				m_componentView->saveCompInfo();	// ʾݴ
				m_componentView->m_doc.m_dirtyFlag=false;
				m_LCoVDoc.m_bDirty = true;
			}
		}
		
		int nSelected = m_componentListBox->currentItem();

		SLCoListBoxItem* listItem = new SLCoListBoxItem;
		listItem->m_pCompIndex = pIndex;
		m_componentListBox->insertItem(listItem,nSelected);
		m_componentListBox->setCurrentItem((nSelected<0 ? 0 : nSelected));
		m_componentView->setCompIndex(pIndex);
		m_componentView->setDirty();
		toolPin();
		m_LCoVDoc.m_bDirty = true;
	}

	delete dlg;	
}

//EDIT-ComponentProperty  ϥɥ
void ApplicationWindow::editCompProperty()
{
	int nSelected = m_componentListBox->currentItem();
	if(nSelected < 0) return;
	
	if(m_componentView->m_pCompIndex!=NULL){
		m_componentView->releaseTemp();
			if(m_componentView->m_doc.m_dirtyFlag){
			m_componentView->saveCompInfo();
			m_componentView->m_doc.m_dirtyFlag=false;
			m_LCoVDoc.m_bDirty = true;
		}
	}
	SLCoListBoxItem* listItem = (SLCoListBoxItem*)m_componentListBox->item(nSelected);
	SCompIndex* pIndex = listItem->m_pCompIndex;
	
	if(!pIndex)return;
	string oldName = pIndex->name();
	SCompInfo* pComp = pIndex->compInfo();
	if(!pComp)return;

	prop_componentdlg* dlg=new prop_componentdlg(this);
	dlg->setName(QString::fromLatin1(oldName.c_str()));
	dlg->setRef(QString::fromLatin1(pComp->m_pszRef));
	dlg->setWidth(pComp->m_size.w());
	dlg->setHeight(pComp->m_size.h());
	dlg->setBlock(pComp->m_nBlock);
	dlg->setUsePattern(pComp->m_pPtn!=NULL);
	
	if(pComp->m_pPtn!=NULL){
		dlg->setUseBitPattern(pComp->m_pPtn->m_pBuff!=NULL);
	}else{
		dlg->setUseBitPattern(false);
	}
	
//	prop_comp* dlg=new prop_comp(this,0,true);
//	dlg->editName->setText(QString::fromLatin1(oldName.c_str()));	
//	dlg->editRef->setText(QString::fromLatin1(pComp->m_pszRef));
//	dlg->editWidth->setText(QString::number(pComp->m_size.w()));
//	dlg->editHeight->setText(QString::number(pComp->m_size.h()));
//	dlg->editBlock->setText(QString::number(pComp->m_nBlock));
//	dlg->checkUsePtn->setChecked(pComp->m_pPtn!=NULL);
	
	if(dlg->exec()){
		SSize sizeComp=SSize(dlg->width(),dlg->height());
		bool usePtn = dlg->usePattern();
		bool noBitPtn = !(dlg->useBitPattern());
		pComp->setSize(sizeComp,usePtn,noBitPtn);
		pComp->setUsePattern(usePtn,noBitPtn);
		pComp->setRef(dlg->ref().latin1());
		pComp->setBlock(dlg->block());
		string name = dlg->name().latin1();

//		SSize sizeComp=SSize(	dlg->editWidth->text().toInt(),
//							 	dlg->editHeight->text().toInt());
//		bool usePtn = dlg->checkUsePtn->isChecked();
//		pComp->setSize(sizeComp,usePtn);
//		pComp->setUsePattern(usePtn);
//		pComp->setRef(dlg->editRef->text().latin1());
//		pComp->setBlock(dlg->editBlock->text().toInt());
//		
//		string name = dlg->editName->text().latin1();
		
		if(name != oldName){
			string uniqname = m_LCoVDoc.m_CompLib.uniqueName(name);
			pIndex->setName(uniqname.c_str());
			m_componentListBox->repaint();
		}
		m_componentView->setCompIndex(pIndex);
		m_componentView->setDirty();
		m_LCoVDoc.m_bDirty = true;
	}
		
	delete dlg;
}

//EDIT-AddAlias  ϥɥ
void ApplicationWindow::editAddAlias()
{
	int nSelected = m_componentListBox->currentItem();
	if(nSelected < 0) return;

	if(m_componentView->m_pCompIndex!=NULL){
		m_componentView->releaseTemp();
		if(m_componentView->m_doc.m_dirtyFlag){
			m_componentView->saveCompInfo();
			m_componentView->m_doc.m_dirtyFlag=false;
			m_LCoVDoc.m_bDirty = true;
		}
	}
	
	SLCoListBoxItem* listItem = (SLCoListBoxItem*)m_componentListBox->item(nSelected);
	SCompIndex* pIndex = listItem->m_pCompIndex;
	
	
	if(!pIndex)return;
	string strName = pIndex->name();
	SCompInfo* pCompInfo = pIndex->compInfo();
	if(!pCompInfo)return;

	add_alias* dlg=new add_alias(this,0,true);
	dlg->labelAliasOf->setText(QString::fromLatin1(strName.c_str()));
	dlg->editAlias->setText("NAME");
	if(dlg->exec()){
		string strAlias = dlg->editAlias->text().latin1();

		string uniqname = m_LCoVDoc.m_CompLib.uniqueName(strAlias);
		SCompIndex* pIndex = new SCompIndex;
		pIndex->setName(uniqname.c_str());
		pIndex->setCompInfo(pCompInfo);

		m_LCoVDoc.m_CompLib.m_listCompIndex.push_back(pIndex);

		SLCoListBoxItem* listItem = new SLCoListBoxItem;
		
		listItem->m_pCompIndex = pIndex;
		m_componentListBox->insertItem(listItem,nSelected);
		m_componentListBox->setCurrentItem(nSelected);
		m_componentView->setCompIndex(pIndex);
		m_componentView->setDirty();
		m_LCoVDoc.m_bDirty = true;
	}
	delete dlg;
}

void  ApplicationWindow::toolSelect()
{
	m_componentView->setTool(SComponentView::TOOL_SELECT);
	setToolButtonState();	
}

void  ApplicationWindow::toolPin()
{
	m_componentView->setTool(SComponentView::TOOL_PIN);
	setToolButtonState();	
}

void  ApplicationWindow::toolLine()
{
	m_componentView->setTool(SComponentView::TOOL_LINE);
	setToolButtonState();	
}

void  ApplicationWindow::toolEllipse()
{
	m_componentView->setTool(SComponentView::TOOL_CIRCLE);
	setToolButtonState();	
}

void  ApplicationWindow::toolPolygon()
{
	m_componentView->setTool(SComponentView::TOOL_POLYGON);
	setToolButtonState();	
}

void  ApplicationWindow::toolArc()
{
	m_componentView->setTool(SComponentView::TOOL_ARC);
	setToolButtonState();	
}

void  ApplicationWindow::toolText()
{
	m_componentView->setTool(SComponentView::TOOL_TEXT);
	setToolButtonState();	
}

void  ApplicationWindow::toolHandle()
{
	bool currentMode= m_componentView->editNodeMode();
	m_componentView->setEditNodeMode(!currentMode);
	setToolButtonState();	
}

//ܥξ֤
void ApplicationWindow::setToolButtonState()
{
	int toolmode = m_componentView->tool();
	//˥塼Υå
	m_menuActionToolSelect->setChecked(toolmode == SComponentView::TOOL_SELECT);
	m_menuActionToolPin->setChecked(toolmode == SComponentView::TOOL_PIN);
	m_menuActionToolLine->setChecked(toolmode == SComponentView::TOOL_LINE);
	m_menuActionToolEllipse->setChecked(toolmode == SComponentView::TOOL_CIRCLE);
	m_menuActionToolPolygon->setChecked(toolmode == SComponentView::TOOL_POLYGON);
	m_menuActionToolArc->setChecked(toolmode == SComponentView::TOOL_ARC);
	m_menuActionToolHandle->setChecked(m_componentView->editNodeMode());
	
	//ġСΥܥξ
	m_ptbToolSelect->setOn(toolmode == SComponentView::TOOL_SELECT);
	m_ptbToolPin->setOn(toolmode == SComponentView::TOOL_PIN);
	m_ptbToolLine->setOn(toolmode == SComponentView::TOOL_LINE);
	m_ptbToolEllipse->setOn(toolmode == SComponentView::TOOL_CIRCLE);
	m_ptbToolPolygon->setOn(toolmode == SComponentView::TOOL_POLYGON);
	m_ptbToolArc->setOn(toolmode == SComponentView::TOOL_ARC);
	m_ptbToolText->setOn(toolmode == SComponentView::TOOL_TEXT);
	m_ptbToolHandle->setOn(m_componentView->editNodeMode());
}			
			
			
/*
void ApplicationWindow::print()
{
    printer->setFullPage( TRUE );
    if ( printer->setup(this) ) {		// printer dialog
	statusBar()->message( "Printing..." );
	QPainter p;
	if( !p.begin( printer ) ) {               // paint on printer
	    statusBar()->message( "Printing aborted", 2000 );
	    return;
	}

	QPaintDeviceMetrics metrics( p.device() );
	int dpiy = metrics.logicalDpiY();
	int margin = (int) ( (2/2.54)*dpiy ); // 2 cm margins
	QRect view( margin, margin, metrics.width() - 2*margin, metrics.height() - 2*margin );
	QSimpleRichText richText( QStyleSheet::convertFromPlainText(e->text()),
				  QFont(),
				  e->context(),
				  e->styleSheet(),
				  e->mimeSourceFactory(),
				  view.height() );
	richText.setWidth( &p, view.width() );
	int page = 1;
	do {
	    richText.draw( &p, margin, margin, view, colorGroup() );
	    view.moveBy( 0, view.height() );
	    p.translate( 0 , -view.height() );
	    p.drawText( view.right() - p.fontMetrics().width( QString::number( page ) ),
			view.bottom() + p.fontMetrics().ascent() + 5, QString::number( page ) );
	    if ( view.top() - margin >= richText.height() )
		break;
	    printer->newPage();
	    page++;
	} while (TRUE);

	statusBar()->message( "Printing completed", 2000 );
    } else {
	statusBar()->message( "Printing aborted", 2000 );
    }
}
*/
void ApplicationWindow::closeEvent( QCloseEvent* ce )
{
	
	if(m_componentView->m_pCompIndex!=NULL){
		m_componentView->releaseTemp();
		if(m_componentView->m_doc.m_dirtyFlag){
			m_componentView->saveCompInfo();
			m_componentView->m_doc.m_dirtyFlag=false;
			m_LCoVDoc.m_bDirty = true;
		}
	}
	
	
	if(!m_LCoVDoc.m_bDirty){
		m_componentView->setCompIndex(NULL);
		ce->accept();
		return;
	}
	switch( QMessageBox::information( this, "Qt-LCoV",
				      "Do you want to save the changes"
				      " to the document?",
				      "Yes", "No", "Cancel",
				      0, 1 ) ) {
		case 0:
			save();
			m_componentView->setCompIndex(NULL);
			ce->accept();
			break;
    	case 1:
			m_componentView->setCompIndex(NULL);
			ce->accept();
			break;
    	case 2:
    		default: // just for sanity
			ce->ignore();
			break;
	}
}


//Window˥塼Υߥ󥰤
void ApplicationWindow::setupWindowMenu()
{
	//printf("setupWindowMenu \n");
	QString fn;
	m_menuWindow->clear();
	int windowCount=m_appWindowList.count();
	int n;
	for(n=0;n<windowCount;n++){
		ApplicationWindow * w = (ApplicationWindow*)m_appWindowList.at(n);
		fn=w->fileName();
		if(fn.isEmpty()) fn="Untitled";
		QAction* action = m_menuWindow->addAction(fn);
		action->setData(QVariant::QVariant(n));
		action->setCheckable(true);
		if(w==this){
			action->setChecked(true);
		}
		//m_menuWindow->insertItem(fn,n);
		//if(w==this){
		//	m_menuWindow->setItemChecked(n,true);
		//}
	}
}

//Window˥塼Υƥब򤵤줿ȤSLOT
void ApplicationWindow::selectActiveDocument(QAction* action)
{
	int id=action->data().toInt();
	int windowCount=m_appWindowList.count();
	if(id<0 || windowCount<=id)return;
	ApplicationWindow * w = (ApplicationWindow*)m_appWindowList.at(id);
	w->setActiveWindow();
	w->raise();		//2005/06/11
}

//void ApplicationWindow::selectActiveDocument(int id)
//{
//	int windowCount=m_appWindowList.count();
//	if(id<0 || windowCount<=id)return;
//	ApplicationWindow * w = (ApplicationWindow*)m_appWindowList.at(id);
//	w->setActiveWindow();
//	w->raise();
//}



void ApplicationWindow::about()
{
	QPixmap icon( (const char**)lcoicon );

	QMessageBox mb(this);

	mb.setMinimumWidth(400);
	mb.setCaption("About  Qt-LCoV");
	mb.setTextFormat(Qt::RichText);
	mb.setText(	
			"<center><b>Qt-LCoV  Version 0.43</b><br><br>"
			"Copyright(C) 2002-2006 H.Okada(Suigyodo)<br>"
			"Qt-LCoV comes with absolutely no warranty.<br>"
			"URL  http://www.suigyodo.com/online<br>"
			"E-Mail  hitoshi@suigyodo.com</center>"
		);
	mb.setIconPixmap(icon);
	//mb.adjustSize();
	mb.exec();
	
}


void ApplicationWindow::aboutQt()
{
    QMessageBox::aboutQt( this, "Qt Application Example" );
}

//ComponentCopyμº
void ApplicationWindow::doComponentCopy()
{
//	Խʥǡ¸
//	if(m_wndView.m_pCompIndex!=NULL){
//		m_wndView.releaseTemp();
//		if(m_wndView.m_doc.m_dirtyFlag){
//			m_wndView.saveCompInfo();
//		}
//	}
	
	// ԽɥԽä			
	if(m_componentView->m_pCompIndex!=NULL){
		m_componentView->releaseTemp();	// ǡβ
		if(m_componentView->m_doc.m_dirtyFlag){ 	// Ѥä
			m_componentView->saveCompInfo();	// ʾݴ
			m_componentView->m_doc.m_dirtyFlag=false;
			m_LCoVDoc.m_bDirty = true;
		}
	}
	
	int nSelected = m_componentListBox->currentItem();
	if(nSelected < 0) return;
	SLCoListBoxItem* listItem = (SLCoListBoxItem*)m_componentListBox->item(nSelected);
	SCompIndex* pIndex = listItem->m_pCompIndex;

	if(!pIndex)return;
	string name = pIndex->name();
	if(name.empty())return;
	SCompInfo* pInfo = pIndex->compInfo();
	if(!pInfo)return;
	string str;
	SWriteCE3 wce3;
	wce3.Attach(&str);

	wce3.WriteRecord("+BSCH3_DATA_V.1.0");	wce3.WriteEOL();
	wce3.WriteRecord("+COMPONENT");			wce3.WriteEOL();
	wce3.WriteRecord("+BSCH3_LIB_V.1.0");	wce3.WriteEOL();
	pInfo->writeCe3(wce3,name.c_str());
	wce3.WriteRecord("-BSCH3_LIB_V.1.0");	wce3.WriteEOL();
	wce3.WriteRecordInt("X",pInfo->m_size.w()*10);
	wce3.WriteRecordInt("Y",pInfo->m_size.h()*10);
	wce3.WriteRecordString("LIB",name);
	wce3.WriteRecordString("N",  name);
	wce3.WriteRecordString("R",  pInfo->m_pszRef);wce3.WriteEOL();
	wce3.WriteRecord("-COMPONENT");			wce3.WriteEOL();
	wce3.WriteRecord("-BSCH3_DATA_V.1.0");	wce3.WriteEOL();

	QClipboard *cb = QApplication::clipboard();
    	cb->setText(QString::fromLocal8Bit(str.c_str()));
}

//ComponentDeleteκ
void ApplicationWindow::doComponentDelete()
{
	int nSelected = m_componentListBox->currentItem();
	if(nSelected < 0) return;
	SLCoListBoxItem* listItem = (SLCoListBoxItem*)m_componentListBox->item(nSelected);
	SCompIndex* pIndex = listItem->m_pCompIndex;
	if(!pIndex)return;

	
//	SLBCompName* pLB =(SLBCompName*)m_wndDlgBar.GetDlgItem(IDC_LIST_NAME);
//	int nIndex = pLB->GetCurSel();
//	if(nIndex<0)return;
	
	
//	Խʥǡ˴
//	m_wndView.setCompIndex(NULL);
	
	//ꥹȥܥåκ
	m_componentListBox->removeItem(nSelected);


	//m_pCompInfoͭƤʤɤΥå
	bool shareConpInfo =false;	

	SCompIndexListIterator iteIndex =m_LCoVDoc.m_CompLib.m_listCompIndex.begin();
	while(iteIndex != m_LCoVDoc.m_CompLib.m_listCompIndex.end()){
		if((*iteIndex)==pIndex){
			SCompIndexListIterator iteIndex2 =m_LCoVDoc.m_CompLib.m_listCompIndex.begin();
			while(iteIndex2 != m_LCoVDoc.m_CompLib.m_listCompIndex.end()){
				if(iteIndex!=iteIndex2){
					if((*iteIndex)->m_pCompInfo ==(*iteIndex2)->m_pCompInfo){
						shareConpInfo = true;
						break;
					}
				}
				iteIndex2++;
			}
			if(!shareConpInfo){///m_pCompInfoͭƤʤ
				SCompInfoListIterator iteInfo = m_LCoVDoc.m_CompLib.m_listCompInfo.begin();
				while(iteInfo != m_LCoVDoc.m_CompLib.m_listCompInfo.end()){
					if((*iteIndex)->m_pCompInfo == (*iteInfo)){
						delete (*iteInfo);
						m_LCoVDoc.m_CompLib.m_listCompInfo.erase(iteInfo);
						break;
					}
					iteInfo++;
				}
			}
			delete (*iteIndex);
			m_LCoVDoc.m_CompLib.m_listCompIndex.erase(iteIndex);
			break;
		}
		iteIndex++;
	}
	
	if(m_componentListBox->count()>0){
		//nSelected = m_componentListBox->currentItem();
		listboxSelectionChanged();
		//Խɥ˿ȿ				
		//itemSelected = (SLCoListBoxItem*)m_componentListBox->item(nSelected);
		//CompEdit->setCompIndex(itemSelected->m_pCompIndex);
	}else{
		m_componentView->setCompIndex(NULL);
	}
	m_LCoVDoc.m_bDirty =true;
	
	
}

void ApplicationWindow::redrawAll()
{
	int windowCount=m_appWindowList.count();
	int n;
	for(n=0;n<windowCount;n++){
		ApplicationWindow * w = (ApplicationWindow*)m_appWindowList.at(n);
		w->m_componentView->RefreshView();
		//w->m_pXBSchView->erase();
		//qDebug("redrawAll()\n");
	}
}	

//View Menu ϥɥ
void ApplicationWindow::viewZoomIn()
{
	m_componentView->OnViewZoomin();
}
void ApplicationWindow::viewZoomOut()
{
	m_componentView->OnViewZoomout();
}


void ApplicationWindow::setFont()
{
	QFont font;
	int dpi,point,pixel;
	QDesktopWidget *desktop = QApplication::desktop();
	dpi=desktop->logicalDpiX();
	
	string strname;
	if(g_cfg.getString("SmallFont","Name",strname)){
		font=QFont(QString::fromLocal8Bit(strname.c_str()));
		int n;
		if(g_cfg.getInt("SmallFont","Size",pixel)){
			point=(pixel*72+dpi-1)/dpi;			
			font.setPointSize(point);
		}
		//if(g_cfg.getInt("SmallFont","Size",n)) font.setPixelSize(n);
		if(g_cfg.getInt("SmallFont","Bold",n)) font.setBold(n!=0);
		if(g_cfg.getInt("SmallFont","Italic",n)) font.setItalic(n!=0);
		if(g_cfg.getInt("SmallFont","Underline",n)) font.setStrikeOut(n!=0);
		if(g_cfg.getInt("SmallFont","StrikeOut",n)) font.setUnderline(n!=0);
	}		

	bool ok;
	font=QFontDialog::getFont(&ok,font,this);
	if(ok){
		g_cfg.setString("SmallFont","Name",string(font.family().local8Bit()));
		point=font.pointSize();
		pixel=point*dpi/72;
		//QFontInfo fontInfo(font);
		font.setPixelSize(pixel);
		g_cfg.setInt("SmallFont","Size",pixel);
		g_cfg.setInt("SmallFont","Bold",font.bold()?1:0);
		g_cfg.setInt("SmallFont","Italic",font.italic()?1:0);
		g_cfg.setInt("SmallFont","Underline",font.underline()?1:0);
		g_cfg.setInt("SmallFont","StrikeOut",font.strikeOut()?1:0);
		g_SmallFont.SetFont(font);
		redrawAll();
		//m_pXBSchView->setSmallFont();
	}
}


//ComponentPasteμº
void  ApplicationWindow::doComponentPaste()
{
	QClipboard *cb = QApplication::clipboard();
	string cbbuff=string(cb->text().local8Bit());
	SReadCE3 rce3;
	rce3.Attach(cbbuff.c_str());
	
	string str("");

	rce3.ReadRecord(str);
	if(str != "+BSCH3_DATA_V.1.0") return;
	if(rce3.SkipTo("+BSCH3_LIB_V.1.0")==EOF) return;

	if(!m_LCoVDoc.m_CompLib.ReadLb3(rce3,true))return;
	
	SCompIndex* pIndex = m_LCoVDoc.m_CompLib.m_listCompIndex.back();
	if(pIndex){
		// ԽɥԽä			
		if(m_componentView->m_pCompIndex!=NULL){
			m_componentView->releaseTemp();	// ǡβ
			if(m_componentView->m_doc.m_dirtyFlag){ 	// Ѥä
				m_componentView->saveCompInfo();	// ʾݴ
				m_componentView->m_doc.m_dirtyFlag=false;
				m_LCoVDoc.m_bDirty = true;
			}
		}
		
		int nSelected = m_componentListBox->currentItem();

		SLCoListBoxItem* listItem = new SLCoListBoxItem;
		listItem->m_pCompIndex = pIndex;
		m_componentListBox->insertItem(listItem,nSelected);
		m_componentListBox->setCurrentItem(nSelected);
		m_componentView->setCompIndex(pIndex);

		m_LCoVDoc.m_bDirty = true;
	}
}

void ApplicationWindow::toolCreateBitPattern()
{
	if(!m_componentView->canCreateBitPtn()){
		QMessageBox::information( this, "Create Bit Pattern",
									"No Bit Pattern",
									 QMessageBox::Ok);
		return;
	}
	if(QMessageBox::warning( this, "Create Bit Pattern",
							"Overwrite existing bit pattern?",
							"Yes","Cancel",QString::null,0,0)) return;
	m_componentView->doCreateBitPtn();
	
}
