#!/bin/bash

# $1 = input.mpg
#quality="Low"
quality="high"

# First we strip the path name
base_name=$(basename $1)
# then we strip the extension(s)
base_name=${base_name%.*}
dir_name=`dirname $1`
echo "DirName=$dir_name <> BaseName=$base_name"

if [ $quality="high" ];
then
	mencoder $1 -nosound -ovc lavc -lavcopts vcodec=mpeg2video:keyint=132:vbitrate=1000:autoaspect:vrc_buf_size=1000:vrc_minrate=1000:vrc_maxrate=2500:vpsize=1000:mbd=2:precmp=2:cmp=2:subcmp=2:trell:cbp:tcplx_mask=0.1:scplx_mask=0.1 -of mpeg -o $dir_name/$base_name.mpeg
else
	mencoder $1 -nosound -ovc lavc -lavcopts vcodec=mpeg2video:keyint=132:vbitrate=1000:autoaspect:vrc_buf_size=1000:vrc_minrate=1000:vrc_maxrate=2500:vpsize=1000 -of mpeg -o $dir_name/$base_name.mpeg
fi;

mplayer -ni $dir_name/$base_name.mpeg -dumpvideo -dumpfile $dir_name/$base_name.m2v

rm $dir_name/$base_name.mpeg

# get the audio
mplayer $1 -dumpaudio -dumpfile $dir_name/$base_name.mp2

mplex -f 8 -V -b500 -o $dir_name/$base_name.mpeg $dir_name/$base_name.m2v $dir_name/$base_name.mp2