
if [ "$1" = "install" ]
then

  cd simpledvd
  make install
  cd ../complexdvd
  make install

elif [ "$1" = "clean" ]
then

  cd simpledvd
  make clean
  rm -rf Makefile* *~ core* .ui .obj .moc
  cd ../complexdvd
  make clean
  rm -rf Makefile* *~ core* .ui .obj .moc
  cd ../menuslide
  make clean; rm menuslide
  rm -rf Makefile* *~ core* .ui .obj .moc
  cd ../testplugs
  make clean
  rm -rf Makefile* *~ core* .ui .obj .moc
  cd ../plugins && rm *.so*

else
  CORES=`cat /proc/cpuinfo | grep processor | wc -l`
  if [ $# -gt 0 ]; then
    if [ $1 -eq $1 2> /dev/null ]; then
      CORES=$1
    fi; 
  fi;

  QMAKE=$QTDIR/bin/qmake
  if [ ! -e $QMAKE ]; then
    QMAKE=qmake
  fi;
  cd simpledvd
  $QMAKE -o Makefile.tmp
  sed "10 s,^,QTDIR = $QTDIR\n," Makefile.tmp > Makefile
  make -j $CORES
  rm Makefile.tmp
  cd ../complexdvd
  $QMAKE -o Makefile.tmp
  sed "10 s,^,QTDIR = $QTDIR\n," Makefile.tmp > Makefile
  make -j $CORES
  rm Makefile.tmp
  cd ../menuslide
  $QMAKE -o Makefile.tmp
  sed "10 s,^,QTDIR = $QTDIR\n," Makefile.tmp > Makefile
  make -j $CORES
  rm Makefile.tmp
  cd ../testplugs
  $QMAKE -o Makefile.tmp
  sed "10 s,^,QTDIR = $QTDIR\n," Makefile.tmp > Makefile
  make -j $CORES
  rm Makefile.tmp

fi;

