/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEEXPRESSIONEDIT_H
#define QALCULATEEXPRESSIONEDIT_H

#include <klineedit.h>
#include <kcompletionbox.h>
#include <kcompletion.h>
#include <qvaluevector.h>

class QStringList;
class QPopupMenu;
class QalculateExpressionEditCompletionBox;
class ExpressionItem;
class QListBoxItem;

class QalculateExpressionEdit : public KLineEdit {

	Q_OBJECT

public:

	QalculateExpressionEdit(bool connected_to_main_win, QWidget *parent = 0, const char *name = 0);
	virtual ~QalculateExpressionEdit();

	QValueVector<ExpressionItem*> matched_items;

	bool b_main;
	QStringList expression_history;
	int expression_history_index;
	bool dont_change_index;
	QalculateExpressionEditCompletionBox *qalculateCompletionBox;
	KCompletion *qalculateCompletion;

	virtual bool eventFilter(QObject *o, QEvent *ev);
	void keyPressEvent(QKeyEvent *e);

public slots:

	void onTextChanged(const QString&);
	void addToHistory(const QString&);
	void wrapSelection();
	void makeCompletion(const QString&);
	void insertCompletion(QListBoxItem *li);
	void updateCompletion();
	void setAfterCompletionPosition();
	void cancelCompletion(const QString &str);
	void setCompletedItems();
	void enableCompletion();
	void disableCompletion();
	bool completionEnabled() const;
	
signals:

	void cursorMoved();

protected:
	
	virtual QPopupMenu *createPopupMenu();
	virtual void timerEvent(QTimerEvent*);
	int cstart, cend, cpos_ac, prev_position, pos_timer;
	QString completed_text;
	int pos_before_completion;

};

class QalculateExpressionEditCompletionBox : public KCompletionBox {

	Q_OBJECT

public:

	QalculateExpressionEditCompletionBox(QWidget *parent, const char *name = 0);
	virtual ~QalculateExpressionEditCompletionBox();
	void insertItemList(const QValueVector<ExpressionItem*>& list, int index = -1);

public slots:

	void setItems(const QValueVector<ExpressionItem*>& items);
	
protected:

	void hideEvent(QHideEvent*);
	
signals:

	void hidden();
    
};


#endif
