;;;; prime-process.el: <DESCRIPTION>
;;;; $Id: prime-process.el,v 1.2 2004/01/28 08:38:31 komatsu Exp $
;;;;
;;;; Copyright (C) 2002, 2003, 2004 Hiroyuki Komatsu <komatsu@taiyaki.org>
;;;;     All rights reserved.
;;;;     This is free software with ABSOLUTELY NO WARRANTY.
;;;;
;;;; You can redistribute it and/or modify it under the terms of 
;;;; the GNU General Public License version 2.

(defvar prime-process-extra-status-alist nil)

(defun prime-process-command-start (process buffer command &optional args-list
					    exit-function)
  (condition-case nil
      (save-excursion
	(get-buffer-create buffer)
	(set-buffer buffer)
	(and exit-function
	     (progn (make-variable-buffer-local 'kill-buffer-hook)
		    (add-hook 'kill-buffer-hook exit-function)
		    (add-hook 'kill-emacs-hook  exit-function)))
;	(apply 'start-process-shell-command
;	       process buffer command args-list)
	(process-kill-without-query
	 (apply 'start-process-shell-command
		process buffer command args-list))
	(if (fboundp 'set-current-process-coding-system) ;;; for Emacs20
	    (set-current-process-coding-system *euc-japan* *euc-japan*)
	  (set-buffer-process-coding-system 'euc-japan 'euc-japan))
	t
	)
    (error nil)
    ))

(defun prime-process-network-start (process buffer server port
					    &optional exit-function)
  (condition-case nil
      (save-excursion
	(get-buffer-create buffer)
	(set-buffer buffer)
	(and exit-function
	     (progn (make-variable-buffer-local 'kill-buffer-hook)
		    (add-hook 'kill-buffer-hook exit-function)
		    (add-hook 'kill-emacs-hook  exit-function)))
	(process-kill-without-query
	 (open-network-stream process buffer server port))
	(if (fboundp 'set-current-process-coding-system) ;;; for Emacs20
	    (set-current-process-coding-system *euc-japan* *euc-japan*)
	  (set-buffer-process-coding-system 'euc-japan 'euc-japan))
	t
	)
    (error nil)
    ))

(defun prime-process-set-exit-function (process exit-function)
  (save-excursion
    (set-buffer (process-buffer process))
    (make-variable-buffer-local 'kill-buffer-hook)
    (add-hook 'kill-buffer-hook exit-function)
    (add-hook 'kill-emacs-hook  exit-function)
    ))  

(defun prime-process-status (process)
  (or (process-status process)
      (cdr (assoc process prime-process-extra-status-alist)))
  )

(defun prime-process-error (process &optional message)
  (prime-process-status-set-error process)
  (message (or message "$B%(%i!<$,H/@8$7$^$7$?(B"))
  )

(defun prime-process-status-set-error (process)
  (remassoc process prime-process-extra-status-alist)
  (setq prime-process-extra-status-alist
	(cons (cons process 'error) prime-process-extra-status-alist))
  )

(provide 'prime-process)
