/*
** PHREL
** $Id: util.c,v 1.7 2006/03/21 06:04:44 sella Exp $
** Copyright (c) 2004 James M. Sella. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/

static const char rcsid[] = "$Id: util.c,v 1.7 2006/03/21 06:04:44 sella Exp $";

#include "util.h"

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <assert.h>

// Stolen from Newsgroup example by Floyd Davidson (floyd@ptialaska.net) on 2002-07-16 04:50:07 PST
void source_ip(char *interface, struct in_addr *ip) {
	int                sockfd, size  = 1;
	struct ifreq       *ifr;
	struct ifconf      ifc;
	struct sockaddr_in sa;

	if (0 > (sockfd = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP))) {
		syslog(LOG_EMERG, "Failed to open socket.");
		exit(EXIT_FAILURE);
	}

	ifc.ifc_len = IFRSIZE;
	ifc.ifc_req = NULL;

	do {
		++size;
		//FIXME: Does this realloc cause a leak??
		/* realloc buffer size until no overflow occurs  */
		if (NULL == (ifc.ifc_req = (struct ifreq*) realloc(ifc.ifc_req, IFRSIZE))) {
			syslog(LOG_EMERG, "Out of memory.");
			exit(EXIT_FAILURE);
		}
		ifc.ifc_len = IFRSIZE;
		if (ioctl(sockfd, SIOCGIFCONF, &ifc)) {
			syslog(LOG_EMERG, "ioctl(SIOCFIFCONF) error");
			exit(EXIT_FAILURE);
		}
	} while  (IFRSIZE <= ifc.ifc_len);

	ifr = ifc.ifc_req;
	for (;(char *) ifr < (char *) ifc.ifc_req + ifc.ifc_len; ++ifr) {

		if (ifr->ifr_addr.sa_data == (ifr+1)->ifr_addr.sa_data) {
			continue;  /* duplicate, skip it */
		}

		if (ioctl(sockfd, SIOCGIFFLAGS, ifr)) {
			continue;  /* failed to get flags, skip it */
		}

		if (strncmp(ifr->ifr_name, "lo", 2) && (strlen(interface) < 1 || !strcmp(ifr->ifr_name, interface))) {
			//fprintf(stderr, "Interface: %s\n", ifr->ifr_name);
			*ip = inaddrr(ifr_addr.sa_data);
			//fprintf(stderr, "IP Address: %s\n", inet_ntoa(*ip));

			break;
		}
	}

	/* Free memory. */
	free(ifc.ifc_req);

	close(sockfd);
}

/*
** Local Variables:
** c-basic-offset: 3
** tab-width: 3
** End:
** vim: noet ts=3 sw=3
*/
