(* File: pa_do_top.ml

   Copyright (C) 2008

     Christophe Troestler <Christophe.Troestler@umons.ac.be>
     WWW: http://math.umh.ac.be/an/software/

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2.1 or
   later as published by the Free Software Foundation, with the special
   exception on linking described in the file LICENSE.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the file
   LICENSE for more details. *)

open Format

let print_outcome = true
let error_fmt = Format.err_formatter

(* Ideally we would use

   let s = "let __pa_do__identity x = x;;" in
   let phrase = !Toploop.parse_toplevel_phrase (Lexing.from_string s) in
   Toploop.execute_phrase print_outcome error_fmt phrase

   but [parse_toplevel_phrase] hangs when camlp4 is loaded (see OCaml
   bug 4593).  So we create a temporary file and load it...  However, that
   does not always work as intended as we get "I/O error: Bad file
   descriptor" (see OCaml bug 4495). *)
let eval s =
  let fname, fh = Filename.open_temp_file "pa_do__" ".ml" in
  output_string fh s;
  close_out fh;
  let outcome = Toploop.use_file error_fmt fname in
  Sys.remove fname;
  outcome

(* To ease development *)
(* let () = *)
(*   let devel_dir = "/home/trch/software/OCaml/syntax-ext/pa-do/trunk/src/" in *)
(*   if Sys.file_exists devel_dir then *)
(*     Topdirs.dir_directory devel_dir *)

(* Register the minimum camlp4 modules so that the extension works *)
let load_camlp4 =
  let camlp4 = "camlp4o.cma" in
  let not_loaded = ref true in
  fun () ->
    if !not_loaded then begin
      printf "Loading %S.@\n%!" camlp4;
      Topdirs.dir_directory "+camlp4";
      Topdirs.dir_load error_fmt camlp4;
      not_loaded := false;
    end

let load m =
  printf "Loading %S.@\n%!" m;
  try Topdirs.dir_load error_fmt m
  with _ ->
    load_camlp4();
    try Topdirs.dir_load error_fmt m
    with _ -> eprintf "Could not load module %S@\n%!" m


let () =
  if true (* not already_loaded = ? *) then begin
    (* raise [Symtable.Error _] if camlp4 is not loaded, freeze the
       toplevel if it is... *)
(*     load "pa_do.cmo"; *)
(*     Topdirs.dir_load error_fmt "nums.cma"; *)
(*     load "pa_do_nums.cmo"; *)
    (* Register printers for nums? *)
  end

(* Local Variables: *)
(* compile-command: "omake --no--progress" *)
(* End: *)
