/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _TOOLKIT_AWT_UNOCONTROLBASE_HXX_
#define _TOOLKIT_AWT_UNOCONTROLBASE_HXX_

#include <com/sun/star/awt/Size.hpp>

#include <toolkit/controls/unocontrol.hxx>

//	----------------------------------------------------
//	class UnoControlBase
//	----------------------------------------------------

class UnoControlBase : public UnoControl
{
protected:
    sal_Bool					ImplHasProperty( sal_uInt16 nProp );
    sal_Bool					ImplHasProperty( const ::rtl::OUString& aPropertyName );
    void						ImplSetPropertyValue( const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Any& aValue, sal_Bool bUpdateThis );
    void						ImplSetPropertyValues( const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aPropertyNames, const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aValues, sal_Bool bUpdateThis );
    ::com::sun::star::uno::Any	ImplGetPropertyValue( const ::rtl::OUString& aPropertyName );

    sal_Bool		ImplGetPropertyValue_BOOL( sal_uInt16 nProp );
    sal_Int16 		ImplGetPropertyValue_INT16( sal_uInt16 nProp );
    sal_uInt16 		ImplGetPropertyValue_UINT16( sal_uInt16 nProp );
    sal_Int32 		ImplGetPropertyValue_INT32( sal_uInt16 nProp );
    sal_uInt32 		ImplGetPropertyValue_UINT32( sal_uInt16 nProp );
    double 			ImplGetPropertyValue_DOUBLE( sal_uInt16 nProp );
    ::rtl::OUString	ImplGetPropertyValue_UString( sal_uInt16 nProp );

    // XLayoutConstrains (nur wenn das Control es unterstuetzt!)
    ::com::sun::star::awt::Size	Impl_getMinimumSize();
    ::com::sun::star::awt::Size	Impl_getPreferredSize();
    ::com::sun::star::awt::Size	Impl_calcAdjustedSize( const ::com::sun::star::awt::Size& rNewSize );

    // XTextLayoutConstrains (nur wenn das Control es unterstuetzt!)
    ::com::sun::star::awt::Size	Impl_getMinimumSize( sal_Int16 nCols, sal_Int16 nLines );
    void						Impl_getColumnsAndLines( sal_Int16& nCols, sal_Int16& nLines );
};



#endif // _TOOLKIT_AWT_UNOCONTROLBASE_HXX_

