(**************************************************************************)
(*                                                                        *)
(*  Ocamlgraph: a generic graph library for OCaml                         *)
(*  Copyright (C) 2004-2010                                               *)
(*  Sylvain Conchon, Jean-Christophe Filliatre and Julien Signoles        *)
(*                                                                        *)
(*  This software is free software; you can redistribute it and/or        *)
(*  modify it under the terms of the GNU Library General Public           *)
(*  License version 2.1, with the special exception on linking            *)
(*  described in file LICENSE.                                            *)
(*                                                                        *)
(*  This software is distributed in the hope that it will be useful,      *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *)
(*                                                                        *)
(**************************************************************************)

# 20 "src/dot_lexer.mll"
 
  open Lexing
  open Dot_ast
  open Dot_parser

  let string_buf = Buffer.create 1024

  let keyword =
    let h = Hashtbl.create 17 in
    List.iter 
      (fun (s,k) -> Hashtbl.add h s k)
      [
	"strict", STRICT;
	"graph", GRAPH;
	"digraph", DIGRAPH;
	"subgraph", SUBGRAPH;
	"node", NODE;
	"edge", EDGE;
      ];
    fun s -> let s = String.lowercase s in Hashtbl.find h s


# 25 "src/dot_lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\238\255\239\255\240\255\241\255\078\000\088\000\098\000\
    \176\000\245\255\246\255\247\255\248\255\249\255\250\255\251\255\
    \252\255\114\000\001\000\005\000\254\255\002\000\253\255\191\000\
    \244\255\211\000\221\000\157\000\002\000\255\255\032\000\054\000\
    \015\000";
  Lexing.lex_backtrk = 
   "\255\255\255\255\255\255\255\255\255\255\013\000\017\000\012\000\
    \017\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\017\000\017\000\000\000\255\255\255\255\255\255\255\255\
    \255\255\013\000\013\000\255\255\002\000\255\255\255\255\255\255\
    \001\000";
  Lexing.lex_default = 
   "\001\000\000\000\000\000\000\000\000\000\255\255\255\255\255\255\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\021\000\255\255\000\000\021\000\000\000\255\255\
    \000\000\255\255\255\255\022\000\255\255\000\000\022\000\020\000\
    \255\255";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\019\000\019\000\020\000\020\000\019\000\019\000\019\000\
    \000\000\000\000\019\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \019\000\000\000\004\000\018\000\020\000\019\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\015\000\008\000\006\000\017\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\016\000\014\000\003\000\013\000\029\000\000\000\
    \000\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\010\000\020\000\009\000\029\000\007\000\
    \032\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\012\000\026\000\011\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \025\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
    \025\000\025\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\022\000\000\000\000\000\000\000\
    \000\000\021\000\000\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\000\000\000\000\029\000\
    \000\000\007\000\000\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\024\000\023\000\000\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\000\000\000\000\000\000\000\000\024\000\025\000\
    \025\000\025\000\025\000\025\000\025\000\025\000\025\000\025\000\
    \025\000\028\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \002\000\255\255\255\255\025\000\025\000\025\000\025\000\025\000\
    \025\000\025\000\025\000\025\000\025\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\022\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\016\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\018\000\021\000\000\000\019\000\019\000\
    \255\255\255\255\019\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\000\000\000\000\028\000\019\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\032\000\255\255\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\030\000\000\000\030\000\000\000\
    \031\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\005\000\000\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \006\000\006\000\006\000\006\000\006\000\006\000\006\000\006\000\
    \006\000\006\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\017\000\255\255\255\255\255\255\
    \255\255\017\000\255\255\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\255\255\255\255\027\000\
    \255\255\007\000\255\255\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\008\000\008\000\255\255\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\008\000\255\255\255\255\255\255\255\255\008\000\023\000\
    \023\000\023\000\023\000\023\000\023\000\023\000\023\000\023\000\
    \023\000\027\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\018\000\021\000\025\000\025\000\025\000\025\000\025\000\
    \025\000\025\000\025\000\025\000\025\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \030\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\031\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\027\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "";
  Lexing.lex_backtrk_code = 
   "";
  Lexing.lex_default_code = 
   "";
  Lexing.lex_trans_code = 
   "";
  Lexing.lex_check_code = 
   "";
  Lexing.lex_code = 
   "";
}

let rec token lexbuf =
    __ocaml_lex_token_rec lexbuf 0
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 52 "src/dot_lexer.mll"
      ( token lexbuf )
# 188 "src/dot_lexer.ml"

  | 1 ->
# 54 "src/dot_lexer.mll"
      ( token lexbuf )
# 193 "src/dot_lexer.ml"

  | 2 ->
# 56 "src/dot_lexer.mll"
      ( comment lexbuf; token lexbuf )
# 198 "src/dot_lexer.ml"

  | 3 ->
# 58 "src/dot_lexer.mll"
      ( COLON )
# 203 "src/dot_lexer.ml"

  | 4 ->
# 60 "src/dot_lexer.mll"
      ( COMMA )
# 208 "src/dot_lexer.ml"

  | 5 ->
# 62 "src/dot_lexer.mll"
      ( SEMICOLON )
# 213 "src/dot_lexer.ml"

  | 6 ->
# 64 "src/dot_lexer.mll"
      ( EQUAL )
# 218 "src/dot_lexer.ml"

  | 7 ->
# 66 "src/dot_lexer.mll"
      ( LBRA )
# 223 "src/dot_lexer.ml"

  | 8 ->
# 68 "src/dot_lexer.mll"
      ( RBRA )
# 228 "src/dot_lexer.ml"

  | 9 ->
# 70 "src/dot_lexer.mll"
      ( LSQ )
# 233 "src/dot_lexer.ml"

  | 10 ->
# 72 "src/dot_lexer.mll"
      ( RSQ )
# 238 "src/dot_lexer.ml"

  | 11 ->
# 74 "src/dot_lexer.mll"
      ( EDGEOP )
# 243 "src/dot_lexer.ml"

  | 12 ->
let
# 75 "src/dot_lexer.mll"
             s
# 249 "src/dot_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 76 "src/dot_lexer.mll"
      ( try keyword s with Not_found -> ID (Ident s) )
# 253 "src/dot_lexer.ml"

  | 13 ->
let
# 77 "src/dot_lexer.mll"
              s
# 259 "src/dot_lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 78 "src/dot_lexer.mll"
      ( ID (Number s) )
# 263 "src/dot_lexer.ml"

  | 14 ->
# 80 "src/dot_lexer.mll"
      ( Buffer.clear string_buf; 
	let s = string lexbuf in
	ID (String s) )
# 270 "src/dot_lexer.ml"

  | 15 ->
# 84 "src/dot_lexer.mll"
      ( Buffer.clear string_buf; 
	html lexbuf; 
	ID (Html (Buffer.contents string_buf)) )
# 277 "src/dot_lexer.ml"

  | 16 ->
# 88 "src/dot_lexer.mll"
      ( EOF )
# 282 "src/dot_lexer.ml"

  | 17 ->
let
# 89 "src/dot_lexer.mll"
         c
# 288 "src/dot_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 90 "src/dot_lexer.mll"
      ( failwith ("Dot_lexer: invalid character " ^ String.make 1 c) )
# 292 "src/dot_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_token_rec lexbuf __ocaml_lex_state

and string lexbuf =
    __ocaml_lex_string_rec lexbuf 27
and __ocaml_lex_string_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 94 "src/dot_lexer.mll"
      ( Buffer.contents string_buf )
# 303 "src/dot_lexer.ml"

  | 1 ->
# 96 "src/dot_lexer.mll"
      ( Buffer.add_char string_buf '"';
	string lexbuf )
# 309 "src/dot_lexer.ml"

  | 2 ->
let
# 98 "src/dot_lexer.mll"
         c
# 315 "src/dot_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 99 "src/dot_lexer.mll"
      ( Buffer.add_char string_buf c;
	string lexbuf )
# 320 "src/dot_lexer.ml"

  | 3 ->
# 102 "src/dot_lexer.mll"
      ( failwith ("Dot_lexer: unterminated string literal") )
# 325 "src/dot_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_string_rec lexbuf __ocaml_lex_state

and html lexbuf =
    __ocaml_lex_html_rec lexbuf 30
and __ocaml_lex_html_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 106 "src/dot_lexer.mll"
      ( () )
# 336 "src/dot_lexer.ml"

  | 1 ->
# 108 "src/dot_lexer.mll"
      ( Buffer.add_char string_buf '<'; html lexbuf;
	Buffer.add_char string_buf '>'; html lexbuf )
# 342 "src/dot_lexer.ml"

  | 2 ->
let
# 110 "src/dot_lexer.mll"
         c
# 348 "src/dot_lexer.ml"
= Lexing.sub_lexeme_char lexbuf lexbuf.Lexing.lex_start_pos in
# 111 "src/dot_lexer.mll"
      ( Buffer.add_char string_buf c;
	html lexbuf )
# 353 "src/dot_lexer.ml"

  | 3 ->
# 114 "src/dot_lexer.mll"
      ( failwith ("Dot_lexer: unterminated html literal") )
# 358 "src/dot_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_html_rec lexbuf __ocaml_lex_state

and comment lexbuf =
    __ocaml_lex_comment_rec lexbuf 31
and __ocaml_lex_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 118 "src/dot_lexer.mll"
      ( () )
# 369 "src/dot_lexer.ml"

  | 1 ->
# 120 "src/dot_lexer.mll"
      ( comment lexbuf )
# 374 "src/dot_lexer.ml"

  | 2 ->
# 122 "src/dot_lexer.mll"
      ( failwith "Dot_lexer: unterminated comment" )
# 379 "src/dot_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_comment_rec lexbuf __ocaml_lex_state

;;

