/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2009 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef __Rootless_H__
#define __Rootless_H__

#include "window.h"

/*
 * The real X server's root window if we
 * are in rootless mode.
 */

extern WindowPtr nxagentRootlessWindow;

/*
 * We want to import all properties changed by external clients to
 * reflect properties of our internal windows but we must ignore
 * all the property notify events generated by our own requests.
 * For this purpose we implement a FIFO to record every change pro-
 * perty request that we dispatch. In this way, when processing a
 * property notify, we can distinguish between the notifications
 * generated by our requests from those generated by other clients
 * connected to the real X server.
 */

typedef struct
{
  Window window;
  Atom property;
} PropertyRequestRec;

extern PropertyRequestRec nxagentPropertyRequests[256];

Window nxagentRootlessWindowParent(WindowPtr pWin);

void nxagentRootlessAddTopLevelWindow(WindowPtr pWin, Window w);
void nxagentRootlessDelTopLevelWindow(WindowPtr pWin);

WindowPtr nxagentRootlessTopLevelWindow(Window w);

#ifndef _XSERVER64
void nxagentRootlessRestack(Window *toplevel, unsigned int ntoplevel);
#else
void nxagentRootlessRestack(unsigned long *toplevel, unsigned int ntoplevel);
#endif


int nxagentExportAllProperty(WindowPtr pWin);

int nxagentExportProperty(WindowPtr pWin, Atom property, Atom type, int format,
                              int mode, unsigned long nUnits, pointer value);

#define MAX_RETRIEVED_PROPERTY_SIZE 256 * 1024

void nxagentImportProperty(Window window, Atom property, Atom type, int format,
                               unsigned long nitems, unsigned long bytes_after, unsigned char *buffer);

/*
 * Push last ChangeProperty to the list.
 */

void nxagentAddPropertyToList(Atom property, WindowPtr pWin);

/*
 * Check if a PropertyNotify match the top
 * of the list.
 */

Bool nxagentNotifyMatchChangeProperty(void *X);

void nxagentConfigureRootlessWindow(WindowPtr pWin, int x, int y, int w, int h, int bw,
                                        WindowPtr pSib, int stack_mode, Mask mask);

void nxagentCirculateRootlessWindows(int direction);

void nxagentFreePropertyList(void);

#endif /* __Rootless_H__ */
