/***************************************************************************
 * Nping.h -- This file contains general defines and constants used        *
 * throughout Nping's code.                                                *
 *                                                                         *
 ***********************IMPORTANT NMAP LICENSE TERMS************************
 *                                                                         *
 * The Nmap Security Scanner is (C) 1996-2010 Insecure.Com LLC. Nmap is    *
 * also a registered trademark of Insecure.Com LLC.  This program is free  *
 * software; you may redistribute and/or modify it under the terms of the  *
 * GNU General Public License as published by the Free Software            *
 * Foundation; Version 2 with the clarifications and exceptions described  *
 * below.  This guarantees your right to use, modify, and redistribute     *
 * this software under certain conditions.  If you wish to embed Nmap      *
 * technology into proprietary software, we sell alternative licenses      *
 * (contact sales@insecure.com).  Dozens of software vendors already       *
 * license Nmap technology such as host discovery, port scanning, OS       *
 * detection, and version detection.                                       *
 *                                                                         *
 * Note that the GPL places important restrictions on "derived works", yet *
 * it does not provide a detailed definition of that term.  To avoid       *
 * misunderstandings, we consider an application to constitute a           *
 * "derivative work" for the purpose of this license if it does any of the *
 * following:                                                              *
 * o Integrates source code from Nmap                                      *
 * o Reads or includes Nmap copyrighted data files, such as                *
 *   nmap-os-db or nmap-service-probes.                                    *
 * o Executes Nmap and parses the results (as opposed to typical shell or  *
 *   execution-menu apps, which simply display raw Nmap output and so are  *
 *   not derivative works.)                                                *
 * o Integrates/includes/aggregates Nmap into a proprietary executable     *
 *   installer, such as those produced by InstallShield.                   *
 * o Links to a library or executes a program that does any of the above   *
 *                                                                         *
 * The term "Nmap" should be taken to also include any portions or derived *
 * works of Nmap.  This list is not exclusive, but is meant to clarify our *
 * interpretation of derived works with some common examples.  Our         *
 * interpretation applies only to Nmap--we don't speak for other people's  *
 * GPL works.                                                              *
 *                                                                         *
 * If you have any questions about the GPL licensing restrictions on using *
 * Nmap in non-GPL works, we would be happy to help.  As mentioned above,  *
 * we also offer alternative license to integrate Nmap into proprietary    *
 * applications and appliances.  These contracts have been sold to dozens  *
 * of software vendors, and generally include a perpetual license as well  *
 * as providing for priority support and updates as well as helping to     *
 * fund the continued development of Nmap technology.  Please email        *
 * sales@insecure.com for further information.                             *
 *                                                                         *
 * As a special exception to the GPL terms, Insecure.Com LLC grants        *
 * permission to link the code of this program with any version of the     *
 * OpenSSL library which is distributed under a license identical to that  *
 * listed in the included COPYING.OpenSSL file, and distribute linked      *
 * combinations including the two. You must obey the GNU GPL in all        *
 * respects for all of the code used other than OpenSSL.  If you modify    *
 * this file, you may extend this exception to your version of the file,   *
 * but you are not obligated to do so.                                     *
 *                                                                         *
 * If you received these files with a written license agreement or         *
 * contract stating terms other than the terms above, then that            *
 * alternative license agreement takes precedence over these comments.     *
 *                                                                         *
 * Source is provided to this software because we believe users have a     *
 * right to know exactly what a program is going to do before they run it. *
 * This also allows you to audit the software for security holes (none     *
 * have been found so far).                                                *
 *                                                                         *
 * Source code also allows you to port Nmap to new platforms, fix bugs,    *
 * and add new features.  You are highly encouraged to send your changes   *
 * to nmap-dev@insecure.org for possible incorporation into the main       *
 * distribution.  By sending these changes to Fyodor or one of the         *
 * Insecure.Org development mailing lists, it is assumed that you are      *
 * offering the Nmap Project (Insecure.Com LLC) the unlimited,             *
 * non-exclusive right to reuse, modify, and relicense the code.  Nmap     *
 * will always be available Open Source, but this is important because the *
 * inability to relicense code has caused devastating problems for other   *
 * Free Software projects (such as KDE and NASM).  We also occasionally    *
 * relicense the code to third parties as discussed above.  If you wish to *
 * specify special license conditions of your contributions, just say so   *
 * when you send them.                                                     *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License v2.0 for more details at                         *
 * http://www.gnu.org/licenses/gpl-2.0.html , or in the COPYING file       *
 * included with Nmap.                                                     *
 *                                                                         *
 ***************************************************************************/

#ifndef NPING_H
#define NPING_H 1

/* Common library requirements and definitions *******************************/
#include <stdio.h>
#include <math.h>
#include <assert.h>
#include <nbase.h>
#include <fcntl.h>
#include <stdarg.h>
#include <errno.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "../libnetutil/netutil.h"

#ifdef HAVE_CONFIG_H
    #include "nping_config.h"
#else
    #ifdef WIN32
        #include "nping_winconfig.h"
    #endif /* WIN32 */
#endif /* HAVE_CONFIG_H */

#ifndef WIN32
    #include <sysexits.h>
#endif

#if HAVE_UNISTD_H
    #include <unistd.h>
#endif

#ifdef STDC_HEADERS
    #include <stdlib.h>
#else
    void *malloc();
    void *realloc();
#endif

#if STDC_HEADERS || HAVE_STRING_H
    #include <string.h>
    #if !STDC_HEADERS && HAVE_MEMORY_H
        #include <memory.h>
    #endif
#endif

#if HAVE_STRINGS_H
    #include <strings.h>
#endif

#ifdef HAVE_BSTRING_H
    #include <bstring.h>
#endif

#ifndef WIN32
    #include <sys/wait.h>
#endif /* !WIN32 */

#ifdef HAVE_SYS_PARAM_H
    #include <sys/param.h> /* Defines MAXHOSTNAMELEN on BSD*/
#endif

#if HAVE_RPC_TYPES_H
    #include <rpc/types.h>
#endif

#if HAVE_SYS_SOCKET_H
    #include <sys/socket.h>
#endif

#if HAVE_NETINET_IN_H
    #include <netinet/in.h>
#endif

#if HAVE_NETDB_H
    #include <netdb.h>
#endif

#if TIME_WITH_SYS_TIME
    #include <sys/time.h>
    #include <time.h>
#else
    #if HAVE_SYS_TIME_H
        #include <sys/time.h>
    #else
        #include <time.h>
    # endif
#endif

#ifdef HAVE_PWD_H
    #include <pwd.h>
#endif

#if HAVE_ARPA_INET_H
    #include <arpa/inet.h>
#endif

#if HAVE_SYS_RESOURCE_H
    #include <sys/resource.h>
#endif

/* Keep assert() defined for security reasons */
#undef NDEBUG

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 128
#endif

#define MAXLINE 255

/* CONSTANT DEFINES ***********************************************************
 * @warning It's better not to play with these, because the code may make     *
 * SOME asumptions like "defined value A is an integer greater than defined   *
 * value B" or "value C is an odd integer greater than 0", etc.               */

/* VERBOSITY LEVELS */
/* These are the defines for Nping's internal verbosity levels. Every time
 * you write code for Nping and you have to print something to the terminal,
 * you'll have to choose a verbosity level. You choose a level so your message
 * gets printed only when the user has requested messages from that level to be
 * printed. For example, we have some calls to output functions that print out
 * things like "%d target IPs resolved". We don't want that message to always
 * get printed during  Nping's execution. We only want it out when the user
 * has increasse the verbosity.
 * 
 * So the thing here is that there are two things that should be taken
 * into account:
 *  1. The current verbosity level that user has supplied from the command line
 *  2. The verbosity level that we supply in our print calls ( outPrint(),
 *     outError(), etc...)
 *
 *  Fortunately Nping output functions already take care of checking the
 *  current verbosity level, so programmers only have to decide which level
 *  should they specify in their output calls. If you are a programmer and
 *  you are using outPrint(), outError() or outFatal() calls in Nping's code,
 *  you have to ask yourself: Do I want to print extra information that
 *  shouldn't be printed by default? Or am I printing important stuff like
 *  errors, etc, that should almost always be printed out?
 *
 *  In the first case, you will call the output function using a verbosity
 *  level of VB_0 or higher. Calls that specify VB_0 are printed by default
 *  as VB_0 is the base verbosity level. Calls that specify VB_1 get printed
 *  only when the user has incremented verbosity level by at least one using
 *  option "-v". Same with VB_2 for which the users needs to have specified
 *  either "-v2" or "-v -v".
 *
 *  In the other case, where you are printing errors etc, you have supply
 *  levels like QT_1, QT_2, QT_3 or QT_4. Those are called quiet levels.
 *  They are called quiet levels from a user point of view but they are
 *  verbose to us, programmers, because calls that supply QT_X levels almost
 *  always get printed. This is because base verbosity is VB_0 and that
 *  includes all QT_X levels. So you have to be careful with those. QT_ levels
 *  should only be used to print important stuff like fata errors, warnings,
 *  and some basic running time information. Level QT_4 is the quiet-est one
 *  and nothing is ever printed out.
 *
 *  Check the comments after each level definition to see how they should be
 *  used. Here are some examples:
 * 
 *  outFatal(QT_3,"createIPv4(): NULL pointer supplied.");
 *  outPrint(DBG_2,"Resolving specified targets...");
 *  outPrint(VB_0, "Raw packets sent: %llu ", this->stats.getSentPackets() );
 *
 * */

/* Less verbosity */
#define QT_4 0   /**< No output at all                                       */
#define QT_3 1   /**< Fatal error messages, help info, version number        */
#define QT_2 2   /**< Warnings and very limited output(just some statistics) */
#define QT_1 3   /**< Start and timing information but no sent/recv packets  */

/* Base level (QT_0 is provided for consistency but should not be used)      */
#define QT_0 4   /**< Normal info (sent/recv packes, statistics...) (DEFAULT */
#define VB_0 4   /**< Normal info (sent/recv packes, statistics...) (DEFAULT)*/

/* More verbosity */
#define VB_1 5   /**< Detailed information about times, flags, etc.          */
#define VB_2 6   /**< Very detailed information about packets,               */
#define VB_3 7   /**< Reserved for future use                                */
#define VB_4 8   /**< Reserved for future use                                */



/* DEBUGGING LEVELS */
#define DBG_0 30 /**< No debug information at all (DEFAULT)                  */
#define DBG_1 31 /**< Very important or high level debug information         */
#define DBG_2 32 /**< Important or medium level debug information            */
#define DBG_3 33 /**< Regular and low level debug information                */
#define DBG_4 34 /**< Messages only a real Nping freak would want to see     */
#define DBG_5 35 /**< Enables Nsock (and other libs) basic tracing           */
#define DBG_6 36 /**< Enables full Nsock (and other libs) tracing            */
#define DBG_7 37 /**< Reserved for future use                                */
#define DBG_8 38 /**< Reserved for future use                                */
#define DBG_9 39 /**< Reserved for future use                                */


#define MAX_IP_PACKET_LEN 65535   /**< Max len of an IP datagram             */
#define MAX_TCP_PAYLOAD_LEN 65495 /**< Max len of a TCP packet               */
#define MAX_UDP_PAYLOAD_LEN 65507 /**< Check comments in UDPHeader::setSum() */

#define MAX_DEV_LEN 128           /**< Max network interface name length     */

#define NO_NEWLINE 0x8000 /**< Used in outFatal(), outError() and outPrint() */

/** Bit count for number parsing functions */
#define RANGE_8_BITS  8
#define RANGE_16_BITS 16
#define RANGE_32_BITS 32
#define RANGE_64_BITS 64



/* General tunable defines  **************************************************/
#define NPING_NAME "Nping"
#define NPING_URL "http://nmap.org/nping"
#define NPING_VERSION "0.5.35DC1"

#define DEFAULT_VERBOSITY VB_0
#define DEFAULT_DEBUGGING DBG_0

#define DEFAULT_PACKET_COUNT 5          /**< No of probes sent to each target*/
#define DEFAULT_DELAY 1000              /**< Milliseconds between each probe */

 /** Millisenconds Nping waits for teplies after all probes have been  sent */
#define DEFAULT_WAIT_AFTER_PROBES 1000 

#define DEFAULT_IP_TTL 64               /**< Default IP Time To Live         */
#define DEFAULT_IP_TOS 0                /**< Default IP Type of Service      */

#define DEFAULT_IPv6_TTL 64             /**< Default IPv6 Hop Limit          */
#define DEFAULT_IPv6_TRAFFIC_CLASS 0x00 /**< Default IPv6 Traffic Class      */


#define DEFAULT_TCP_TARGET_PORT 80      /**< Default TCP target port         */
#define DEFAULT_UDP_TARGET_PORT 40125   /**< Default UDP target port         */
#define DEFAULT_UDP_SOURCE_PORT 53      /**< Default UDP source port         */
#define DEFAULT_TCP_WINDOW_SIZE 1480    /**< Default TCP Window size         */

/**< MTU used when user just supplies option -f but no MTU value */
#define DEFAULT_MTU_FOR_FRAGMENTATION 72   

#define DEFAULT_ICMP_TYPE 8  /**< Defualt ICMP message: Echo Request         */
#define DEFAULT_ICMP_CODE 0  /**< Default ICMP code: 0 (standard)            */

#define DEFAULT_ARP_OP 1   /**< Default ARP operation: OP_ARP_REQUEST      */

/* WARNING: This is the max length for UDP and TCP payloads. Whatever you set
 * here, it cannot exceed the worst case:
 * 65535 bytes - IPv6Header with options - TCP  Header with options. */
#define MAX_PAYLOAD_ALLOWED 65400

/* I've tested this on a GNU/Linux 2.6.24 and I've seen that if the length
 * of the whole IP packet is more than 16436 when using loopback interface or
 * more than 1500 when using a normal network interface, the kernel complains
 * and says "Message too long". This is obviously caused by the configured
 * MTU. So the thing is that altough we allow users to specify payloads up to
 * MAX_PAYLOAD_ALLOWED bytes, when we generate random payloads, we set our
 * on limit on 1500-20-20=1460 bytes. Let's be conservative and consider that
 * IP packet has 40bytes of options and TCP has 20. So max length should be
 * 1500-60-40 = 1400. */
#define MAX_RANDOM_PAYLOAD  1400
#define MAX_RECOMMENDED_PAYLOAD 1400


/* Cached hosts in resolveChached() and gethostbynameCached() */
#define MAX_CACHED_HOSTS 512
#define MAX_CACHED_HOSTNAME_LEN 512





#endif
