/*
 *
 * pipe to ansi .c
 * 
 * Written by Kraig Amador and Joshua J. Drake
 * 
 * convert |xx codes to ansi codes
 * see colors.txt for more info.
 */

#include "irc.h"
#include "ircaux.h"
#include "p2a.h"
#include "ninja.h"

u_char *
pipe_to_ansi(string)
   u_char *string;
{
   u_char *ptr, tmp[32], tmp2[32], tmp3[32], *fptr = UNULL;
   static u_char final[BIG_BUFFER_SIZE];
   int b, f, lastf = 7, bright = 0, blink = 0;

   if (!string || !*string)
      return empty_string;
   
   final[0] = '\0';
   fptr = final;
   ptr = string;
   while (*ptr && (fptr - final) < sizeof(final)-1)
     {
	if (*ptr == '|' && *(ptr + 1) && *(ptr + 2) && isxdigit(ptr[1]) && isxdigit(ptr[2]))
	  {
	     sscanf(ptr, "|%1x%1x", &b, &f);
	     *tmp = '\0';
	     *tmp2 = '\0';
	     *tmp3 = '\0';
	     if (f == 0 && b == 0)
	       {
		  f = 7;
		  lastf = 0;
	       }
	     if (lastf != f)
	       {
		  if (f > 7)
		    {
		       if ((f == 15) && (lastf == 7))
			 my_strncpy(tmp2, "1;", sizeof(tmp2)-1);
		       else
			 snprintf(tmp2, sizeof(tmp2)-1, "%s3%d;", bright ? "" : "1;", (f - 8));
		    }
		  else if (f < 8)
		    {
		       if (f == 7)
			 my_strncpy(tmp2, "0;", sizeof(tmp2)-1);
		       else
			 snprintf(tmp2, sizeof(tmp2)-1, "%s3%d;", bright ? "0;" : "", f);
		    }
		  tmp2[sizeof(tmp2)-1] = '\0';
	       }

	     if (b > 7)
	       snprintf(tmp3, sizeof(tmp3)-1, "5;4%d", (b - 8));
	     else if (b < 8)
	       snprintf(tmp3, sizeof(tmp3)-1, "4%d", b);
	     tmp3[sizeof(tmp3)-1] = '\0';
	     
	     snprintf(tmp, sizeof(tmp)-1, "[%s%sm", tmp2, tmp3);
	     tmp[sizeof(tmp)-1] = '\0';
	     lastf = f;
	     bright = (f > 7) ? 1 : 0;
	     blink = (b > 7) ? 1 : 0;
	     ptr += 3;
	     
	     strmcat(final, tmp, sizeof(final)-1);
	     fptr += my_strlen(tmp);
	  }
	else
	  *fptr++ = *ptr++;
     }
   /* terminate! */
   if (fptr - final >= sizeof(final)-1)
     fptr = final + sizeof(final) - 1;
   *fptr = '\0';
   return final;
}
