/*
 * ndcc.h: header file for ndcc.c
 *
 * Ninja IRC DCC offering code
 *
 * by Joshua J. Drake and Kraig Amador
 */

#ifndef __NDCC_H_
# define __NDCC_H_

#ifdef HAVE_DIRENT_H
# include <dirent.h>
#endif

typedef struct ndcc_files_stru
{
   struct ndcc_files_stru *next;
   u_char	*path;
   u_char	*name;
   size_t	size;
}	NDCCFile;

typedef struct ndcc_packs_stru
{
   struct ndcc_packs_stru *next;
   u_char	*desc;
   int		num_files;
   size_t	total_size;
   float	min_speed;
   NDCCFile	*endfiles;
   NDCCFile	*files;
}	NDCCPack;

	void 	process_ndcc _((u_char *, u_char *, u_char *));
	void	process_remote_ndcc _((u_char *, u_char *, u_char *, u_char *, u_char *));

	int	compar _((const struct dirent **, const struct dirent **));
	int	selectent _((SCANDIR_A3ATYPE));

#endif
