/*
 * friends.h: header file for friends.c
 * 
 * this file contains stuff that supports Ninja IRC's
 * friends list.
 * 
 * written by Kraig Amador with tweak from Joshua J. Drake
 */
#ifndef __friends_h
#define __friends_h

/* the values must match up */
#define FL_UMODE_STRING		"dfn"
#define FL_UMODE_AUTO_DCC      	((u_char) 0x1)
#define FL_UMODE_NO_FLOOD	((u_char) 0x2)
#define FL_UMODE_SECURE_NDCC	((u_char) 0x4)

/* the values must match up */
#define FL_CMODE_STRING		"acijnopuv"
#define FL_CMODE_AUTOOP		0x0001
#define FL_CMODE_CHOPS		0x0002
#define FL_CMODE_INVITE		0x0004
#define FL_CMODE_JOIN		0x0008
#define FL_CMODE_NOTIFY_INVITE	0x0010
#define FL_CMODE_OPS		0x0020
#define FL_CMODE_PROTECTED	0x0040
#define FL_CMODE_UNBAN		0x0080
#define FL_CMODE_VOICE		0x0100

/* begin friend structs */
typedef struct  fchanlist_stru
{
	struct	fchanlist_stru  *next;
	u_char	*channel;
	u_long	modes;
}	FChan;

typedef struct	fhostlist_stru
{
	struct	fhostlist_stru  *next;
	u_char	*host;
}	FHost;

typedef struct	friendslist_stru
{
	struct	friendslist_stru        *next;  /* pointer to next user entry */
	u_char	*nick;                  /* the monkey's nickname */
	FHost	*hosts;
	u_char	*password;              /* password */
	u_long	modes;                  /* user modes */
	FChan	*channels;
}	Friend;

/* Friend list head */
extern	Friend	*friend_list;

/* function prototypes */
	u_char	*make_salt _((u_char *));
	u_char	*recreate_cmode _((FChan *));
	u_char	*recreate_umode _((Friend *));
	FChan	*get_fchan _((Friend *, u_char *, int));
	Friend	*get_friend _((u_char *));
	FHost	*get_fhost _((Friend *, u_char *));
	Friend	*get_friend_by_nuh _((u_char *, u_char *, u_char *));
	Friend	*get_friend_by_mask _((u_char *));

/* routine prototpes */
	void	friends_channel_sync _((Channel *));
	/* checking for when things happen */
	Friend	*check_friend_autoget _((u_char *, u_char *, u_char *));
	void	check_friend_protection _((u_char *, Channel *, u_char *));
	void	check_friend_join _((Channel *, u_char *, u_char *, u_char *, u_int));
	void	check_friend_notify _((u_char *, u_char *, u_char *));
	void	check_friend_invite _((u_char *, u_char *, u_char *, u_char *));
	void	check_friend_kick _((u_char *, u_char *, u_char *, u_char *, u_char *));
	/* loading/saving them */
	int	load_friends _((int));
	int	save_friends _((int));
	/* /commands */
	void	friend_cmd _((u_char *, u_char *, u_char *));

	void	fcmd_add_host _((u_char *));

	void	adduser _((u_char *, u_char *, u_char *));
	void	addchannel _((u_char *, u_char *, u_char *));

#endif
