/*
 * dma.h
 * 
 * This file contains prototypes for the dynamically allocated memory functions in dma.c
 *
 * written by Joshua J. Drake
 * copyright (c) 1998
 */

#ifndef __dma_h_
#define __dma_h_

#include "irc.h"

#ifndef IN_IRCIO
/* aliases */
# define new_malloc	dma_Malloc
# define dma_malloc	dma_Malloc

# define new_free	dma_Free
# define dma_free	dma_Free

# define new_realloc	dma_ReAlloc
# define dma_realloc	dma_ReAlloc

# define malloc_strcpy	dma_strcpy
# define malloc_strcat	dma_strcat
# define malloc_strcat_ue	dma_strcat_ue

# define really_free	dma_ReallyFree
# define wait_new_free	dma_WaitFree
#endif

/* function prototypes */
	void	dma_Free _((void *));
	void	dma_WaitFree _((u_char **));
	void	dma_ReallyFree _((int));
	u_char	*dma_ReAlloc _((u_char *, int));
	u_char	*dma_Malloc _((int));
	int	dma_strcpy _((u_char **, u_char *));
	void	dma_strcat _((u_char **, u_char *));
	void	dma_strcat_ue _((u_char **, u_char *));
#ifdef DMA_DEBUG_INT
	void	save_dma_list _((void));
#endif

#endif
