/*
 * NETMAJ - network mahjongg -  Copyright Notice
 *     Copyright (C) 1994, 1995, 1996 Koji Suzuki (suz@kt.rim.or.jp)
 *
 *  You can redistribute it and/or modify this software under the terms 
 * of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 *  This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the author be held liable for any damages
 * arising from the use of this software.
 * See the gpl.text for more details.
 *
 *  If you would like to do something with NETMAJ that this copyright
 * prohibits (such as distributing it with a commercial product,
 * using portions of the source in some other program, etc.), please
 * contact the author (preferably via email).  Arrangements can
 * probably be worked out.
 *
 *  Koji Suzuki   : suz@kt.rim.or.jp
 */
/* $Id: server_kill.c,v 1.6 1996/08/31 08:14:38 suz Exp $ */

#include "pai.h"
#include "global.h"

int port = PORT_NUMBER;

#define USAGE "\
usage:\n\
    server_kill [-p port-number]\n"

main(argc,argv) char *argv[]; {
	SOCKETIO *ssp;
	int c;

	while ((c=getopt(argc,argv,"p:"))!=EOF) {
		switch(c) {
		case 'p':
			port = atoi(optarg);
			break;
		default:
			fprintf(stderr,USAGE);
			exit(1);
		}
	}

	ssp = ConnectSock( "localhost", port );
	if (ssp) {
		SockWrites(MSG_KILL, ssp);
		SockClose(ssp);
		sleep(1);
	}

	return 0;
}
