#!/usr/bin/env bash

#*****************************************************************************
# xtcross.sh version 1.0.0
# クロス集計データの作成
# Y.Hamuro
# 2003/01/07
#*****************************************************************************

#エラーメッセージ
function help {
cat >/dev/stderr <<EOF
------------------------
xtcross.sh version 1.0.0
------------------------
概要)クロス集計表を作成する。
書式) xtcross.sh -k 行になる項目名 -f 列になる項目名 -d セルの値の項目名 [-iファイル] [-o出力ファイル名] [-T ワークディレクトリ名]

例) xtcross.sh -k 顧客 -f 分類 -d 金額 -i dat.xt -o rsl.xt
EOF
exit 1
}

#パラメータのチェック＆セット
  rName='fold##.data'
  sName='fold##.test'
  while getopts ":k:f:d:i:o:h" opt; do
    case $opt in
      k  ) row=$OPTARG ;;
      f  ) col=$OPTARG ;;
      d  ) dat=$OPTARG ;;
      i  ) input=$OPTARG ;;
      o  ) output=$OPTARG ;;
      T  ) tmpD=$OPTARG ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done
  shift $(($OPTIND -1 ))

  if [ "$tmpD" = "" ]; then
     tmpD=/tmp
  fi
  if [ "$input" = "" ]; then
     input=/dev/stdin
  fi
  if [ "$output" = "" ]; then
     output=/dev/stdout
  fi
  if [ "$row" = "" ]; then
     help; exit 1
  fi
  if [ "$col" = "" ]; then
     help; exit 1
  fi
  if [ "$dat" = "" ]; then
     help; exit 1
  fi

TD=$tmpD/xxx$$
mkdir -p $TD

#必要項目を切り出し、tmpファイルで保存。
xtcut -f $row,$col,$dat -i $input -o $TD.a

#ユニーク顧客のリスト作成
xtcut -f $row -i $TD.a |
xtuniq -k $row -o $TD.cust

#ユニーク分類リストの作成 -> スクリプト作成
xtcut -f $col -i $TD.a |
xtuniq -k $col |
xt2txt |
gawk '{print "joinCls",$1}' > $TD.sh

#分類毎にファイルを分割する
xtsep -d $TD.sep.'$('$col')' -i $TD.a

#分類毎のファイルを顧客をキーにjoinする関数
function joinCls {
  xtjoin -n -k $row -m $TD.sep.$1 -f $dat:$1 -i $TD.cust -o $TD.p
  cp $TD.p $TD.cust
}

#ここでスクリプト実行
. $TD.sh

cat <$TD.cust >$output

rm -rf $tmpD/xxx*
#===============================================================
