/**
 * # CHAPTER #
 * ============================================================================
 * ʬϢΥإåե
 * ============================================================================
 */

#ifndef _CONDITION_H
#define _CONDITION_H

#include <readData.h>

/**
 * # STRUCT #
 * ʬ̥饹̷ι¤
 * +---------+-------+-------+---+-------+------+
 * |condition| cls0  | cls1  |...| clsN  | Total|
 * +---------+-------+-------+---+-------+------+
 * |    match|mCnt[0]|mCnt[1]|   |mCnt[N]| mtCnt|
 * +---------+-------+-------+---+-------+------+
 * |  unmatch|uCnt[0]|uCnt[1]|   |uCnt[N]| utCnt|
 * +---------+-------+-------+---+-------+------+
 * |     NULL|nCnt[0]|nCnt[1]|   |nCnt[N]|      |
 * +---------+-------+-------+---+-------+------+
 * |    Total|tCnt[0]|tCnt[1]|   |tCnt[N]| total|
 * |         |tShr[0]|tShr[1]|   |tShr[N]|      |
 * +---------+-------+-------+---+-------+------+
 *
 * +---------+-------+-------+---+-------+------+
 * |condition| cls0  | cls1  |...| clsN  | Total|
 * +---------+-------+-------+---+-------+------+
 * |    match|mmCnt[0]|mmCnt[1]|   |mmCnt[N]| mtCnt|
 * |         |mShr[0]|mShr[1]|   |mShr[N]| mtShr|
 * +---------+-------+-------+---+-------+------+
 * |  unmatch|uCnt[0]|uCnt[1]|   |uCnt[N]| utCnt|
 * |         |uShr[0]|uShr[1]|   |uShr[N]| utShr|
 * +---------+-------+-------+---+-------+------+
 * |     NULL|nCnt[0]|nCnt[1]|   |nCnt[N]|      |
 * +---------+-------+-------+---+-------+------+
 * |    Total|tCnt[0]|tCnt[1]|   |tCnt[N]| total|
 * |         |tShr[0]|tShr[1]|   |tShr[N]|      |
 * +---------+-------+-------+---+-------+------+
 * mShr[i]=mCnt[i]/mtCnt
 * uShr[i]=uCnt[i]/utCnt
 * mtShr=mtCnt/total
 * utShr=utCnt/total
 */
struct CndCnt {
  double uCnt[MaxClsLen]; /*unmatch,饹̷*/
  double mCnt[MaxClsLen]; /*match,饹̷*/
  double mRatio;          /*NULLͤȿǤmCntγ(uRatio=1-mRatio)*/
  int mCount;             /*matchμ·(ǡݥ󥿤η)*/
  int uCount;             /*unmatchμ·(ǡݥ󥿤η)*/
  int nCount;             /*mCount,uCount桢nullǡο*/
  double nCnt[MaxClsLen]; /*NULLͤΥ饹̷*/
  double uuCnt[MaxClsLen]; /*unmatch,饹̷(NULLθ)*/
  double mmCnt[MaxClsLen]; /*match,饹̷(NULLθ)*/
  double tCnt[MaxClsLen]; /*饹̷*/
  double utCnt;           /*unmatch total*/
  double utShr;           /*unmatch total*/
  double mtCnt;           /*match total*/
  double mtShr;           /*match total*/
  double total;           /*ȡ*/
  int    splitType;       /*spliting criteria(0:Gini,1:Entropy,2:GeoMean)*/
  double splitBefor;      /*value for spilitting criteria before splitting*/
  double splitAfter;      /*value for spilitting criteria after  splitting*/


  /*桼Υȥե*/
  struct Cost *cost;

  /*---------------------------------------------------*/
  /*ޥåޥḁ̊饹̥                 */
  /*                                                   */
  /* laplace estimateη׻ˡ                        */
  /*   p(i)=(Ni+1)/(k+N)                               */
  /*   k:饹=ClassSize                            */
  /*   Ni: 饹iη=cnt->xCnt[]                   */
  /*   N :                                       */
  /*                                                   */
  /* Ȥδˡ                                  */
  /*   xShrC : ȷפФƥ饹ȤΨ  */
  /*   xShrC=C(j)*xShr(j)/SUMi(C(i)*xShr(i))           */
  /*   where C(j)=SUMi(cost(j,i))                      */
  /*   cost(j,i)Ȥϥ饹jiͽ¬ȤΥ   */
  /*   Pazzani,at el, Reducing Misclassification Costs */
  /*---------------------------------------------------*/

  /*+Ȥʤ                            */
  double uShrRN[MaxClsLen];/*unmatch,饹̥*/
  double mShrRN[MaxClsLen];/*match,饹̥*/
  double tShrRN[MaxClsLen];/*饹̥*/

  /*+ȴ                            */
  double uShrRC[MaxClsLen]; /*unmatch,饹̥*/
  double mShrRC[MaxClsLen]; /*match,饹̥*/
  double tShrRC[MaxClsLen]; /*饹̥*/

  /*--------------------------------------------------------------*/
  /*splitting rule׻Ȥ˻ȤиΨؤݥ      */
  /*  optPrb==0 -> xShrRN                                         */
  /*  optPrb==1 -> xShrRC                                         */
  /*  optPrb==2 -> xShrLN                                         */
  /*  optPrb==3 -> xShrLC                                         */
  /*Υݥ󥿤νiniCndCnt()ˤƹԤ                 */
  /*--------------------------------------------------------------*/
  double *uShr;           /*unmatch,饹̥*/
  double *mShr;           /*match,饹̥*/
  double *tShr;           /*饹̥*/
};

/**
 * # PROTOTYPE #
 */
void	iniCndCnt( struct CndCnt *cnt, struct Cost *cost);
void	prnCndCnt( struct CndCnt *cnt);
void	clearCndCntCel(struct CndCnt *cnt);
void	cpyCndCnt(struct CndCnt *cntTo, struct CndCnt *cntFrom);
void	calCndCntSplit( struct CndCnt *cnt);
void	calCndCnt( struct CndCnt *cnt);
int	dominantClass(struct CndCnt *cnt);
double	calCndCntCost(struct CndCnt *cnt, struct Cost *cost, int class);

#endif
