/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб 2003/06/20                                           */
/*============================================================================*/
  
#include <musashi.h>
#include <sys/time.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <unistd.h>

#include <xtcalenderHelp.h>
struct mssComHelp comHelp={
  "xtcalender",   /* ޥ̾       */
  "1.0",          /* С       */
  HELPT,          /* ޥɥȥ */                                    
  HELPS,          /*              */
  HELPE,          /*            */
  HELPR,          /* ȥޥ     */
  HELPA,          /* Ծ         */ 
  HELPB,          /* ХݡȾ */
  HELPH           /* ۡڡ     */
};  

extern struct mssGlobalVariables mssGV;

void writeYear(int y, struct mssFPW *fpw){
  mssWriteInt(1900+y,fpw);
}

void writeMonth(int m, struct mssFPW *fpw){
  if(1+m<10){
    mssWriteInt(0,fpw);
  }
  mssWriteInt(1+m ,fpw);
}

void writeDay(int d, struct mssFPW *fpw){
  if(d<10){
    mssWriteInt(0,fpw);
  }
  mssWriteInt(d ,fpw);
}

void writeAllDate(struct tm *time, struct mssFPW *fpw){
  writeYear(time->tm_year,fpw);
  writeMonth(time->tm_mon,fpw);
  writeDay(time->tm_mday,fpw);
}

time_t getTimeByYMD(int y, int m, int d){
  struct tm cTime;

  cTime.tm_year=y ;
  cTime.tm_mon =m;
  cTime.tm_mday=d;
  cTime.tm_hour=11;
  cTime.tm_min=0;
  cTime.tm_sec=1;
  cTime.tm_isdst=-1;
  return(mktime(&cTime));
}

void writeBeginPad(time_t t,int cYear,int cMonth,int mon,struct mssFPW *fpw){
  struct tm *cTime;
  int days;
  int i;

  cTime=localtime(&t);
  if(mon) days=cTime->tm_wday-1;
  else    days=cTime->tm_wday-0;

  t-=86400*days;
  for(i=0; i<days; i++){
    cTime=localtime(&t);
    writeYear(cYear,fpw);
    mssWriteDlm(fpw);
    writeMonth(cMonth,fpw);
    mssWriteDlm(fpw);
    writeAllDate(cTime,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
    t+=86400;
  }
}

void writeEndPad(time_t t,int cYear,int cMonth,int mon,struct mssFPW *fpw){
  struct tm *cTime;
  int days;
  int i;

  cTime=localtime(&t);
  if(mon){
    if(cTime->tm_wday==0)      days=1;
    else if(cTime->tm_wday==1) days=0;
    else                       days=8-cTime->tm_wday;
  }else{
    if(cTime->tm_wday==0) days=0;
    else                  days=7-cTime->tm_wday;
  }

  for(i=0; i<days; i++){
    cTime=localtime(&t);
    writeYear(cYear,fpw);
    mssWriteDlm(fpw);
    writeMonth(cMonth,fpw);
    mssWriteDlm(fpw);
    writeAllDate(cTime,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
    t+=86400;
  }
}

/*----------------------------------------------------------------------------*/
/* ѥǥ󥰤θƣΥ                               */
/*----------------------------------------------------------------------------*/
void writeOneMonth(int cYear,int cMonth,int pad, int mon, struct mssFPW *fpw){
  time_t t;
  struct tm *cTime;
  t=getTimeByYMD(cYear,cMonth,1);

  if(pad) writeBeginPad(t,cYear,cMonth,mon,fpw);
  while(1){
    cTime=localtime(&t);
    if(cTime->tm_mon!=cMonth) break;

    writeYear(cTime->tm_year,fpw);
    mssWriteDlm(fpw);
    writeMonth(cTime->tm_mon,fpw);
    mssWriteDlm(fpw);
    writeAllDate(cTime,fpw);
    mssWriteRet(fpw);
    mssGV.outCnt++;
    t+=86400;
  }
  if(pad) writeEndPad(t,cYear,cMonth,mon,fpw);
}
 
int main(int argc, char *argv[]){
/*============================================================================*/
/* ץ                                                       */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* ϰ(200201:200212                                                     */
/*----------------------------------------------------------------------------*/
  MssOptRNG optRNG={
    ORNG,   /* ץ󥿥                                             */
    "R",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    NULL,   /* ǥե(ʸȤƻꤹ)                             */
    1,      /* ޤǶڤǿκ                             */
    190001, /* ͤκǾ                                                   */
    299912, /* ͤκ                                                   */
    RNGT,   /* ΥץΥȥ(Helpɽ)                         */
    RNGC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* Υѥǥ󥰤Ԥ                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optPAD={
    OFLG,   /* ץ󥿥                                             */
    "p",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    PADT,   /* ΥץΥȥ(Helpɽ)                         */
    PADC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* 򽵤κǽˤ(-pȤä)                           */
/*----------------------------------------------------------------------------*/
  MssOptFLG optMON={
    OFLG,   /* ץ󥿥                                             */
    "m",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    MONT,   /* ΥץΥȥ(Helpɽ)                         */
    MONC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* plain text                                                                 */
/*----------------------------------------------------------------------------*/
  MssOptFLG optTXT={
    OFLG,   /* ץ󥿥                                             */
    "t",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    TXTT,   /* ΥץΥȥ(Helpɽ)                         */
    TXTC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* եѥǥ쥯ȥ̾                                             */
/*----------------------------------------------------------------------------*/
  MssOptSTR optTMP={
    OSTR,   /* ץ󥿥                                             */
    "T",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    MssTempDir, /* ǥե                                               */
    1,      /* ʸκǾĹ                                               */
    MssFileNameMaxLen,  /* ʸκĹ                                   */
    TMPT,   /* ΥץΥȥ(Helpɽ)                         */
    TMPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
  void *opt[]={&optRNG,&optMON,&optPAD,&optOTF,&optZIP,&optTXT,&optTMP,NULL};
  
/*============================================================================*/
/* ѿ                                                             */
/*============================================================================*/
  struct mssHeader    *hdi; /*ϥե<head>Ǽ¤*/
  struct mssHeader    *hdo; /*ϥե<head>Ǽ¤*/
  struct mssFPR       *fpr; /*ϥե빽¤                */
  struct mssFPW       *fpw; /*ϥե빽¤                */
  
  char *dummyFldName[]={"year","month","date"};
  int   dummyFldCnt=3;
  char  dummyFName[MssFileNameMaxLen];

  int fYear,cYear,tYear,fMonth,cMonth,tMonth;
  time_t t;
  struct tm *cTime;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);       /* ʥʤɤν              */
  mssHelpDoc(opt,&comHelp,argc,argv);/* إ                                */
  mssSetOption(opt,argc,argv);       /* ޥɥץ              */
/*mssShowOption(opt);*/

  if(optMON.set && !optPAD.set){
    mssShowErrMsg("can not specify -m without -p");
    mssEnd(mssErrorNoDefault);
  }

  if(optRNG.set){
    fYear =*optRNG.from/100-1900;
    tYear =*optRNG.to  /100-1900;
    fMonth=*optRNG.from%100-1;
    tMonth=*optRNG.to  %100-1;
    if(fMonth>11 || fMonth<0 || tMonth>11 || tMonth<0){
      mssShowErrMsg("invalid month");
      mssEnd(mssErrorNoDefault);
    }
    /*Ƚ羮طå*/
    if(fYear>tYear || (fYear==tYear && fMonth>tMonth)){
      mssShowErrMsg("start month must be less than or eaqual to end month");
      mssEnd(mssErrorNoDefault);
    }

    t=getTimeByYMD(fYear,fMonth,1);

  }else{
    t=time(NULL);
    cTime=localtime(&t);
    fYear =tYear =cTime->tm_year;
    fMonth=tMonth=cTime->tm_mon;
    t=getTimeByYMD(fYear,fMonth,1);
  }

  /*ߡϥǡΥե̾*/
  sprintf(dummyFName,"%s/xt##%d-calender",optTMP.str,(int)getpid());

  /*֥󥯤xmlTableեϥեȤ*/
  mssCreateBlankXtFile(dummyFldName,dummyFldCnt,dummyFName);

  /*usedTempFileFlgONˤλ˻ưŪ˥եϺ롣*/
  mssGV.usedTempFileFlg=1;

  fpr=mssOpenFPR(dummyFName,4);   /* ϥե륪ץ         */
  hdi=mssReadHeader(fpr);         /* إåɤ߹             */

/*----------------------------------------------------------------------------*/
/*ϥإåκȽ                                                    */
/*----------------------------------------------------------------------------*/
  /*ϥإåν(ȥΥԡ)*/
  hdo=mssInitCpyHeader(hdi);

  /*ϥإåܤɲ*/
  mssAddFieldsByFields(hdo->flds,hdi->flds);

  /*ɸϥץ+إåν*/
  fpw=mssOpenFPW(optOTF.str,optZIP.set,0);
  mssWriteHeader(hdo, fpw);

/*----------------------------------------------------------------------------*/
/*ᥤ롼*/
/*----------------------------------------------------------------------------*/
/*tm_wday:0->*/

  cYear =fYear;
  cMonth=fMonth;
  while(1){

    writeOneMonth(cYear,cMonth,optPAD.set,optMON.set,fpw);

    cMonth++;
    if(cMonth>11){
      cYear++;
      cMonth=0;
    }
    if(cYear>tYear) break;
    if(cYear==tYear && cMonth>tMonth) break;
  }
  mssGV.inCnt=0;

/*----------------------------------------------------------------------------*/
/*եå&λ*/
/*----------------------------------------------------------------------------*/
  mssWriteFooter(fpw);    /*եåν              */
  mssCloseFPR(fpr);       /*ϥեΥ      */
  mssCloseFPW(fpw);       /*ϥեΥ      */
  mssFreeHeader(hdi);     /* ϥإåΰ賫         */
  mssFreeHeader(hdo);     /* ϥإåΰ賫         */
  mssFreeOption(opt);     /* ץΰ賫         */
  mssShowEndMsg();        /* λå             */
  mssEnd(mssExitSuccess); /* λ                       */
  return(0);              /* to avoid warning message   */
}
