/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;

public class TreeNodeID
implements Comparable {
    public static final int BYTESIZE = 6;
    public short depth;
    public int xpos;

    public TreeNodeID(short s, int n) {
        this.depth = s;
        this.xpos = n;
    }

    public TreeNodeID(TreeNodeID treeNodeID) {
        this.depth = treeNodeID.depth;
        this.xpos = treeNodeID.xpos;
    }

    public TreeNodeID getParentNodeID(int n) {
        return new TreeNodeID((short)(this.depth + 1), this.xpos / n);
    }

    public void toParent(int n) {
        this.depth = (short)(this.depth + 1);
        this.xpos /= n;
    }

    public void toNextSibling() {
        ++this.xpos;
    }

    public void toPreviousSibling() {
        --this.xpos;
    }

    public boolean isPossibleRoot() {
        return this.xpos == 0;
    }

    public boolean isLeaf() {
        return this.depth == 0;
    }

    public boolean equals(TreeNodeID treeNodeID) {
        return this.depth == treeNodeID.depth && this.xpos == treeNodeID.xpos;
    }

    public int compareTo(TreeNodeID treeNodeID) {
        if (this.depth == treeNodeID.depth) {
            if (this.xpos == treeNodeID.xpos) {
                return 0;
            }
            return this.xpos < treeNodeID.xpos ? -1 : 1;
        }
        return this.depth > treeNodeID.depth ? -1 : 1;
    }

    public int compareTo(Object object) {
        return this.compareTo((TreeNodeID)object);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.depth);
        dataOutput.writeInt(this.xpos);
    }

    public TreeNodeID(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.depth = dataInput.readShort();
        this.xpos = dataInput.readInt();
    }

    public String toString() {
        return "ID(" + this.depth + "," + this.xpos + ")";
    }

    public static final void main(String[] stringArray) {
        TreeMap<TreeNodeID, String> treeMap = new TreeMap<TreeNodeID, String>();
        for (int n = 4; n >= 0; n = (int)((short)(n - 1))) {
            short s = (short)(4 - n);
            int n2 = (int)Math.pow(2.0, n);
            for (int i = n2 - 1; i >= 0; --i) {
                treeMap.put(new TreeNodeID(s, i), new String("_" + n + ", " + i + "_"));
            }
        }
        Iterator iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            TreeNodeID treeNodeID = (TreeNodeID)iterator.next().getKey();
            if (treeNodeID.isPossibleRoot()) {
                System.out.println("\n" + treeNodeID);
                continue;
            }
            System.out.println(treeNodeID);
        }
    }
}

