# Ming/Slide
# $Id: $
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


require 'ming/slide/slidepage'
require 'ming/slide/slideitem'

require 'ming/ming'
include Ming

class SlideMovie

  attr_reader :movie, :width, :height, :title, :frame
  attr_accessor :controller

  @@font_path = ['.']

  def SlideMovie.font_path
	@@font_path
  end

  def initialize(title, width = 320, height = 240)
	@page = []
	@width = width
	@height = height
	@title = title

	@movie = SWFMovie.new
	@movie.set_dimension(width, height)
	@movie.add(SWFAction.new('stop();'))
#   maximize window
#   see also http://www.opaque.net/pipermail/ming-fun/2001-November/000511.html
#	max_win = %Q{
#      javascript:window.resizeTo(screen.availWidth, screen.availHeight);
#   }
#	@movie.add(SWFAction.new(%Q{
#      getURL('#{max_win}', '');
#      stop();
#    }))

	@controller

	SWFFont.font_path = @@font_path

  end

  def [](i)
	@page[i]
  end

  def newpage(effect = nil)
	s = SlidePage.new(self, @page.size + 1, effect)
	@page.push s

	s
  end

  def save(name)
	@movie.save(name)
  end

  def output
	@movie.output
  end

end
