#include <ming.h>
#include "ruby.h"
#include "mingc.h"

VALUE rb_cSWFVideoStream;

static VALUE
rb_SWFVideoStream_s_new(argc, argv, self)
	 VALUE self;
{
  struct RSWFVideoStream *stream = ALLOC(struct RSWFVideoStream);
  VALUE obj, filename;

  rb_scan_args(argc, argv, "01", &filename);

  if(NIL_P(filename))
  {
    stream->this = newSWFVideoStream();
  }
  else
  {
    FILE *fp;
    fp = fopen ( STR2CSTR(filename), "rb" );
    stream->option = fp;
    stream->this = newSWFVideoStream_fromFile(fp);
  }
  
  obj = Data_Wrap_Struct(rb_cSWFVideoStream, 0, rb_free_SWFVideoStream, stream);

  return obj;
}

void
rb_free_SWFVideoStream(p)
     struct RSWFVideoStream *p;
{
  FILE *fp = p->option;

  if(fp != NULL)
    fclose(fp);

  /* destroySWFVideoStream(p->this); */

  return;
}

static VALUE
rb_SWFVideoStream_set_dimension(self, w, h)
         VALUE self, w, h;
{
  struct RSWFVideoStream *vstream;

  Data_Get_Struct(self, struct RSWFVideoStream, vstream);
  SWFVideoStream_setDimension(vstream->this, (float) NUM2DBL(w), (float) NUM2DBL(h));

  return self;
}

static VALUE
rb_SWFVideoStream_get_num_frames(self)
	 VALUE self;
{
  struct RSWFVideoStream *m;
  
  Data_Get_Struct(self, struct RSWFVideoStream, m);

  return INT2NUM(SWFVideoStream_getNumFrames(m->this));
}


void
Init_swfvideostream()
{
  rb_cSWFVideoStream = rb_define_class_under(rb_mMing, "SWFVideoStream", rb_cObject);

  rb_define_singleton_method(rb_cSWFVideoStream, "new", rb_SWFVideoStream_s_new, -1);

  rb_define_method(rb_cSWFVideoStream, "set_dimension", rb_SWFVideoStream_set_dimension, 2);
  rb_define_method(rb_cSWFVideoStream, "get_num_frames", rb_SWFVideoStream_get_num_frames, 0);
}
