def cursor:
    file_name $(cursor_num)

def mmake:
    make 2>&1 | tee $MF3TEMP/mmake

    while true:
        cat $MF3TEMP/mmake | selector -r | scan -f \n '^(.+?):(\\d+):' | var file number
        if [ -e $file ] && [ $number -ge 0 ]:
            vim +$number $file
        else:
            break

    true # breakȴȥ꥿󥳡ɤʤΤǣˤƤ

def mgrep:
    grep -n $ARGV | tee $MF3TEMP/mgrep

    if [ $RCODE = 0 ]:
        while true:
            cat $MF3TEMP/mgrep | selector -r | scan -f \n '^(.+?):(\\d+):' | var file number
            if [ -e $file ] && [ $number -ge 0 ]:
                vim +$number $file
            else:
                break

    true # breakȴȥ꥿󥳡ɤʤΤ0ˤƤ

def toggle:
    if [ $ARGV[0] = 0 ]:
        print 1
    else:
        print 0

global VIEW_LIST_MODE=0
global VIEW_LIST_MODE_PERMISSION=0
global VIEW_LIST_MODE_NLINK=0
global VIEW_LIST_MODE_OWNER=0
global VIEW_LIST_MODE_GROUP=0
global VIEW_LIST_MODE_SIZE=0
global VIEW_LIST_MODE_MTIME=0
global VIEW_LIST_MODE_OPTION=0

def toggle_list_mode:
    if [ $VIEW_LIST_MODE = 0 ]:
        global VIEW_LIST_MODE=1

        global VIEW_LIST_MODE_PERMISSION=$VIEW_PERMISSION
        global VIEW_LIST_MODE_NLINK=$VIEW_NLINK
        global VIEW_LIST_MODE_OWNER=$VIEW_OWNER
        global VIEW_LIST_MODE_GROUP=$VIEW_GROUP
        global VIEW_LIST_MODE_SIZE=$VIEW_SIZE
        global VIEW_LIST_MODE_MTIME=$VIEW_MTIME
        global VIEW_LIST_MODE_OPTION=$VIEW_OPTION

        export VIEW_PERMISSION=1
        export VIEW_NLINK=1
        export VIEW_OWNER=1
        export VIEW_GROUP=1
        export VIEW_SIZE=1
        export VIEW_MTIME=1
        export VIEW_OPTION=1pain
    else:
        global VIEW_LIST_MODE=0

        export VIEW_PERMISSION=$VIEW_LIST_MODE_PERMISSION
        export VIEW_NLINK=$VIEW_LIST_MODE_NLINK
        export VIEW_OWNER=$VIEW_LIST_MODE_OWNER
        export VIEW_GROUP=$VIEW_LIST_MODE_GROUP
        export VIEW_SIZE=$VIEW_LIST_MODE_SIZE
        export VIEW_MTIME=$VIEW_LIST_MODE_MTIME
        export VIEW_OPTION=$VIEW_LIST_MODE_OPTION

global VIEW_NAMEONLY_MODE=0
global VIEW_NAMEONLY_MODE_PERMISSION=0
global VIEW_NAMEONLY_MODE_NLINK=0
global VIEW_NAMEONLY_MODE_OWNER=0
global VIEW_NAMEONLY_MODE_GROUP=0
global VIEW_NAMEONLY_MODE_SIZE=0
global VIEW_NAMEONLY_MODE_MTIME=0
global VIEW_NAMEONLY_MODE_OPTION=0

def toggle_nameonly_mode:
    if [ $VIEW_NAMEONLY_MODE = 0 ]:
        global VIEW_NAMEONLY_MODE=1

        global VIEW_NAMEONLY_MODE_PERMISSION=$VIEW_PERMISSION
        global VIEW_NAMEONLY_MODE_NLINK=$VIEW_NLINK
        global VIEW_NAMEONLY_MODE_OWNER=$VIEW_OWNER
        global VIEW_NAMEONLY_MODE_GROUP=$VIEW_GROUP
        global VIEW_NAMEONLY_MODE_SIZE=$VIEW_SIZE
        global VIEW_NAMEONLY_MODE_MTIME=$VIEW_MTIME
        global VIEW_NAMEONLY_MODE_OPTION=$VIEW_OPTION

        export VIEW_PERMISSION=0
        export VIEW_NLINK=0
        export VIEW_OWNER=0
        export VIEW_GROUP=0
        export VIEW_SIZE=0
        export VIEW_MTIME=0
        export VIEW_OPTION=1pain
    else:
        global VIEW_NAMEONLY_MODE=0

        export VIEW_PERMISSION=$VIEW_NAMEONLY_MODE_PERMISSION
        export VIEW_NLINK=$VIEW_NAMEONLY_MODE_NLINK
        export VIEW_OWNER=$VIEW_NAMEONLY_MODE_OWNER
        export VIEW_GROUP=$VIEW_NAMEONLY_MODE_GROUP
        export VIEW_SIZE=$VIEW_NAMEONLY_MODE_SIZE
        export VIEW_MTIME=$VIEW_NAMEONLY_MODE_MTIME
        export VIEW_OPTION=$VIEW_NAMEONLY_MODE_OPTION

global COLOR=0

def toggle_color:
    if [ $COLOR = 0 ]:
        global COLOR=1

        export COLOR_DIR=$ma_cyan
        export COLOR_EXE=$ma_red
        export COLOR_LINK=$ma_magenta
        export COLOR_MARK=$ma_yellow
    else:
        global COLOR=0

        export COLOR_DIR=$ma_bold
        export COLOR_EXE=$ma_bold
        export COLOR_LINK=0
        export COLOR_MARK=$ma_bold

defmenu view '2dir (a)ll' $key_a 'export VIEW_OPTION=2pain' '1dir(1)' $key_1 'export VIEW_OPTION=1pain' '1dir(2)' $key_2 'export VIEW_OPTION=1pain2' '1dir(3)' $key_3 'export VIEW_OPTION=1pain3' '1dir(5)' $key_5 'export VIEW_OPTION=1pain5' 'toggle (s)ize' $key_s 'export VIEW_SIZE=$(toggle $VIEW_SIZE)' 'toggle m(t)ime' $key_t 'export VIEW_MTIME=$(toggle $VIEW_MTIME)' 'toggle (u)ser' $key_u 'export VIEW_OWNER=$(toggle $VIEW_OWNER)' 'toggle (g)roup' $key_g 'export VIEW_GROUP=$(toggle $VIEW_GROUP)' 'toggle nl(i)nk' $key_i 'export VIEW_NLINK=$(toggle $VIEW_NLINK)' 'toggle (p)ermission' $key_p 'export VIEW_PERMISSION=$(toggle $VIEW_PERMISSION)' 'toggle fname (d)vide extension' $key_d 'export VIEW_DIVIDE_EXTENSION=$(toggle $VIEW_DIVIDE_EXTENSION)' 'toggle fname (f)ocus back' $key_f 'export VIEW_FOCUSBACK=$(toggle $VIEW_FOCUSBACK)' 'toggle (l)ist mode' $key_l 'toggle_list_mode' 'toggle (n)ameonly mode' $key_n 'toggle_nameonly_mode' 'toggle (c)olor' $key_c 'toggle_color' 'toggle (P)age view way' $key_P 'export VIEW_PAGE=$(toggle $VIEW_PAGE)' 'fil(e) size view way Normal' $key_e 'export VIEW_FILE_SIZE=Normal' 'fil(E) size view way Human' $key_E 'export VIEW_FILE_SIZE=Human' 'file (S)ize view way Plane' $key_P 'export VIEW_FILE_SIZE=Plane'

defmenu sort_and_mask '(n)ame' $key_n 'export SORT_KIND=name; reread -d all' '(N)ame reverse' $key_N 'export SORT_KIND=name_rev; reread -d all' '(e)xtension' $key_e 'export SORT_KIND=ext; reread -d all' '(E)xtension reverse' $key_E 'export SORT_KIND=ext_rev; reread -d all' '(s)ize' $key_s 'export SORT_KIND=size; reread -d all' '(S)ize reverse' $key_S 'export SORT_KIND=size_rev; reread -d all' '(t)ime' $key_t 'export SORT_KIND=time; reread -d all' '(T)ime reverse' $key_T 'export SORT_KIND=time_rev; reread -d all' '(u)ser' $key_u 'export SORT_KIND=user; reread -d all' '(U)ser reverse' $key_U 'export SORT_KIND=user_rev; reread -d all' '(g)roup' $key_g 'export SORT_KIND=group; reread -d all' '(G)roup reverse' $key_G 'export SORT_KIND=group_rev; reread -d all' '(p)ermission' $key_p 'export SORT_KIND=perm; reread -d all' '(P)ermission reverse' $key_P 'export SORT_KIND=perm_rev; reread -d all' '(r)andom' $key_r 'export SORT_KIND=random; reread -d all' 'none (0)' $key_0 'export SORT_KIND=none; reread -d all' 'toggle (d)ir up' $key_d 'export SORT_DIR_UP=$(toggle $SORT_DIR_UP); reread -d all' 'toggle (m)ark up' $key_m 'export SORT_MARK_UP=$(toggle $SORT_MARK_UP); reread -d all' '(M)ask' $key_M 'cmdline \'mask -dotdir 0; mask \\\'\\\'\' -2'

defmenu attribute 'ch(m)od (permission)' $key_m 'cmdline \'chmod  $$(markfiles)\' 6' 'ch(o)wn (owner)' $key_o 'cmdline \'chown  $$(markfiles)\' 6' 'ch(g)rp (group)' $key_g 'cmdline \'chgrp  $$(markfiles)\' 6' 'ch(M)od -R (permission recursive)' $key_M 'cmdline \'chmod -R  $$(markfiles)\' 9' 'ch(O)wn -R (owner recursive)' $key_O 'cmdline \'chown -R  $$(markfiles)\' 9' 'ch(G)rp -R (group recursive)' $key_G 'cmdline \'chgrp -R  $$(markfiles)\' 9' 'm(a)ttr (permission and date)' $key_a 'mattr $$(markfiles)'

keycommand 0 $key_up        '*' 'cursor_move -1'
keycommand 0 $key_ctrl_p    '*' 'cursor_move -1'
keycommand 0 $key_down      '*' 'cursor_move +1'
keycommand 0 $key_ctrl_n    '*' 'cursor_move +1'
keycommand 0 $key_enter     '.directory' 'mcd $(cursor)'
keycommand 0 $key_enter     '.mark' 'cmdline \' $$(markfiles)\' 0'
keycommand 0 $key_enter     '.link' 'if [ -d $(cursor) ] { mcd $(cursor) } else { cmdline " $(cursor)" 0 }'
keycommand 0 $key_enter     '*' 'cmdline " $(cursor)" 0'
keycommand 0 $key_x         '*' 'cmdline " ./$(cursor) " 0'
keycommand 0 $key_x         '.execute' 'cmdline "./$(cursor) "  -1'
keycommand 0 $key_backspace '*' 'mcd ..'
keycommand 0 $key_ctrl_h    '*' 'mcd ..'
keycommand 0 $key_tilda     '*' 'mcd ~'
keycommand 0 $key_backslash '*' 'mcd /'

def rename:
    ext=$(extname $(cursor))

    if [ -z "$ext" ]:
        cmdline -q "mrename -c -r $(cursor) $(cursor)" -1
    else:
        m=$(($(length "$(cursor)") - $(rindex "$(cursor)" .) + 1))
        cmdline -q "mrename -c -r $(cursor) $(cursor)" -$m

def regex_rename:
    for file in $$(markfiles) {
        if [ $file -re $ARGV[0] ]:
            puts "$$file -> $$(print $file | sub $ARGV[0] $ARGV[1])"
        else:
            puts "$$file -> $$file (not rename)"
    } | less

    if [ $(choise "rename ok?" no yes) = yes ]:
        for file in $$(markfiles) :
            if [ $file -re $ARGV[0] ]:
                puts "mrename $$file $$(print $file | sub $ARGV[0] $ARGV[1])"
                mrename $file $(print $file | sub $ARGV[0] $ARGV[1])
            else:
                puts "$$file (no rename)"

    reread

keycommand 0 $key_r         '*' 'rename'
keycommand 0 $key_r         '.mark' 'cmdline "regex_rename " -1'
keycommand 0 $key_c         '*' 'if [ $VIEW_OPTION = 2pain ] { mcp $(path -d sdir) } else { cmdline -q "mcp $(path)" -1 }'
keycommand 0 $key_C         '*' 'if [ $VIEW_OPTION = 2pain ] { cmdline \'cp -i -R $$(markfiles) \'"$(path -d sdir)" -1 } else { cmdline \'cp -i -R $$(markfiles) \'"$(path)" -1 }'
keycommand 0 $key_m         '*' 'if [ $VIEW_OPTION = 2pain ] { mmv $(path -d sdir) } else { cmdline -q "mmv $(path)" -1 }'
keycommand 0 $key_M         '*' 'if [ $VIEW_OPTION = 2pain ] { cmdline \'mv -i -R $$(markfiles) \'"$(path -d sdir)" -1 } else { cmdline \'mv -i -R $$(markfiles) \'"$(path)" -1 }'

keycommand 0 $key_l         '*' 'if [ $VIEW_OPTION = 2pain ] { mln $(path -d sdir) } else { cmdline -q "mln $(path)" -1 } '

keycommand 0 $key_b         '*' 'cmdline -q \'mbackup \'"$(cursor).bak" -5'
keycommand 0 $key_d         '*' 'if [ $(marking) = 1 ] && [ $(mchoise "move file to trashbox ok?" yes no) = yes ] { mtrashbox -f }'
keycommand 0 $key_D         '*' 'if [ $(marking) = 1 ] && [ $(mchoise "DELETE file ok?" yes no) = yes ] { mrm }'
keycommand 0 $key_p         '*' 'if [ $VIEW_OPTION = 2pain ] { m=$(length "$(path -d sdir)"); m=$(($m + 9)); cmdline "tar cvfz $(path -d sdir).tgz "\'$$(markfiles)\' $m } else { cmdline \'tar cvfz .tgz $$(markfiles)\' 9}'
keycommand 0 $key_P         '*' 'cmdline \'tar cvfz .tgz $$(markfiles)\' 9'
keycommand 0 $key_u         '.tgz' 'if [ $VIEW_OPTION = 2pain ] { cmdline "tar xvfz $(cursor) -C $(path -d sdir)" -1 } else { cmdline "tar xvfz $(cursor) -C $(path)" -1 }'
keycommand 0 $key_U         '.tgz' 'cmdline "tar xvfz $(cursor) -C $(path -d sdir)" -1'
keycommand 0 $key_k         '*' 'cmdline \'mkdir -p ""\' -2'
keycommand 0 $key_n         '*' 'cmdline \'touch ""\' -2'
keycommand 0 $key_h         '*' 'cmdline'
keycommand 0 $key_H         '*' 'cmdline -c'
keycommand 0 $key_e         '*' 'external -q \'vim $(cursor)\''
keycommand 0 $key_v         '*' 'external -q \'less $(cursor)\''
keycommand 0 $key_f         '*' 'isearch'
keycommand 0 $key_F         '*' 'cmdline "find .  | scan \'\./(.+)\' | vd" 7'
keycommand 0 $key_F         '.mark' 'cmdline \'find  $$(markfiles) | vd\' 5'
keycommand 0 $key_g         '*' 'cmdline "mgrep  * .*" 6'
keycommand 0 $key_g         '.mark' 'cmdline "mgrep -R   "\'$$(markfiles)\' 9'
keycommand 0 $key_G         '*' 'cmdline "grep  * .* | scan \'^(.+?):\' | uniq | vd" 5'
keycommand 0 $key_G         '.mark' 'cmdline \'grep -R  $$(markfiles) | scan "^(.+?):" | uniq | vd\' 8'
keycommand 0 $key_slash     '*' 'isearch'
keycommand 0 $key_q         '*' 'if [ $(mchoise quit\\? yes no) = yes ] { quit }'
keycommand 0 $key_ctrl_c    '*' 'if [ $(mchoise quit\\? yes no) = yes ] { quit }'
keycommand 0 $key_s         '*' 'menu sort_and_mask'
keycommand 0 $key_a         '*' 'menu attribute'
keycommand 0 $key_V         '*' 'menu view'
keycommand 0 $key_w         '*' 'adir=$(path); sdir=$(path -d sdir); mcd $sdir; mcd -d sdir $adir'
keycommand 0 $key_o         '*' 'mcd $(path -d sdir)'
keycommand 0 $key_O         '*' 'mcd -d sdir $(path)'
keycommand 0 $key_home      '*' 'mark -t -f -a'
keycommand 0 $key_end       '*' 'mark -t -a'
keycommand 0 $key_pageup    '*' 'cursor_move -10'
keycommand 0 $key_ctrl_u    '*' 'cursor_move -10'
keycommand 1 $key_v         '*' 'cursor_move -10'
keycommand 0 $key_pagedown  '*' 'cursor_move +10'
keycommand 0 $key_ctrl_d    '*' 'cursor_move +10'
keycommand 0 $key_ctrl_v    '*' 'cursor_move +10'
keycommand 0 $key_ctrl_a    '*' 'cursor_move 0'
keycommand 0 $key_ctrl_e    '*' 'cursor_move $(file_num)'

def scroll_left:
    if [ $(row) != 0 ]:
        cursor_move -$(line_max)

def scroll_right:
    if [ $(row) != $(($(row_max) -1)) ]:
        cursor_move +$(line_max)

keycommand 0 $key_left      '*' 'if [ $VIEW_OPTION = 2pain ] { activate 0 } else { scroll_left }'
keycommand 0 $key_ctrl_b    '*' 'if [ $VIEW_OPTION = 2pain ] { activate 0 } else { scroll_left }'
keycommand 0 $key_right     '*' 'if [ $VIEW_OPTION = 2pain ] { activate 1 } else { scroll_right }'
keycommand 0 $key_ctrl_f    '*' 'if [ $VIEW_OPTION = 2pain ] { activate 1 } else { scroll_right }'
keycommand 0 $key_space     '*' 'mark -t -n $(cursor_num); cursor_move +1'
keycommand 0 $key_ctrl_l    '*' 'mclear_immediately; reread -d 0; reread -d 1'
keycommand 0 $key_colon     '*' 'external "kitutuki"'

def run_file_manager:
    if [ uname -s | index -q CYGWIN ]:
        cygstart . &
    elif [ uname -s | index -q Darwin ]:
        open . &
    else:
        if [ ps axw | grep -v grep | index -q nautilus ]:
            nautilus "$PWD" 2>/dev/null
        elif [ ps axw | grep -v grep | index -q kdeinit ]:
            konqueror "$PWD" 2>/dev/null &
        elif [ ps axw | grep -v grep | index -q xfdesktop ]:
            thunar "$PWD" 2>/dev/null

keycommand 0 $key_exclam    '*' 'run_file_manager'

global DOT_MASK=0
keycommand 0 $key_dot       '*' 'if [ $DOT_MASK = 0 ] { global DOT_MASK=1; mask -dotdir 1; mask "^[^\.].+" } else { global DOT_MASK=0; mask -dotdir 0; mask ".+" }'

keycommand 0 $key_lbrack    '*' 'MARK_RANGE_BEGIN=$(cursor_num)'
keycommand 0 $key_rbrack    '*' 'if [ $MARK_RANGE_BEGIN != -1 ] { i=$MARK_RANGE_BEGIN; while [ $i -le $(cursor_num) ] { mark -t -n $i; i=$(($i + 1)) } }'

def glob_mark:
    for file in $ARGV :
        mark -t $file

keycommand 0 $key_star      '*' 'cmdline "glob_mark *" -1'

def regex_mark:
    for file in * .* :   # kitutuki.*...ϴޤޤʤ
        if [ $file -re $ARGV[0] ]:
            mark -t $file

keycommand 0 $key_plus      '*' "cmdline \"regex_mark ''\" -2"

keycommand 0 $key_meta_left  '*' 'mcd -'
keycommand 0 $key_meta_right '*' 'mcd +'
keycommand 1 $key_left       '*' 'mcd -'
keycommand 1 $key_right      '*' 'mcd +'

keycommand 0 $key_ctrl_t    '*' 'new_dir $(path)'
keycommand 0 $key_ctrl_w    '*' 'if [ $(dir_num) -gt 2 ] { del_dir -d adir; activate 0 }'
keycommand 0 $key_tab       '*' 'if [ $(adir) = 0 ] { activate 1 } else { activate 0 }'

keycommand 0 $key_1         '*' 'external -q "fg 1"'
keycommand 0 $key_2         '*' 'external -q "fg 2"'
keycommand 0 $key_3         '*' 'external -q "fg 3"'
keycommand 0 $key_4         '*' 'external -q "fg 4"'
keycommand 0 $key_5         '*' 'external -q "fg 5"'
keycommand 0 $key_6         '*' 'external -q "fg 6"'
keycommand 0 $key_7         '*' 'external -q "fg 7"'
keycommand 0 $key_8         '*' 'external -q "fg 8"'
keycommand 0 $key_9         '*' 'external -q "fg 9"'

keycommand 1 $key_0         '*' 'activate 0'
keycommand 1 $key_1         '*' 'activate 1'
keycommand 1 $key_2         '*' 'activate 2'
keycommand 1 $key_3         '*' 'activate 3'
keycommand 1 $key_4         '*' 'activate 4'
keycommand 1 $key_5         '*' 'activate 5'
keycommand 1 $key_6         '*' 'activate 6'
keycommand 1 $key_7         '*' 'activate 7'
keycommand 1 $key_8         '*' 'activate 8'
keycommand 1 $key_9         '*' 'activate 9'

def help:
    if which lv > /dev/null && index -q "$LANG" ja || index -q "$LC_ALL" ja:
        lv $MF3DOCDIR/usage.ja.txt 
    else :
        puts "UP, CTRL-P                        cursor up
        DOWN, CTRL-N                      cursor down
        LEFT, CTRL-B                      cursor left
        RIGHT, CTRL-F                     cursor right
        CTRL-A                            cursor top
        CTRL-E                            cursor bottom
        PAGEUP, CTRL-U, Meta-v            cursor up a lots
        PAGEDOWN, CTRL-D, CTRL-V          cursor down a lots
        BACKSPACE, CTRL-H                 move to parent direcotry
        \\                                move to root directory
        ~                                 move to home directory
        ENTER                             run cursor file(insert directory)
        q, CTRL_C                         quit
        CTRL+L                            reread diskt and redraw the screen
        SPACE                             mark file
        [                                 mark range begin
        ]                                 mark range end
        HOME                              mark all files without directory
        END                               mark all files
        *                                 glob mark
        +                                 regex mark
        .                                 toggle dot file mask
        c                                 copy mark files to other directory
        C                                 cp
        m                                 move mark files to other directory
        M                                 mv
        d                                 move mark files to $TRASHBOX_DIR
        D                                 delete mark files
        e                                 edit file(vim)
        v                                 view file(less)
        r                                 rename
        mark & r                          regex rename (for example, regex_rename '(.+)\\.c$' '$1.h')
        a                                 open attribute menu
        n                                 make new file
        k                                 make new direcotry
        b                                 make backup of file under cursor
        g                                 mgrep(grep and edit file)
        G                                 vgrep(virtual directory with grep)
        f,/                               incremental search
        F                                 virtual directory with find
        s                                 open sort and mask menu
        V                                 open view menu
        o,O                               copy direcotry path
        w                                 exchange two directories
        j                                 jump menu
        h                                 switch to command line mode
        x                                 excute under file
        l                                 make symbolic links with mark files to a other directory" | less

keycommand 0 $key_qmark         '*' 'help'

#########################################################################
# ޥå
##########################################################################
keymap   $key_up         27 91 65 -1 -1 -1 -1 -1 -1 -1
keymap   $key_up         27 79 65 -1 -1 -1 -1 -1 -1 -1
keymap   $key_down       27 91 66 -1 -1 -1 -1 -1 -1 -1
keymap   $key_down       27 79 66 -1 -1 -1 -1 -1 -1 -1
keymap   $key_right      27 91 67 -1 -1 -1 -1 -1 -1 -1
keymap   $key_right      27 79 67 -1 -1 -1 -1 -1 -1 -1
keymap   $key_left       27 91 68 -1 -1 -1 -1 -1 -1 -1
keymap   $key_left       27 79 68 -1 -1 -1 -1 -1 -1 -1
keymap   $key_insert     27 91 50 126 -1 -1 -1 -1 -1 -1
keymap   $key_delete     27 91 51 126 -1 -1 -1 -1 -1 -1
keymap   $key_backspace  127 -1 -1 -1 -1 -1 -1 -1 -1 -1
keymap   $key_home       27 79 72  -1  -1 -1 -1 -1 -1 -1
keymap   $key_home       27 91 72  -1  -1 -1 -1 -1 -1 -1
keymap   $key_home       27 91 55  126 -1 -1  -1 -1 -1 -1
keymap   $key_home       27 91 0   -1  -1 -1  -1 -1 -1 -1
keymap   $key_home       27 91 49  126 -1 -1  -1 -1 -1 -1
keymap   $key_end        27 79 70  -1  -1 -1  -1 -1 -1 -1
keymap   $key_end        27 91 70  -1  -1 -1  -1 -1 -1 -1
keymap   $key_end        27 91 56  126 -1 -1  -1 -1 -1 -1
keymap   $key_end        27 91 101 -1  -1 -1  -1 -1 -1 -1
keymap   $key_end        27 91 52  126 -1 -1  -1 -1 -1 -1
keymap   $key_pageup     27 91 53  126 -1 -1  -1 -1 -1 -1
keymap   $key_pageup     27 91 73  -1  -1 -1  -1 -1 -1 -1
keymap   $key_pagedown   27 91 54  126 -1 -1  -1 -1 -1 -1
keymap   $key_pagedown   27 91 71  -1  -1 -1  -1 -1 -1 -1
keymap   $key_f1         27 91 49  49  126 -1 -1 -1 -1 -1
keymap   $key_f1         27 79 80  -1  -1  -1 -1 -1 -1 -1
keymap   $key_f1         27 91 91  65  -1  -1 -1 -1 -1 -1
keymap   $key_f2         27 91 49  50  126 -1 -1 -1 -1 -1
keymap   $key_f2         27 79 81  -1  -1  -1 -1 -1 -1 -1
keymap   $key_f2         27 91 91  66  -1  -1 -1 -1 -1 -1
keymap   $key_f3         27 91 49  51  126 -1 -1 -1 -1 -1
keymap   $key_f3         27 79 82  -1  -1  -1 -1 -1 -1 -1
keymap   $key_f3         27 91 91  67  -1  -1 -1 -1 -1 -1
keymap   $key_f4         27 91 49  52  126 -1 -1 -1 -1 -1
keymap   $key_f4         27 79 83  -1  -1  -1 -1 -1 -1 -1
keymap   $key_f4         27 91 91  68  -1  -1 -1 -1 -1 -1
keymap   $key_f5         27 91 49  53  126 -1 -1 -1 -1 -1
keymap   $key_f5         27 91 91  69  -1  -1 -1 -1 -1 -1
keymap   $key_f6         27 91 49  55  126 -1 -1 -1 -1 -1
keymap   $key_f7         27 91 49  56  126 -1 -1 -1 -1 -1
keymap   $key_f8         27 91 49  57  126 -1 -1 -1 -1 -1
keymap   $key_f9         27 91 50  48  126 -1 -1 -1 -1 -1
keymap   $key_f10        27 91 50  49  126 -1 -1 -1 -1 -1
keymap   $key_f11        27 91 50  51  126 -1 -1 -1 -1 -1
keymap   $key_f12        27 91 50  52  126 -1 -1 -1 -1 -1
keymap   $key_meta_left  27 91 51   68  -1 -1 -1 -1 -1 -1 # gnome-terminal
keymap   $key_meta_left  27 91 49   59  51 68 -1 -1 -1 -1 # xterm
keymap   $key_meta_left  27 91 49   59  57 68 -1 -1 -1 -1 # mlterm
keymap   $key_meta_left  27 79 49   59  51 68 -1 -1 -1 -1 # screen
keymap   $key_meta_right 27 91 51   67  -1 -1 -1 -1 -1 -1 # gnome-terminal
keymap   $key_meta_right 27 91 49   59  51 67 -1 -1 -1 -1 # xterm
keymap   $key_meta_right 27 91 49   59  57 67 -1 -1 -1 -1 # mlterm
keymap   $key_meta_right 27 79 49   59  51 67 -1 -1 -1 -1 # screen
keymap   $key_meta_up    27 91 51   65  -1 -1 -1 -1 -1 -1 # gnome-terminal
keymap   $key_meta_up    27 91 49   59  51 65 -1 -1 -1 -1 # xterm
keymap   $key_meta_up    27 91 49   59  57 65 -1 -1 -1 -1 # mlterm
keymap   $key_meta_up    27 79 49   59  51 65 -1 -1 -1 -1 # screen
keymap   $key_meta_down  27 91 51   66  -1  -1  -1 -1 -1 -1 # gnome-terminal
keymap   $key_meta_down  27 91 49   59  51  66  -1 -1 -1 -1 # xterm
keymap   $key_meta_down  27 91 49   59  57  66  -1 -1 -1 -1 # mlterm
keymap   $key_meta_down  27 79 49   59  51  66  -1 -1 -1 -1 # screen

#########################################################################
# ץ˥塼
##########################################################################
ary_new JTITLE_LIST
ary_new JKEY_LIST
ary_new JDIR_LIST

def add_jump_menu:
    if [ $JTITLE_LIST_size -le 9 ]:
        print "($$JTITLE_LIST_size) $$ARGV[0]" | ary_add JTITLE_LIST
        print "$${key_$${JTITLE_LIST_size}}" | ary_add JKEY_LIST
    else:
        print "(0) $$ARGV[0]" | ary_add JTITLE_LIST
        print $key_0 | ary_add JKEY_LIST
        
    print $ARGV[0] | ary_add JDIR_LIST

    make_jump_menu

def clear_jump_menu:
    ary_clear JDIR_LIST
    ary_clear JKEY_LIST
    ary_clear JTITLE_LIST

    ary_new JTITLE_LIST
    ary_new JKEY_LIST
    ary_new JDIR_LIST

    make_jump_menu

def make_jump_menu:
    defmenu jump

    i=0
    while [ $i -lt $JDIR_LIST_size ]:
        addmenu jump $JTITLE_LIST[$i] $JKEY_LIST[$i] "mcd $JDIR_LIST[$i]"
        i=$(($i+1))

    addmenu jump ----------------- $key_a "external 'puts dummy'"
    addmenu jump '(A)dd current directory to jump menu' $key_A 'cmdline "add_jump_menu $(path -d adir)" -1'
    addmenu jump '(C)lear jump menu' $key_C 'clear_jump_menu'

def save_jump_menu:
    print > $MF3HOME/jmenu

    i=0
    while [ $i -lt $JTITLE_LIST_size ]:
        puts $JTITLE_LIST[$i] >> $MF3HOME/jmenu
        puts $JKEY_LIST[$i] >> $MF3HOME/jmenu
        puts $JDIR_LIST[$i] >> $MF3HOME/jmenu

        i=$(($i + 1))

def load_jump_menu:
    cat $MF3HOME/jmenu | each:
        if [ $(( ($NR-1) % 3 )) = 0 ]:
            | ary_add JTITLE_LIST
        elif [ $(( ($NR-1) % 3 )) = 1 ]:
            | ary_add JKEY_LIST
        elif [ $(( ($NR-1) % 3 )) = 2 ]:
            | ary_add JDIR_LIST

    make_jump_menu

###  ###
if [ -e $MF3HOME/jmenu ]:
    load_jump_menu
else:
    make_jump_menu

keycommand 0 $key_j '*' 'menu jump'

##########################################################################
# եå
##########################################################################
# ǥ쥯ȥ꤬ưȤ
MARK_RANGE_BEGIN=-1
def mcd_hook:
    # ARGV[0] ˰ưǥ쥯ȥֹ椬äƤޤ
    MARK_RANGE_BEGIN=-1

# ǥ쥯ȥ꤬ƥ֤ˤʤääȤ
def activate_hook:
    # ARGV[0] ˥ƥ֤ˤʤäǥ쥯ȥֹ椬äƤޤ
    true

# 뤬ưȤ
def cursor_move_hook:
    # ARGV[0] ˥ƥ֤ˤʤäǥ쥯ȥֹ椬äƤޤ
    true

# ޥɥ饤˰ܹԤȤ
def cmdline_hook:
    true

# λȤ
def atexit_hook:
    save_jump_menu
    save_stat

##########################################################################
# 
##########################################################################

def load_stat:
    <$MF3HOME/stat> | export VIEW_SIZE
    <$MF3HOME/stat> | export VIEW_OPTION
    <$MF3HOME/stat> | export VIEW_MTIME
    <$MF3HOME/stat> | export VIEW_OWNER
    <$MF3HOME/stat> | export VIEW_GROUP
    <$MF3HOME/stat> | export VIEW_NLINK
    <$MF3HOME/stat> | export VIEW_PERMISSION
    <$MF3HOME/stat> | export VIEW_DIVIDE_EXTENSION
    <$MF3HOME/stat> | export VIEW_FOCUSBACK
    <$MF3HOME/stat> | export VIEW_PAGE
    <$MF3HOME/stat> | export VIEW_FILE_SIZE

    <$MF3HOME/stat> | export COLOR_DIR
    <$MF3HOME/stat> | export COLOR_EXE
    <$MF3HOME/stat> | export COLOR_LINK
    <$MF3HOME/stat> | export COLOR_MARK

    <$MF3HOME/stat> | export SORT_KIND
    <$MF3HOME/stat> | export SORT_DIR_UP
    <$MF3HOME/stat> | export SORT_MARK_UP
    <$MF3HOME/stat> | export HISTORY_FILE
    <$MF3HOME/stat> | export HISTORY_SIZE
    <$MF3HOME/stat> | export TRASHBOX_DIR
    <$MF3HOME/stat> | export CMDLINE_COLOR

    <$MF3HOME/stat> | export PROMPT

    <$MF3HOME/stat> | export CMDLINE_ESCAPE_KEY_ENABLE
    <$MF3HOME/stat> | export VIEW_ADD_STAR_EXE

    close -q $MF3HOME/stat

def save_stat:
    print > $MF3HOME/stat

    puts $VIEW_SIZE >> $MF3HOME/stat
    puts $VIEW_OPTION >> $MF3HOME/stat
    puts $VIEW_MTIME >> $MF3HOME/stat
    puts $VIEW_OWNER >> $MF3HOME/stat
    puts $VIEW_GROUP >> $MF3HOME/stat
    puts $VIEW_NLINK >> $MF3HOME/stat
    puts $VIEW_PERMISSION >> $MF3HOME/stat
    puts $VIEW_DIVIDE_EXTENSION >> $MF3HOME/stat
    puts $VIEW_FOCUSBACK >> $MF3HOME/stat
    puts $VIEW_PAGE >> $MF3HOME/stat
    puts $VIEW_FILE_SIZE >> $MF3HOME/stat

    puts $COLOR_DIR >> $MF3HOME/stat
    puts $COLOR_EXE >> $MF3HOME/stat
    puts $COLOR_LINK >> $MF3HOME/stat
    puts $COLOR_MARK >> $MF3HOME/stat

    puts $SORT_KIND >> $MF3HOME/stat
    puts $SORT_DIR_UP >> $MF3HOME/stat
    puts $SORT_MARK_UP >> $MF3HOME/stat
    puts $HISTORY_FILE >> $MF3HOME/stat
    puts $HISTORY_SIZE >> $MF3HOME/stat
    puts $TRASHBOX_DIR >> $MF3HOME/stat
    puts $CMDLINE_COLOR >> $MF3HOME/stat

    puts $PROMPT >> $MF3HOME/stat

    puts $CMDLINE_ESCAPE_KEY_ENABLE >> $MF3HOME/stat
    puts $VIEW_ADD_STAR_EXE >> $MF3HOME/stat
    

if [ -e $MF3HOME/stat ]:
    load_stat
else:
    # 
    export VIEW_SIZE=0
    export VIEW_OPTION=2pain
    export VIEW_MTIME=0
    export VIEW_OWNER=0
    export VIEW_GROUP=0
    export VIEW_NLINK=0
    export VIEW_PERMISSION=0
    export VIEW_DIVIDE_EXTENSION=0
    export VIEW_FOCUSBACK=0
    export VIEW_PAGE=0
    export VIEW_FILE_SIZE=Human

    export COLOR_DIR=$ma_bold
    export COLOR_EXE=$ma_bold
    export COLOR_LINK=0
    export COLOR_MARK=$ma_bold

    export SORT_KIND=name
    export SORT_DIR_UP=1
    export SORT_MARK_UP=0

    export HISTORY_FILE=$MF3HOME/history
    export HISTORY_SIZE=1000
    export TRASHBOX_DIR=$MF3HOME/trashbox/
    export CMDLINE_COLOR=1

    export PROMPT='print "mfiler3 $VERSION with kitutuki $KITUTUKI_VERSION (c)Minato Daisuke 2004-2010 hit <?> for help"'

    export CMDLINE_ESCAPE_KEY_ENABLE=1
    export VIEW_ADD_STAR_EXE=1
