

defmenu("file_attr_sudo",
   "sudo ch(m)od (permission)", KEY_m, "cmdline_c('sudo chmod  %m', 12, nil)",
   "sudo ch(o)wn (owner)", KEY_o, "cmdline_c('sudo chown  %m', 12, nil)",
   "sudo ch(g)rp (group)", KEY_g, "cmdline_c('sudo chgrp  %m', 12, nil)",
   "sudo ch(M)od -R (permission recursive)", KEY_M, "cmdline_c('sudo chmod -R  %m', 15, nil)",
   "sudo ch(O)wn -R (owner recursive)", KEY_O, "cmdline_c('sudo chown -R  %m', 15, nil)",
   "sudo ch(G)rp -R (group recursive)", KEY_G, "cmdline_c('sudo chgrp -R  %m', 15, nil)",
   "sudo m(a)ttr (permission and date)", KEY_a, "shell('sudo mattr %m', 'mattr')");

def key_sudo_unpack()
    ext = cursor_ext()
    if ext == "gz" 
        if cursor_name().rindex(".tar.gz")
            if is_one_dir()
                cmdline_c('sudo tar xvfz %f -C %D', -1, nil)
            else
                cmdline_c('sudo tar xvfz %f -C %D2', -1, nil)
            end
        else
            cmdline_c('sudo gzip -d %F', -1, nil)
        end
    elsif ext == "bz2"
        if cursor_name().rindex(".tar.bz2")
            if is_one_dir()
                cmdline_c('sudo tar xvfj %f -C %D', -1, nil)
            else
                cmdline_c('sudo tar xvfj %f -C %D2', -1, nil)
            end
        else
            cmdline_c('sudo bzip2 -d %f', -1, nil)
        end
    elsif ext == "tar"
        if is_one_dir() 
            cmdline_c('sudo tar xvf %f -C %D', -1, nil) 
        else 
            cmdline_c('sudo tar xvf %f -C %D2', -1, nil)
        end
    elsif ext == "tgz"
        if is_one_dir()
            cmdline_c('sudo tar xvfz %f -C %D', -1, nil)
        else
            cmdline_c('sudo tar xvfz %f -C %D2', -1, nil)
        end
    elsif ext == "lzh"
        if is_one_dir()
            cmdline_c('%S cd %D; sudo lha x %F', adir_path().size() + 8, nil)
        else 
            cmdline_c('%S cd %D2; sudo lha x %F', sdir_path().size() + 8, nil)
        end
    elsif ext == "zip" || ext == "ZIP"
        if is_one_dir()
            cmdline_c('sudo unzip %f -d %D', -1, nil)
        else
            cmdline_c('sudo unzip %f -d %D2', -1, nil)
        end
    end
end

def key_sudo_Unpack()
    ext = cursor_ext()
    
    if ext == "gz"
        if cursor_name().rindex(".tar.gz")
            cmdline_c('sudo tar xvfz %f -C %D', -1, nil)
        else
            cmdline_c('sudo gzip -d %F', -1, nil)
        end
    elsif ext == "bz2"
        if cursor_name().rindex(".tar.bz2")
            cmdline_c('sudo tar xvfj %f -C %D', -1, nil)
        else
            cmdline_c('sudo bzip2 -d %f', -1, nil)
        end
    elsif ext == "tar"
        cmdline_c('sudo tar xvf %f -C %D', -1, nil)
    elsif ext == "tgz"
        cmdline_c('sudo tar xvfz %f -C %D', -1, nil)
    elsif ext == "zip" || ext == "ZIP"
        cmdline_c('sudo unzip %f -d %D', -1, nil)
    elsif ext == "lzh"
        cmdline_c('%S cd %D; sudo lha x %F', adir_path().size() + 8, nil)
    end
end

def key_sudo_excute()
    if File.stat(adir_path() + cursor_name()).executable? && !File.directory?(adir_path() + cursor_name())
        cmdline_c('sudo ./%f ', 0, nil)
    elsif cursor_name().rindex(".pl")
        cmdline_c('sudo perl %f ', 0, nil)
    elsif cursor_name().rindex(".py")
        cmdline_c('sudo python %f ', 0, nil)
    elsif cursor_name().rindex(".rb")
        cmdline_c('sudo ruby %f ', 0, nil)
    else
        cmdline_c('sudo  ./%f', 6, nil)
    end
end

def key_sudo_backup()
    cmdline_c("sudo cp #{CP_OPTION} %f '" + cursor_name() + '.bak\'', -1, nil)
end

defmenu("sudo-menu",
   "sudo (c)opy", KEY_c,   "if is_one_dir() then cmdline_c('sudo cp #{CP_OPTION} %m %D', -1, nil) else cmdline_c('sudo cp #{CP_OPTION} %m %D2', -1, nil) end",
   "sudo (m)v", KEY_m,      "if is_one_dir() then cmdline_c('sudo mv %m %D', -1, nil) else cmdline_c('sudo mv %m %D2', -1, nil) end",
   "sudo (d)elete",  KEY_d, "cmdline_c('sudo rm -R %m', 0, nil)",
   "sudo (r)ename", KEY_r, "cmdline_c('sudo mv %f %f', -1, nil)",
   "sudo (a)ttr menu",  KEY_a, "menu('file_attr_sudo')",
   "sudo (e)dit", KEY_e,   "shell('%q sudo $EDITOR %f', cursor_name_convert)",
   "sudo (v)iewer", KEY_v,     "shell('%q sudo $PAGER %f', cursor_name_convert)",
   "sudo (p)ack", KEY_p, "if is_one_dir() then cmdline_c('sudo tar cvfz %X.tgz %m', -8, nil) else cmdline_c('sudo tar cvfz %D2%X.tgz %m', -8, nil) end", 
   "sudo (P)ack", KEY_P,     "cmdline_c('sudo tar cvfz %X.tgz %m', -8, nil)",
   "sudo (u)npack", KEY_u,     "key_sudo_unpack()",
   "sudo (U)npack", KEY_U,     "key_sudo_Unpack()",
   "sudo ma(k)e dir", KEY_k,   "cmdline_noconvert(\"sudo mkdir -p ''\", -1, nil)", 
   "sudo (n)ew file", KEY_n,   "cmdline_noconvert(\"sudo touch ''\", -1, nil)",
   "sudo make (l)ink", KEY_l,  "if is_one_dir() then cmdline_c('sudo ln -s %M %D', -1, nil) else cmdline_c('sudo ln -s %M %D2', -1, nil) end",
   "sudo make (L)ink", KEY_L,  "cmdline_c('sudo ln -s %F %D', -1, nil)",
   "sudo (g)rep", KEY_g,       "cmdline_c(\"%q sudo grep '' * -n 2> /dev/null | $PAGER\", 15, nil)",
   "sudo (G)rep", KEY_G,       "cmdline_c(\"%q sudo grep -R '' * -n 2> /dev/null | $PAGER\", 17, nil)",
   "sudo e(x)ecute", KEY_x, "key_sudo_excute()",
   "sudo (b)ackup", KEY_b, "key_sudo_backup()",
   "sudo run shell(:)", KEY_COLON, "shell('%q echo \"-+- \"%D\" -+-\"; ls -aFG; sudo $SHELL', \"#{ENV['SHELL']}\")", 
   "sudo s(h)ell", KEY_h,   "cmdline_c('sudo ', 0, nil)"
   );

