

###############################################################################
# makeのラッパー
###############################################################################
def mmake(editor, line_option)
    if !mis_curses
        puts "curses is not running..."
        return
    end

    maxx = mgetmaxx()

    lines = []
    cursor = 0
    scroll_top = 0

    ### メイクを実行 ###
    mclear()
    mmove(0,0)
    #mmvprintw(0,0, "compiling...")
    mrefresh()

    mendwin()
    set_signal_clear()
    system("make 2>&1 | tee \"$MTEMP/mfiler_out_of_make\"")
    set_signal_mfiler2()
    minitscr()

    f = open("#{ENV['MTEMP']}/mfiler_out_of_make", "r")
    output = f.read()
    f.close()

    if output == ""
        mprintw("no output")
        mrefresh()
        mgetch()
        return
    end

    ### メイクの出力を行ごとにlinesに格納 ###
    i = 0
    tmp = ""
    while i < output.size()
        if output[i] == ?\n
            if tmp != ""
                lines.push(tmp)
            end
            tmp = ""
        else
            tmp = tmp + output[i].chr
        end

        i = i + 1
    end

    ### 画面サイズに併せてぶつ切り ###
    lines2 = []
    lines.each do |line|
        c = 0
        while c < line.size
            line2 = wstrcut(line[c..-1], maxx)
            c += line2.size
            lines2.push line2
        end
    end

    ### メインループ ###
    if lines2.size > 0 
        key = [0, 0]    
        while true
            ### 描写 ###
            mclear()
            n = scroll_top
            while n < lines2.size
                if cursor == n
                    mattron(MA_REVERSE)
                end
                
                mmvprintw(n-scroll_top, 0, "%s", lines2[n])
                
                if cursor == n
                    mattroff()
                end

                n += 1
            end
            
            mrefresh()

            ### インプット ###
            key = mgetch()

            if key[1] == 14 || key[1] == KEY_DOWN
                cursor = cursor + 1
            end
            if key[1] == 16 || key[1] == KEY_UP
                cursor = cursor -1
            end
            if key[1] == 4 || key[1] == KEY_PAGEDOWN
                cursor = cursor + mgetmaxy / 2
            end
            if key[1] == 21 || key[1] == KEY_PAGEUP
                cursor = cursor - mgetmaxy / 2
            end
            if key[1] == 12
                mclear
                mrefresh
            end

            if key[1] == KEY_q || key[1] == 3
                lines2 = []
                cursor = 0
                scroll_top = 0
                break;
            end
            if key[1] == 27 || key[1] == 7
                break;
            end
            
            if key[1] == 10 || key[1] == 13
                array = lines2[cursor].split(':')

                if !File.exist?(array[0])
                    output = msystem("find . -name #{array[0]}")
                    array2 = output.split
                    
                    if output.size != 0 && array2.size == 1
                        array[0] = output.chomp
                    end
                    if array2.size >  1
                        mclear()                    
                        mmvprintw(0,0, "find two or more " + array[1])
                        mrefresh()
                        mgetch()
                        
                        #array[0] = array2[0].chomp
                    end
                end

                if File.exist?(array[0]) && array[1].to_i != 0
                    # array[1] == line number
                    # array[0] == file name

                    mendwin()

                    system("#{editor} #{line_option}" + array[1] + " " + array[0])

                    minitscr()
                end
            end

            ### 修正 ###
            if cursor < 0
                cursor = 0
            end
            if cursor >= lines2.size
                cursor = lines2.size - 1
            end
            if cursor < scroll_top
                 scroll_top = cursor
            end
            if cursor > scroll_top + mgetmaxy() - 1
                scroll_top = scroll_top + (cursor-scroll_top-mgetmaxy()) + 1
            end
        end
    end

    reread(0)
    reread(1)
end
