#ifndef MFILER2_COMMON
#define MFILER2_COMMON

extern "C" 
{
#include "ruby.h"

extern VALUE ruby_errinfo;          // eval̃G[bZ[WŕKv

#define TAG_RETURN	0x1             // 
#define TAG_BREAK	0x2
#define TAG_NEXT	0x3
#define TAG_RETRY	0x4
#define TAG_REDO	0x5
#define TAG_RAISE	0x6
#define TAG_THROW	0x7
#define TAG_FATAL	0x8

#include "config.h"
#include "minato_extra.h"
#include "minato_debug.h"
#include "minato_list.h"
#include "minato_vector.h"
#include "minato_hash.h"
#include "minato_curses.h"

#include <termios.h>
}

#if defined(S_ISTXT)
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID|S_ISTXT)
#elif defined(S_ISVTX)
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID|S_ISVTX)
#else
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID)
#endif



///////////////////////////////////////////////////////////////////////////////
// cygwinpbP[W쐬MYCYGWINCOMPILE1
///////////////////////////////////////////////////////////////////////////////
//#define MYCYGWINCOMPILE 1

#if defined(MYCYGWINCOMPILE)
    extern char gProgramHome[PATH_MAX];
#endif

extern char gHomeDir[PATH_MAX];
extern char gTempDir[PATH_MAX];

///////////////////////////////////////////////////////////////////////////////
// menu.cppŒ`Ă
///////////////////////////////////////////////////////////////////////////////
#include "menu.h"

extern cMenu* gActiveMenu;
extern hash_obj* gMenu;
extern void set_signal_clear();
extern void set_signal_mfiler2();

///////////////////////////////////////////////////////////////////////////////
// dirwnd.cppŒ`Ă
///////////////////////////////////////////////////////////////////////////////
#include "dirwnd.h"

///////////////////////////////////////////////////////////////////////////////
// main.cppŒ`Ă
///////////////////////////////////////////////////////////////////////////////
extern cDirWnd* gLDir;
extern cDirWnd* gRDir;
extern hash_obj* gKeyCommand[2][KEY_MAX];
extern bool gMainLoop;
extern char gTrashBoxPath[PATH_MAX];        // ݔ̃fBNgpX

extern char* gVersion;                  // o[W

extern void (*gViewSystem)();         // o^`ʊ֐
extern void (*gView)();               // [U[po^`ʊ֐

void view(bool cmdline);        // ʕ` cmdline̓R}hC`ʂ邩ǂ

extern bool gColor;                 // J[\邩ǂ
extern bool gIndividualCursor;      // Ẽt@CʂŃJ[\ʒuƗĂ邩ǂ
extern bool gCheckDeleteFile;       // t@CɊmF邩ǂ
extern bool gCheckCopyFile;         // t@CRs[鎞ɊmF邩ǂ
extern bool gCheckExit;             // t@CI鎞ɊmFғ
extern bool gGnuScreen;             // GNU screenŋNĂ邩ǂ
extern bool gAutoRehash;            // R}hCI[gnbV
extern bool gUnixDomainSocket;      // UnixDomainSocketgǂ
extern bool gRemainCursor;          // J[\ʒuۑ邩ǂ
extern bool gProcessLine;
extern bool gReadDirHistory;
extern bool gExtensionICase;        // }[Nt@C̊gqʎső啶ʂ邩ǂ
extern bool gExecutiveFileBold;
extern enum eKanjiCode gKanjiCodeFileName; // t@C̊R[h kUnknown̏ꍇ͎

extern bool gBoldExe;
extern bool gBoldDir;
extern int gColorMark;
extern int gColorDir;
extern int gColorExe;
extern int gColorLink;

extern bool gChangeTerminalTitle;
extern void ruby_nkf(char* input, char* output, enum eKanjiCode code);
extern enum eKanjiCode ruby_kconv_guess(char* input);

///////////////////////////////////////////////////////////////////////////////
// command.cpp
///////////////////////////////////////////////////////////////////////////////
void command_init();
void command_final();

///////////////////////////////////////////////////////////////////////////////
// varibale.cpp
///////////////////////////////////////////////////////////////////////////////
void variable_init();
void variable_final();

///////////////////////////////////////////////////////////////////////////////
// cmdline.cpp
///////////////////////////////////////////////////////////////////////////////
const int kCmdLineMax = 8192;

extern bool gCmdLineActive;        // R}hCANeBuǂ
extern vector_obj* gCmdLine;       // R}hC̔z
extern int gCLCursor;              // R}hCqXg̃J[\
extern int gCursor;                // R}hC̃J[\
extern int gCursorBefore;
extern bool gCmdLineEscapeKey;     // R}hCEscapeL[ɂR}hCIǂ

extern READONLY vector_obj* gCCandidate;
extern READONLY vector_obj* gCExplanation;

extern READONLY vector_obj* gHCandidate;
extern int gHistorySize;            // qXg̍ő吔

extern VALUE gPrograms;             // vO⊮
extern VALUE gEnvirons;             // ϐ⊮

extern bool gDotDirMask;

extern bool gXterm;
extern bool gXtermNext;
extern bool gXterm2;

extern VALUE gXtermPrgName;
extern VALUE gXtermOptTitle;
extern VALUE gXtermOptEval;
extern VALUE gXtermOptExtra;
extern VALUE gXtermType;

extern char gShellName[256];
extern char gShellPath[256];
extern char gShellOptEval[256];

extern enum eKanjiCode gCmdLineEncode;          // R}hČ̊GR[h
extern VALUE gCmdAfterCmdlineRun;

void cmdline_init();                            // 
void cmdline_final();                           // p

void cmdline_input(int meta, int key);          // ͏
void cmdline_view();                            // `ʏ

void cmdline_start(char* cmd, int position);    // R}hCɓ
void cmdline_run(char* str, char* title);       // R}hCs
void cmdline_read_history_file();               // .mhistoryǂݍ
void cmdline_rehash();                          // vO⊮ēǂݍ

void cmdline_delete_last_str_if_length_0();     // R}hCqXg̍Ō̍sȂ

///////////////////////////////////////////////////////////////////////////////
// cmdline_completion.cppŒ`Ă
///////////////////////////////////////////////////////////////////////////////
extern int gCompletionScrollTop;
extern int gCompletionCursor;
extern bool gCompletionMenu;

void cmdline_init_after_reading_rc_file();      // RC filȅ

void cmdline_completion(VALUE all_candidate, char* editing, bool add_space);
void cmdline_completion2(VALUE all_candidate, char* editing, bool add_space, int candidate_len);
void cmdline_completion_clear();
void cmdline_completion_view();
void cmdline_completion_menu_input(int meta, int key);
void default_completion(char* editing_dir, char* editing_file, char* editing, int editing_position);
void completion_clear();

void cmdline_parse(char* cmdname, char* editing, char* editing_before, char* editing_dir, char* editing_file, int& editing_position, VALUE& earray, bool& squote, bool& dquote, bool& last_squote, bool& last_dquote);

void cmdline_completion_main();
void cmdline_completion_program(char* editing_dir, char* editing_file, char* editing, int editing_position);
void cmdline_completion_file(char* editing_dir, char* editing_file, char* editing, int editing_position);

///////////////////////////////////////////////////////////////////////////////
// cmdline_history.cppŒ`Ă
///////////////////////////////////////////////////////////////////////////////
extern int gHistoryScrollTop;
extern int gHistoryCursor;

void cmdline_history_view();
void cmdline_history_input(int meta, int key);

///////////////////////////////////////////////////////////////////////////////
// cmdline_macro.cppŒ`Ă
///////////////////////////////////////////////////////////////////////////////
extern ALLOCATED string_obj* extend_macro(char* in, RESULT bool* ruby_mode, RESULT bool* ruby_mode_nonoutput,RESULT bool* output, RESULT bool* quick, RESULT bool* shell_mode, RESULT bool* shell_mode2, RESULT bool* xterm_mode, RESULT bool* reset_marks,  bool flg, bool convert);

///////////////////////////////////////////////////////////////////////////////
// cmdline_alias.cppŒ`Ă
///////////////////////////////////////////////////////////////////////////////
extern vector_obj* gAlias;          // GCAX
const int kAliasMax = 65536;

struct sAlias
{
    char mAlias[kAliasMax];
    int mArgNum;
    char mCommand[kAliasMax];
};

void cmdline_alias_add(char* alias, int arg_num, char* cmd);
bool extend_alias(char* cmd, char* aliased_cmd);

///////////////////////////////////////////////////////////////////////////////
// shell.cppŒ`Ă
///////////////////////////////////////////////////////////////////////////////
#include "shell.h"

///////////////////////////////////////////////////////////////////////////////
// file.cpp
///////////////////////////////////////////////////////////////////////////////
enum eCopyOverride { kNone, kYesAll, kNoAll, kCancel, kSelectNewer };
extern eCopyOverride gCopyOverride;

enum eWriteProtected { kWPNone, kWPYesAll, kWPNoAll, kWPCancel };
extern eWriteProtected gWriteProtected;

bool file_copy(char* spath, char* dpath, bool move, bool preserve);
bool file_remove(char* path, bool no_ctrl_c, bool msg);

///////////////////////////////////////////////////////////////////////////////
// help.cpp
///////////////////////////////////////////////////////////////////////////////
extern bool gViewHelp;

void help_start();
void help_view();
void help_input(int meta, int key);

///////////////////////////////////////////////////////////////////////////////
// isearch
///////////////////////////////////////////////////////////////////////////////
#if defined(HAVE_MIGEMO_H)
extern "C"
{
#include "oniguruma.h"
#include "migemo.h"
}

extern migemo* gMigemo;
#endif

extern bool gISearch;           // CN^T[`ǂ
extern bool gISearchPartMatch;  // CN^T[`p[g}b`ǂ
extern bool gISearchExplore;           // GLXv[[CN^T[`
extern bool gNoPartMatchClear;         // ISearchClargISearchPartMatchNA邩ǂ
extern bool gISearchOption1;            // 擪CN^T[`s畔vCN^T[`IvV

bool IsISearchExploreChar(int meta, int key);  // ̕GNXv[[CN^T[`Ŏĝǂ
void ISearchClear();                // CN^T[`񏉊
bool IsISearchNULL();               // CN^T[`̕񂪋

void isearch_init_after_reading_rc_file();            // CN^T[`
void isearch_final();                                   // CN^T[`

void isearch_input(int meta, int key); // CN^T[`L[
void isearch_explore_input(int meta, int key); // GLXv[[CN^T[`L[
void isearch_view();                            // CN^T[``
void isearch_explore_view();                   // GLXv[[CN^T[``

void isearch_reload_migemo_dict();      // GR[hɂ킹migemo̎ă[h
///////////////////////////////////////////////////////////////////////////////
// super isearch
///////////////////////////////////////////////////////////////////////////////
extern bool gSISearch;
extern int gCandiateMaxAscii;
extern int gCandidateMaxMigemo;
extern bool gSISearchMigemo;

void sisearch_init();
void sisearch_final();
void sisearch_get_cache();
void sisearch_view();
void sisearch_input(int meta, int key);
bool sisearch_cache_exist();
void sisearch_start();
void sisearch_check();

///////////////////////////////////////////////////////////////////////////////
// extra
///////////////////////////////////////////////////////////////////////////////
extern bool correct_path(char* current_path, char* path, char* path2); // ΃pXȂǂ΃pX\ɂ
extern void output_eval_error(int error);          // rubyevalsG[΃G[\

extern void cut(char* src, char* dest, int len);
extern void cut2(char* src, char* dest, int len);

extern bool gErrMsgCancel;
extern int err_msg(char* msg, ...);        // R}hCɃG[bZ[W\ gErrMsgCancelfalseɂĂKv

extern void msg(char* msg, ...);           // R}hCɃbZ[W\
extern void msg_nonstop(char* msg, ...);   // R}hCɃbZ[W\iL[͑҂Ȃ)
extern int select_str(char* msg, char* str[], int len, int cancel);    // I
extern int input_box(char* msg, char* result, char* def_input, int def_cursor);        // R}hCŕ

// path2 must have enough space
extern void strtolower(char* result);

extern int msystem(char* line);

#endif

