/*  Window monitor / client manager
 *  Copyright (C) 2005 UCHINO Satoshi.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef CLIENTMGR_H
#define CLIENTMGR_H

#include "windowmonitor.h"
#include <map>
#include <string>

using namespace std;

class ClientMgr {
 public:
  struct IconPref {
    int bpp;
    int size;
    int formatType;
  };

 private:
  typedef map<unsigned long, string>   LocaleMap;
  typedef map<unsigned long, IconPref> IconPrefMap;
  LocaleMap	localePrefMap;
  IconPrefMap	iconPrefMap;

 public:
  void setMenuPref(unsigned long clientPtr, rfbServerDataMenuPrefReq *menuPref);
  void setIconPref(unsigned long clientPtr, rfbServerDataIconPrefReq *iconPref);
  void clientGone(unsigned long clientPtr);
  inline bool allGone() {
    return localePrefMap.empty() && iconPrefMap.empty();
  }

  const string* getLocalePref(unsigned long clientPtr);
  const IconPref* getIconPref(unsigned long clientPtr);
  typedef bool (*IconPrefCallback)(unsigned long clientPtr, const IconPref& iconPref, void *_this, void *param);
  bool foreachIconPref(IconPrefCallback func, void *_this, void* param);
};

#endif /*CLIENTMGR_H*/
