/**
 * @file libgalago-gtk/galago-gtk-contact-chooser-dialog.h
 *       Contact chooser dialog
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_CONTACT_CHOOSER_DIALOG_H_
#define _GALAGO_GTK_CONTACT_CHOOSER_DIALOG_H_

typedef struct _GalagoGtkContactChooserDialog      GalagoGtkContactChooserDialog;
typedef struct _GalagoGtkContactChooserDialogClass GalagoGtkContactChooserDialogClass;
typedef struct _GalagoGtkContactChooserDialogPriv  GalagoGtkContactChooserDialogPriv;

#include <libgalago-gtk/galago-gtk-contact-chooser.h>
#include <gtk/gtkdialog.h>

#define GALAGO_GTK_TYPE_CONTACT_CHOOSER_DIALOG (galago_gtk_contact_chooser_dialog_get_type())
#define GALAGO_GTK_CONTACT_CHOOSER_DIALOG(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_CONTACT_CHOOSER_DIALOG, GalagoGtkContactChooserDialog))
#define GALAGO_GTK_CONTACT_CHOOSER_DIALOG_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_CONTACT_CHOOSER_DIALOG, GalagoGtkContactChooserDialogClass))
#define GALAGO_GTK_IS_CONTACT_CHOOSER_DIALOG(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_CONTACT_CHOOSER_DIALOG))
#define GALAGO_GTK_IS_CONTACT_CHOOSER_DIALOG_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_CONTACT_CHOOSER_DIALOG))
#define GALAGO_GTK_CONTACT_CHOOSER_DIALOG_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_CONTACT_CHOOSER_DIALOG, GalagoGtkContactChooserDialogClass))

struct _GalagoGtkContactChooserDialog
{
	GtkDialog parent_object;

	GalagoGtkContactChooserDialogPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkContactChooserDialogClass
{
	GtkDialogClass parent_class;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_contact_chooser_dialog_get_type(void);

GtkWidget *galago_gtk_contact_chooser_dialog_new(
	const gchar *title, GtkWindow *parent,
	GalagoGtkContactChooserFlags flags,
	const gchar *first_button_text, ...);

G_END_DECLS

#endif /* _GALAGO_GTK_CONTACT_CHOOSER_DIALOG_H */
