/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CSVTokenizer
implements Enumeration {
    private String record;
    private String separator;
    private String quate;
    private int currentIndex;
    private boolean beforeStart;
    public static final String SEPARATOR_COMMA = ",";
    public static final String SEPARATOR_TAB = "\t";
    public static final String SEPARATOR_SPACE = " ";
    public static final String DOUBLE_QUATE = "\"";
    public static final String SINGLE_QUATE = "'";

    public CSVTokenizer(String aString, String theSeparator, String theQuate) {
        if (aString == null) {
            throw new NullPointerException("The given string is null");
        }
        if (theSeparator == null) {
            throw new NullPointerException("The given separator is null");
        }
        this.record = aString.trim();
        this.separator = theSeparator;
        this.quate = theQuate;
        this.currentIndex = 0;
        this.beforeStart = true;
    }

    public CSVTokenizer(String aString, String theSeparator) {
        this(aString, theSeparator, DOUBLE_QUATE);
    }

    public CSVTokenizer(String aString) {
        this(aString, SEPARATOR_COMMA);
    }

    public boolean hasMoreTokens() {
        return this.currentIndex < this.record.length();
    }

    public String nextToken() throws NoSuchElementException, IllegalArgumentException {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        if (!this.beforeStart) {
            this.currentIndex += this.separator.length();
        } else {
            this.beforeStart = false;
        }
        if (this.quate != null && this.record.startsWith(this.quate, this.currentIndex)) {
            int quateLength = this.quate.length();
            int startOffset = this.currentIndex + quateLength;
            StringBuffer b = new StringBuffer();
            while (true) {
                int end;
                if ((end = this.record.indexOf(this.quate, startOffset)) < 0) {
                    throw new IllegalArgumentException("Illegal format");
                }
                if (!this.record.startsWith(this.quate, end + 1)) {
                    b.append(this.record.substring(startOffset, end));
                    this.currentIndex = end + 1;
                    return b.toString();
                }
                b.append(this.record.substring(startOffset, end + 1));
                startOffset = end + quateLength * 2;
            }
        }
        int end = this.record.indexOf(this.separator, this.currentIndex);
        if (end >= 0) {
            int start = this.currentIndex;
            String token = this.record.substring(start, end);
            this.currentIndex = end;
            return token;
        }
        int start = this.currentIndex;
        String token = this.record.substring(start);
        this.currentIndex = this.record.length();
        return token;
    }

    public String nextToken(String theSeparator) {
        this.separator = theSeparator;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int preserve = this.currentIndex;
        boolean preserveStart = this.beforeStart;
        while (this.hasMoreTokens()) {
            this.nextToken();
            ++count;
        }
        this.currentIndex = preserve;
        this.beforeStart = preserveStart;
        return count;
    }

    public String getQuate() {
        return this.quate;
    }

    public void setQuate(String quate) {
        this.quate = quate;
    }
}

