'\" t
.\"     Title: xgetdevicemotionevents
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.75.2 <http://docbook.sf.net/>
.\"      Date: 08/04/2010
.\"    Manual: [FIXME: manual]
.\"    Source: [FIXME: source]
.\"  Language: English
.\"
.TH "XGETDEVICEMOTIONEVEN" "libmansuffix" "08/04/2010" "[FIXME: source]" "[FIXME: manual]"
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XGetDeviceMotionEvents, XDeviceTimeCoord \- get device motion history
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
XDeviceTimeCoord *XGetDeviceMotionEvents( Display *display,
                                          XDevice *device,
                                          Time start,
                                          Time stop,
                                          int *nevents_return,
                                          int *mode_return,
                                          int *axis_count_return);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
device
       Specifies the device whose motion history is to be
       queried\&.
.fi
.sp
.nf
start, stop
       Specify the time interval in which the events are
       returned from the motionhistory buffer\&.You can pass a
       timestamp or CurrentTime\&.
.fi
.sp
.nf
nevents_return
       Returns the number of events from the motion history
       buffer\&.
.fi
.sp
.nf
mode_return
       Returns the mode of the device (Absolute or Relative)\&.
.fi
.sp
.nf
axis_count_return
       Returns the count of axes being reported\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
The server may retain the recent history of the device motion
and do so to a finer granularity than is reported by
DeviceMotionNotify events\&. The XGetDeviceMotionEvents request
makes this history available\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XGetDeviceMotionEvents request returns all events in the
motion history buffer that fall between the specified start and
stop times, inclusive\&. If the start time is later than the stop
time or if the start time is in the future, no events are
returned\&. If the stop time is in the future, it is equivalent
to specifying CurrentTime\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The mode indicates whether the device is reporting absolute
positional data (mode = Absolute ) or relative motion data
(mode = Relative )\&. Some devices allow their mode to be changed
via the XSetDeviceMode request\&. These constants are defined in
the file XI\&.h\&. The axis_count returns the number of axes or
valuators being reported by the device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XGetDeviceMotionEvents can generate a BadDevice, or BadMatch
error\&.
.fi
.if n \{\
.RE
.\}
.sp
Structures
.sp
.if n \{\
.RS 4
.\}
.nf
The XDeviceTimeCoord structure contains:
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
typedef struct {
    Time time;
    int *data;
} XDeviceTimeCoord;
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The time member is set to the time, in milliseconds\&. The data
member is a pointer to an array of integers\&. These integers are
set to the values of each valuator or axis reported by the
device\&. There is one element in the array per axis of motion
reported by the device\&. The value of the array elements depends
on the mode of the device\&. If the mode is Absolute, the values
are the raw values generated by the device\&. These may be scaled
by client programs using the maximum values that the device can
generate\&. The maximum value for each axis of the device is
reported in the max_val field of the XAxisInfo returned by the
XListInputDevices request\&. If the mode is Relative, the data
values are the relative values generated by the device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
You should use XFreeDeviceMotionEvents to free the data
returned by this request\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
Errors returned by this request: BadDevice, BadMatch\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The specified device
       does not exist or has not been opened by this client via
       XOpenInputDevice\&. This error may also occur if the
       specified device is the X keyboard or X pointer device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadMatch
       This error may occur if an XGetDeviceMotionEvents
       request is made specifying a device that has no
       valuators and reports no axes of motion\&.
.fi
.if n \{\
.RE
.\}
