/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qlistview.h>
#include <qpushbutton.h>

#include "DlgSelectRepository.h"


/*
static struct
  {
    const char *  m_pTitle;
    int           m_cx;
  }
  g_columns[] =
    {
      { "Tag", -1 },
      { "Name", -1 }
    };
*/

#define ArraySize(a)  (sizeof(a) / sizeof((a)[0]))


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

DlgSelectRepository::DlgSelectRepository(QWidget *          pParent,
                                         QString            strTag,
                                         const Repo::List & repos)

  : BaseDlgSelectRepo(pParent, 0),
    m_repos(repos)

{
    Repo::List::const_iterator it;

    for ( it = m_repos.begin(); it != m_repos.end(); it++ )
    {
        QListViewItem * pItem = new QListViewItem(m_pListView, (*it)->getTag());
        pItem->setText(1, (*it)->getName());

        if ( strTag == (*it)->getTag() )
            pItem->setSelected(true);
    }

    connect(m_pListView, SIGNAL(currentChanged(QListViewItem *)),
            this,        SLOT(slotItemSelected(QListViewItem *)));

    connect(m_pListView, SIGNAL(selectionChanged(QListViewItem *)),
            this,        SLOT(slotItemSelected(QListViewItem *)));

    m_pButtonOk->setEnabled(!!m_pListView->currentItem());
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgSelectRepository::slotItemSelected(QListViewItem * pItem)
{
    m_pButtonOk->setEnabled(!!pItem);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgSelectRepository::accept()
{
    QString               strTag = m_pListView->currentItem()->text(0);
    Repo::List::iterator  it;

    for ( it = m_repos.begin(); it != m_repos.end(); it++ )
    {
        if ( (*it)->getTag() == strTag )
            m_ptrRepo = *it;
    }

    BaseDlgSelectRepo::accept();
}

#include "DlgSelectRepository.moc"
