/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include "kdialupstatusdlg.h"

#include <qlistview.h>
#include <qstring.h>
#include <kprocess.h>
#include <kdebug.h>
#include <qstringlist.h>

KDialupStatusDlg::KDialupStatusDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KDialupStatus(parent,name, modal,fl)
{
}

KDialupStatusDlg::~KDialupStatusDlg()
{
}

/*$SPECIALIZATION$*/
void KDialupStatusDlg::init(QString network, KProcess *tail)
{
    m_network = network;
    m_tailProcess = tail;
}

void KDialupStatusDlg::cancelConnect()
{
    emit disconnectNetwork(m_network);
    if (m_tailProcess) m_tailProcess->kill();
    close();
}

void KDialupStatusDlg::addEvent(QString event)
{
    //kdDebug() << "Log event: " << event << endl;
    //sometimes tail gives back mor than on line
    QListViewItem *item;
    item = new QListViewItem(lvEventHistory,event);
    if (item == NULL)
        return;
    lvEventHistory->ensureItemVisible(item);
    lvEventHistory->setSelected(item, false);

}



#include "kdialupstatusdlg.moc"

