/***************************************************************************
                          transponderdefinitiondialog.cpp  -  description
                             -------------------
    begin                : Sat Mar 22 2003
    copyright            : (C) 2003 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <qcombobox.h>
#include <kpushbutton.h>

#include "transponderdefinitiondialog.h"
#include "transponderdefinitiondetailsdialog.h"

transponderDefinitionDialog::transponderDefinitionDialog(QWidget *parent, const char *name,bool modal, const QString &caption, int buttonMask) : KDialogBase(parent,name,modal,caption,buttonMask) {
  mainwidget = new transponderDefinitionWidget(this);
  setMainWidget(mainwidget);
  setCaption(i18n("Transponder Definition"));
  enableButtonSeparator(true);
  QObject::connect(mainwidget->satelliteComboBox, SIGNAL(activated(const QString&)), this,SLOT(slotNewSat(const QString&)));
  QObject::connect(mainwidget->deleteButton, SIGNAL(clicked()), this, SLOT(slotDeleteTransponder()));
  QObject::connect(mainwidget->newButton, SIGNAL(clicked()), this, SLOT(slotNewTransponder()));
  QObject::connect(mainwidget->editButton, SIGNAL(clicked()), this, SLOT(slotEditTransponder()));
}
transponderDefinitionDialog::~transponderDefinitionDialog(){
}
/** No descriptions */
void transponderDefinitionDialog::setSatList(QList<satellite> s){
  satlist=s;
  // fill the combo box
  satellite* sat;
  for(sat=satlist.first(); sat!=0; sat=satlist.next()) {
    if (sat->polled())
      mainwidget->satelliteComboBox->insertItem(sat->name());
  }
  slotNewSat(mainwidget->satelliteComboBox->currentText());
}

/*!
    \fn transponderDefinitionDialog::slotNewSat(const QString&)
 */
void transponderDefinitionDialog::slotNewSat(const QString& str) {
  // delete the listbox
  mainwidget->transponderListBox->clear();
  //find the appropritate satellite
  satellite* sat;
  for(sat=satlist.first(); sat!=0; sat=satlist.next()) {
    if (sat->name() == str) break;
  }
  currentSat=sat;
  transponder* t;
  QString s;
  for (t=currentSat->translist()->first(); t!=0; t=currentSat->translist()->next()) {
    s = QString::number(t->uplink()/1000.0,'f',0) + "/" + QString::number(t->downlink()/1000.0,'f',0);
    mainwidget->transponderListBox->insertItem(s);
  }

}

/*!
    \fn transponderDefinitionDialog::slotDeleteTransponder()
 */
void transponderDefinitionDialog::slotDeleteTransponder()
{
  int position = mainwidget->transponderListBox->currentItem();
  fprintf(stderr, "Position %i\n", position);
  mainwidget->transponderListBox->removeItem(position);
  if (position >= 0) {
    currentSat->translist()->remove(position);
    mainwidget->transponderListBox->removeItem(position);
  }
}

/*!
    \fn transponderDefinitionDialog::slotEditTransponder()
 */
void transponderDefinitionDialog::slotEditTransponder()
{
  transponder* tr;
  int position = mainwidget->transponderListBox->currentItem();
  if (position >= 0) {
    tr=currentSat->translist()->at(position);
    transponderDefinitionDetailsDialog* luc = new transponderDefinitionDetailsDialog(tr, this);
    luc->exec();
  }
}

/*!
    \fn transponderDefinitionDialog::slotNewTransponder()
 */
void transponderDefinitionDialog::slotNewTransponder()
{
  transponder* newtransponder=new transponder();
  transponderDefinitionDetailsDialog* luc = new transponderDefinitionDetailsDialog(newtransponder,this);
  luc->exec();
  currentSat->translist()->append(newtransponder);
  QString s = QString::number(newtransponder->uplink()/1000.0,'f',0) + "/" + QString::number(newtransponder->downlink()/1000.0,'f',0);
  mainwidget->transponderListBox->insertItem(s);
}
