#ifndef SYNDAEMON_H
#define SYNDAEMON_H

#include <qobject.h>
#include <qthread.h>

#include <X11/Xlib.h>

class SynDaemon : public QObject, public QThread
{
    Q_OBJECT

    public:
        SynDaemon( QObject* parent, int msec );
        ~SynDaemon();
        void setTime( int msec );
        void run();
        void terminate();
        
    signals:
        void startTyping();
        void stopTyping();
        
    protected:
        volatile bool mTerminate;
        int mTimeOut;

        void clearBit( unsigned char* ptr, int bit );
        
        bool hasKeyboardActivity();
        bool hasPadButtonActivity();
        
        Display *mDisplay;
        
        static const unsigned int KEYMAP_SIZE;
        static unsigned char *mKeyboardMask;
};

#endif

