/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDSENDER_H_
#define _KKDSENDER_H_

#include <qobject.h>
#include <qvaluelist.h>
#include <qcstring.h>

//BEGIN class declaration
class QString;
typedef QValueList<QCString> QCStringList;

namespace KIO
{
	class Job;
}
//END

namespace KKDSubscribeTemplate
{
	class KKDSender : QObject
	{
		Q_OBJECT
	public:
		KKDSender( QObject* parent = 0 );
		virtual ~KKDSender();
		QString addText( const QString& name, const QString& value );
		QString addFile( const QString& name, const QString& value );
		bool send();

	signals:
		void complete();

	private:
		QCStringList m_strsFormData;
		QCString m_strResult;

	private slots:
		void data( KIO::Job*, const QByteArray& );
		void result( KIO::Job* );
	};
}

#endif /* _KKDSENDER_H_ */
