/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdinputtextdialog.h"

#include <ktextedit.h>
#include <klocale.h>

using namespace KKDesigner;

KKDInputTextDialog::KKDInputTextDialog( QWidget* parent, const char* name )
	: KDialogBase( Swallow, i18n( "Text" ), Ok|Cancel, Ok, parent, name, true )
{
	m_edit = new KTextEdit( this );
	setMainWidget( m_edit );
	resize( configDialogSize( "KKDInputTextDialog" ) );
}


KKDInputTextDialog::~KKDInputTextDialog()
{
	saveDialogSize( "KKDInputTextDialog" );
}

QString KKDInputTextDialog::input( const QString& str, QWidget* parent, const char* name )
{
	KKDInputTextDialog dlg( parent, name );
	dlg.m_edit->setText( str );
	if( dlg.exec() == Accepted )
	{
		return dlg.m_edit->text();
	}
	return QString::null;
}
