/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKAGROUP_H_
#define _KKAGROUP_H_

#include <klistview.h>
#include <qdom.h>
#include <qptrlist.h>

namespace KKAddressBook
{
	class KKAContactData;

	class KKAGroup : public KListViewItem
	{
	public:
		KKAGroup( QListView* parent );
		KKAGroup( QListView* parent, QDomNode& node );
		KKAGroup( QListViewItem* parent );
		KKAGroup( QListViewItem* parent, QDomNode& node );
		virtual ~KKAGroup();

		static const char* tagName(){ return "group"; }
		QDomElement toElement( QDomDocument& doc );
		void plug( QListView* lvw );
		void unplug( QListView* lvw );
		void cache( QListView* lvw );

		void addPrintData( QPtrList<KKAContactData>& data );
		void addImportData( KKAContactData* data );
	private:
		void readData( QDomNode& node );
		QPtrList<KKAContactData> m_list;
	};
}

#endif /* _KKAGROUP_H_ */
